/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.sink;

import java.io.IOException;
import java.nio.file.Path;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.sink.AuditLogSink;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.threadpool.ThreadPool;

public final class InternalOpenSearchSink
extends AuditLogSink {
    private final Client clientProvider;
    final String index;
    final String type;
    private DateTimeFormatter indexPattern;
    private final ThreadPool threadPool;

    public InternalOpenSearchSink(String name, Settings settings, String settingsPrefix, Path configPath, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink) {
        super(name, settings, settingsPrefix, fallbackSink);
        this.clientProvider = clientProvider;
        Settings sinkSettings = this.getSinkSettings(settingsPrefix);
        this.index = sinkSettings.get("index", "'security-auditlog-'YYYY.MM.dd");
        this.type = sinkSettings.get("type", null);
        this.threadPool = threadPool;
        try {
            this.indexPattern = DateTimeFormat.forPattern((String)this.index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Unable to parse index pattern due to {}. If you have no date pattern configured you can safely ignore this message", (Object)e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        if (Boolean.parseBoolean(HeaderHelper.getSafeFromHeader(this.threadPool.getThreadContext(), "_opendistro_security_conf_request"))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("audit log of audit log will not be executed");
            }
            return true;
        }
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            IndexRequestBuilder irb = ((IndexRequestBuilder)this.clientProvider.prepareIndex(this.getExpandedIndexName(this.indexPattern, this.index)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(msg.getAsMap());
            this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
            irb.setTimeout(TimeValue.timeValueMinutes((long)1L));
            irb.execute().actionGet();
            boolean bl = true;
            return bl;
        }
    }
}

