/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZipUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(ZipUtils.class);

    public static void unzip(File zipFile, Path dest) {
        try (ZipFile unzipFile = new ZipFile(zipFile);){
            Enumeration en = unzipFile.getEntries();
            while (en.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)en.nextElement();
                String name = zipEntry.getName();
                Path file = dest.resolve(name).toAbsolutePath();
                if (!file.normalize().startsWith(dest.toAbsolutePath())) {
                    throw new RuntimeException("Bad zip entry");
                }
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Path parentFile = file.getParent();
                if (parentFile == null) {
                    throw new AssertionError((Object)("Parent path should never be null: " + String.valueOf(file)));
                }
                Files.createDirectories(parentFile, new FileAttribute[0]);
                InputStream inputStream = unzipFile.getInputStream(zipEntry);
                try {
                    Files.copy(inputStream, file, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Wrong input file", e);
        }
    }
}

