/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.encryptor;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.indices.MLIndicesHandler;

public class EncryptorImpl
implements Encryptor {
    @Generated
    private static final Logger log = LogManager.getLogger(EncryptorImpl.class);
    public static final String MASTER_KEY_NOT_READY_ERROR = "The ML encryption master key has not been initialized yet. Please retry after waiting for 10 seconds.";
    private ClusterService clusterService;
    private Client client;
    private volatile String masterKey;
    private MLIndicesHandler mlIndicesHandler;

    public EncryptorImpl(ClusterService clusterService, Client client, MLIndicesHandler mlIndicesHandler) {
        this.masterKey = null;
        this.clusterService = clusterService;
        this.client = client;
        this.mlIndicesHandler = mlIndicesHandler;
    }

    public EncryptorImpl(String masterKey) {
        this.masterKey = masterKey;
    }

    @Override
    public void setMasterKey(String masterKey) {
        this.masterKey = masterKey;
    }

    @Override
    public String getMasterKey() {
        return this.masterKey;
    }

    @Override
    public String encrypt(String plainText) {
        this.initMasterKey();
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.masterKey);
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, "AES"), (String)"Custom", (String)"", (String)"AES/GCM/NOPADDING");
        CryptoResult encryptResult = crypto.encryptData((MasterKeyProvider)jceMasterKey, plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString((byte[])encryptResult.getResult());
    }

    @Override
    public String decrypt(String encryptedText) {
        this.initMasterKey();
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.masterKey);
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, "AES"), (String)"Custom", (String)"", (String)"AES/GCM/NOPADDING");
        CryptoResult decryptedResult = crypto.decryptData((MasterKeyProvider)jceMasterKey, Base64.getDecoder().decode(encryptedText));
        return new String((byte[])decryptedResult.getResult());
    }

    @Override
    public String generateMasterKey() {
        byte[] keyBytes = new byte[32];
        new SecureRandom().nextBytes(keyBytes);
        String base64Key = Base64.getEncoder().encodeToString(keyBytes);
        return base64Key;
    }

    private void initMasterKey() {
        if (this.masterKey != null) {
            return;
        }
        AtomicReference exceptionRef = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.mlIndicesHandler.initMLConfigIndex((ActionListener<Boolean>)ActionListener.wrap(r -> {
            if (!r.booleanValue()) {
                exceptionRef.set(new RuntimeException("No response to create ML Config index"));
                latch.countDown();
            } else {
                GetRequest getRequest = new GetRequest(".plugins-ml-config").id("master_key");
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    this.client.get(getRequest, ActionListener.wrap(getResponse -> {
                        if (getResponse == null || !getResponse.isExists()) {
                            IndexRequest indexRequest = new IndexRequest(".plugins-ml-config").id("master_key");
                            String generatedMasterKey = this.generateMasterKey();
                            indexRequest.source((Map)ImmutableMap.of((Object)"master_key", (Object)generatedMasterKey, (Object)"create_time", (Object)Instant.now().toEpochMilli()));
                            indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            indexRequest.opType(DocWriteRequest.OpType.CREATE);
                            this.client.index(indexRequest, ActionListener.wrap(indexResponse -> {
                                this.masterKey = generatedMasterKey;
                                log.info("ML encryption master key initialized successfully");
                                latch.countDown();
                            }, e -> {
                                if (ExceptionUtils.getRootCause((Throwable)e) instanceof VersionConflictEngineException) {
                                    GetRequest getMasterKeyRequest = new GetRequest(".plugins-ml-config").id("master_key");
                                    try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                                        this.client.get(getMasterKeyRequest, ActionListener.wrap(getMasterKeyResponse -> {
                                            if (getMasterKeyResponse != null && getMasterKeyResponse.isExists()) {
                                                String masterKey;
                                                this.masterKey = masterKey = (String)getMasterKeyResponse.getSourceAsMap().get("master_key");
                                                log.info("ML encryption master key already initialized, no action needed");
                                                latch.countDown();
                                            } else {
                                                exceptionRef.set(new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                                                latch.countDown();
                                            }
                                        }, error -> {
                                            log.debug("Failed to get ML encryption master key", (Throwable)e);
                                            exceptionRef.set(error);
                                            latch.countDown();
                                        }));
                                    }
                                } else {
                                    log.debug("Failed to index ML encryption master key", (Throwable)e);
                                    exceptionRef.set(e);
                                    latch.countDown();
                                }
                            }));
                        } else {
                            String masterKey;
                            this.masterKey = masterKey = (String)getResponse.getSourceAsMap().get("master_key");
                            log.info("ML encryption master key already initialized, no action needed");
                            latch.countDown();
                        }
                    }, e -> {
                        log.debug("Failed to get ML encryption master key from config index", (Throwable)e);
                        exceptionRef.set(e);
                        latch.countDown();
                    }));
                }
            }
        }, e -> {
            log.debug("Failed to init ML config index", (Throwable)e);
            exceptionRef.set(e);
            latch.countDown();
        }));
        try {
            latch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            throw new IllegalStateException(e2);
        }
        if (exceptionRef.get() != null) {
            log.debug("Failed to init master key", (Throwable)exceptionRef.get());
            if (exceptionRef.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionRef.get();
            }
            throw new MLException((Throwable)exceptionRef.get());
        }
        if (this.masterKey == null) {
            throw new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]);
        }
    }
}

