/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.resthandler.top_queries;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesAction;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesRequest;
import org.opensearch.plugin.insights.rules.action.top_queries.TopQueriesResponse;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;

public class RestTopQueriesAction
extends BaseRestHandler {
    static final Set<String> ALLOWED_METRICS = MetricType.allMetricTypes().stream().map(MetricType::toString).collect(Collectors.toSet());

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_insights/top_queries"), new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{nodeId}", "/_insights/top_queries")));
    }

    public String getName() {
        return "query_insights_top_queries_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        TopQueriesRequest topQueriesRequest = RestTopQueriesAction.prepareRequest(request);
        topQueriesRequest.timeout(request.param("timeout"));
        return channel -> client.execute((ActionType)TopQueriesAction.INSTANCE, (ActionRequest)topQueriesRequest, this.topQueriesResponse((RestChannel)channel));
    }

    static TopQueriesRequest prepareRequest(RestRequest request) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        String metricType = request.param("type", MetricType.LATENCY.toString());
        if (!ALLOWED_METRICS.contains(metricType)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains invalid metric type [%s]", request.path(), metricType));
        }
        return new TopQueriesRequest(MetricType.fromString(metricType), nodesIds);
    }

    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }

    private RestResponseListener<TopQueriesResponse> topQueriesResponse(RestChannel channel) {
        return new RestResponseListener<TopQueriesResponse>(channel){

            public RestResponse buildResponse(TopQueriesResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

