/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.mapper.xypoint;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.common.Explicit;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.geometry.Geometry;
import org.opensearch.geospatial.index.mapper.xypoint.XYPoint;
import org.opensearch.geospatial.index.mapper.xypoint.XYPointIndexer;
import org.opensearch.geospatial.index.mapper.xypoint.XYPointParser;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeQueryable;
import org.opensearch.geospatial.index.query.xypoint.XYPointQueryProcessor;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.query.QueryShardContext;

public class XYPointFieldMapper
extends AbstractPointGeometryFieldMapper<List<XYPoint>, List<? extends org.apache.lucene.geo.XYPoint>> {
    public static final String CONTENT_TYPE = "xy_point";
    private static final FieldType FIELD_TYPE = new FieldType();

    private XYPointFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, ignoreMalformed, ignoreZValue, nullValue, copyTo);
    }

    protected void addStoredFields(ParseContext context, List<? extends org.apache.lucene.geo.XYPoint> points) {
        for (org.apache.lucene.geo.XYPoint xYPoint : points) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), xYPoint.toString()));
        }
    }

    protected void addDocValuesFields(String name, List<? extends org.apache.lucene.geo.XYPoint> points, List<IndexableField> fields, ParseContext context) {
        for (org.apache.lucene.geo.XYPoint xYPoint : points) {
            context.doc().add((IndexableField)new XYDocValuesField(this.fieldType().name(), xYPoint.getX(), xYPoint.getY()));
        }
    }

    protected void addMultiFields(ParseContext context, List<? extends org.apache.lucene.geo.XYPoint> points) {
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public XYPointFieldType fieldType() {
        return (XYPointFieldType)this.mappedFieldType;
    }

    static {
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.freeze();
    }

    public static class XYPointFieldType
    extends AbstractPointGeometryFieldMapper.AbstractPointGeometryFieldType<List<XYPoint>, List<? extends org.apache.lucene.geo.XYPoint>>
    implements XYShapeQueryable {
        private final XYPointQueryProcessor queryProcessor;

        public XYPointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta, XYPointQueryProcessor processor) {
            super(name, indexed, stored, hasDocValues, meta);
            this.queryProcessor = Objects.requireNonNull(processor, "query processor cannot be null");
        }

        public String typeName() {
            return XYPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query shapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.shapeQuery(geometry, fieldName, relation, context);
        }
    }

    public static class XYPointFieldMapperBuilder
    extends AbstractPointGeometryFieldMapper.Builder<XYPointFieldMapperBuilder, XYPointFieldType> {
        public XYPointFieldMapperBuilder(String fieldName) {
            super(fieldName, FIELD_TYPE);
            this.hasDocValues = true;
        }

        public XYPointFieldMapper build(Mapper.BuilderContext context, String simpleName, FieldType fieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
            XYPointQueryProcessor processor = new XYPointQueryProcessor();
            XYPointFieldType xyPointFieldType = new XYPointFieldType(this.buildFullName(context), this.indexed, this.fieldType.stored(), this.hasDocValues, this.meta, processor);
            xyPointFieldType.setGeometryParser((AbstractGeometryFieldMapper.Parser)new AbstractPointGeometryFieldMapper.PointParser(this.name, XYPoint::new, (parser, point) -> XYPointParser.parseXYPoint(parser, (boolean)((Boolean)this.ignoreZValue().value())), (AbstractPointGeometryFieldMapper.ParsedPoint)((XYPoint)nullValue), ((Boolean)ignoreZValue.value()).booleanValue(), ((Boolean)ignoreMalformed.value()).booleanValue()));
            xyPointFieldType.setGeometryIndexer(new XYPointIndexer(xyPointFieldType.name()));
            return new XYPointFieldMapper(this.name, fieldType, (MappedFieldType)xyPointFieldType, multiFields, ignoreMalformed, ignoreZValue, nullValue, copyTo);
        }
    }
}

