/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPipelinePlugin;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.common.CollapseResponseProcessor;
import org.opensearch.search.pipeline.common.FilterQueryRequestProcessor;
import org.opensearch.search.pipeline.common.OversampleRequestProcessor;
import org.opensearch.search.pipeline.common.RenameFieldResponseProcessor;
import org.opensearch.search.pipeline.common.ScriptRequestProcessor;
import org.opensearch.search.pipeline.common.SortResponseProcessor;
import org.opensearch.search.pipeline.common.TruncateHitsResponseProcessor;

public class SearchPipelineCommonModulePlugin
extends Plugin
implements SearchPipelinePlugin {
    static final Setting<List<String>> REQUEST_PROCESSORS_ALLOWLIST_SETTING = Setting.listSetting((String)"search.pipeline.common.request.processors.allowed", List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<List<String>> RESPONSE_PROCESSORS_ALLOWLIST_SETTING = Setting.listSetting((String)"search.pipeline.common.response.processors.allowed", List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<List<String>> SEARCH_PHASE_RESULTS_PROCESSORS_ALLOWLIST_SETTING = Setting.listSetting((String)"search.pipeline.common.search.phase.results.processors.allowed", List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public List<Setting<?>> getSettings() {
        return List.of(REQUEST_PROCESSORS_ALLOWLIST_SETTING, RESPONSE_PROCESSORS_ALLOWLIST_SETTING, SEARCH_PHASE_RESULTS_PROCESSORS_ALLOWLIST_SETTING);
    }

    public Map<String, Processor.Factory<SearchRequestProcessor>> getRequestProcessors(SearchPipelinePlugin.Parameters parameters) {
        return this.filterForAllowlistSetting(REQUEST_PROCESSORS_ALLOWLIST_SETTING, parameters.env.settings(), Map.of("filter_query", new FilterQueryRequestProcessor.Factory(parameters.namedXContentRegistry), "script", new ScriptRequestProcessor.Factory(parameters.scriptService), "oversample", new OversampleRequestProcessor.Factory()));
    }

    public Map<String, Processor.Factory<SearchResponseProcessor>> getResponseProcessors(SearchPipelinePlugin.Parameters parameters) {
        return this.filterForAllowlistSetting(RESPONSE_PROCESSORS_ALLOWLIST_SETTING, parameters.env.settings(), Map.of("rename_field", new RenameFieldResponseProcessor.Factory(), "truncate_hits", new TruncateHitsResponseProcessor.Factory(), "collapse", new CollapseResponseProcessor.Factory(), "sort", new SortResponseProcessor.Factory()));
    }

    public Map<String, Processor.Factory<SearchPhaseResultsProcessor>> getSearchPhaseResultsProcessors(SearchPipelinePlugin.Parameters parameters) {
        return this.filterForAllowlistSetting(SEARCH_PHASE_RESULTS_PROCESSORS_ALLOWLIST_SETTING, parameters.env.settings(), Map.of());
    }

    private <T extends Processor> Map<String, Processor.Factory<T>> filterForAllowlistSetting(Setting<List<String>> allowlistSetting, Settings settings, Map<String, Processor.Factory<T>> map) {
        if (!allowlistSetting.exists(settings)) {
            return Map.copyOf(map);
        }
        Set allowlist = Set.copyOf((Collection)allowlistSetting.get(settings));
        Set unknownAllowlistProcessors = allowlist.stream().filter(p -> !map.containsKey(p)).collect(Collectors.toUnmodifiableSet());
        if (!unknownAllowlistProcessors.isEmpty()) {
            throw new IllegalArgumentException("Processor(s) " + String.valueOf(unknownAllowlistProcessors) + " were defined in [" + allowlistSetting.getKey() + "] but do not exist");
        }
        return map.entrySet().stream().filter(e -> allowlist.contains(e.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

