/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.neuralsearch.search.query.HybridQueryFieldDocComparator;
import org.opensearch.neuralsearch.search.query.HybridQueryScoreDocsMerger;
import org.opensearch.search.sort.SortAndFormats;

class TopDocsMerger {
    private HybridQueryScoreDocsMerger docsMerger;
    private SortAndFormats sortAndFormats;
    @VisibleForTesting
    protected static Comparator<ScoreDoc> SCORE_DOC_BY_SCORE_COMPARATOR;
    @VisibleForTesting
    protected static HybridQueryFieldDocComparator FIELD_DOC_BY_SORT_CRITERIA_COMPARATOR;
    private final Comparator<ScoreDoc> MERGING_TIE_BREAKER = (o1, o2) -> {
        int docIdComparison = Integer.compare(o1.doc, o2.doc);
        return docIdComparison;
    };

    TopDocsMerger(SortAndFormats sortAndFormats) {
        this.sortAndFormats = sortAndFormats;
        if (this.isSortingEnabled()) {
            this.docsMerger = new HybridQueryScoreDocsMerger();
            FIELD_DOC_BY_SORT_CRITERIA_COMPARATOR = new HybridQueryFieldDocComparator(sortAndFormats.sort.getSort(), this.MERGING_TIE_BREAKER);
        } else {
            this.docsMerger = new HybridQueryScoreDocsMerger();
            SCORE_DOC_BY_SCORE_COMPARATOR = Comparator.comparing(scoreDoc -> Float.valueOf(scoreDoc.score));
        }
    }

    public TopDocsAndMaxScore merge(TopDocsAndMaxScore source, TopDocsAndMaxScore newTopDocs) {
        if (Objects.isNull(newTopDocs) || Objects.isNull(newTopDocs.topDocs) || newTopDocs.topDocs.totalHits.value == 0L) {
            return source;
        }
        TotalHits mergedTotalHits = this.getMergedTotalHits(source, newTopDocs);
        TopDocsAndMaxScore result = new TopDocsAndMaxScore(this.getTopDocs(this.getMergedScoreDocs(source.topDocs.scoreDocs, newTopDocs.topDocs.scoreDocs), mergedTotalHits), Math.max(source.maxScore, newTopDocs.maxScore));
        return result;
    }

    private TotalHits getMergedTotalHits(TopDocsAndMaxScore source, TopDocsAndMaxScore newTopDocs) {
        TotalHits.Relation mergedHitsRelation = source.topDocs.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO || newTopDocs.topDocs.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TotalHits(source.topDocs.totalHits.value + newTopDocs.topDocs.totalHits.value, mergedHitsRelation);
    }

    private TopDocs getTopDocs(ScoreDoc[] mergedScoreDocs, TotalHits mergedTotalHits) {
        if (this.isSortingEnabled()) {
            return new TopFieldDocs(mergedTotalHits, mergedScoreDocs, this.sortAndFormats.sort.getSort());
        }
        return new TopDocs(mergedTotalHits, mergedScoreDocs);
    }

    private ScoreDoc[] getMergedScoreDocs(ScoreDoc[] source, ScoreDoc[] newScoreDocs) {
        return this.docsMerger.merge(source, newScoreDocs, this.comparator(), this.isSortingEnabled());
    }

    private Comparator<? extends ScoreDoc> comparator() {
        return this.sortAndFormats != null ? FIELD_DOC_BY_SORT_CRITERIA_COMPARATOR : SCORE_DOC_BY_SCORE_COMPARATOR;
    }

    private boolean isSortingEnabled() {
        return this.sortAndFormats != null;
    }

    @Generated
    TopDocsMerger() {
    }
}

