/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative.ext;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class GenerativeQAParameters
implements Writeable,
ToXContentObject {
    private static final ObjectParser<GenerativeQAParameters, Void> PARSER;
    private static final ParseField CONVERSATION_ID;
    private static final ParseField LLM_MODEL;
    private static final ParseField LLM_QUESTION;
    private static final ParseField CONTEXT_SIZE;
    private static final ParseField INTERACTION_SIZE;
    private static final ParseField TIMEOUT;
    private static final ParseField SYSTEM_PROMPT;
    private static final ParseField USER_INSTRUCTIONS;
    private static final ParseField LLM_RESPONSE_FIELD;
    public static final int SIZE_NULL_VALUE = -1;
    private String conversationId;
    private String llmModel;
    private String llmQuestion;
    private Integer contextSize;
    private Integer interactionSize;
    private Integer timeout;
    private String systemPrompt;
    private String userInstructions;
    private String llmResponseField;

    public GenerativeQAParameters(String conversationId, String llmModel, String llmQuestion, String systemPrompt, String userInstructions, Integer contextSize, Integer interactionSize, Integer timeout, String llmResponseField) {
        this.conversationId = conversationId;
        this.llmModel = llmModel;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)llmQuestion) ? 1 : 0) != 0, (Object)(LLM_QUESTION.getPreferredName() + " must be provided."));
        this.llmQuestion = llmQuestion;
        this.systemPrompt = systemPrompt;
        this.userInstructions = userInstructions;
        this.contextSize = contextSize == null ? -1 : contextSize;
        this.interactionSize = interactionSize == null ? -1 : interactionSize;
        this.timeout = timeout == null ? -1 : timeout;
        this.llmResponseField = llmResponseField;
    }

    public GenerativeQAParameters(StreamInput input) throws IOException {
        this.conversationId = input.readOptionalString();
        this.llmModel = input.readOptionalString();
        this.llmQuestion = input.readString();
        this.systemPrompt = input.readOptionalString();
        this.userInstructions = input.readOptionalString();
        this.contextSize = input.readInt();
        this.interactionSize = input.readInt();
        this.timeout = input.readInt();
        this.llmResponseField = input.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        return xContentBuilder.field(CONVERSATION_ID.getPreferredName(), this.conversationId).field(LLM_MODEL.getPreferredName(), this.llmModel).field(LLM_QUESTION.getPreferredName(), this.llmQuestion).field(SYSTEM_PROMPT.getPreferredName(), this.systemPrompt).field(USER_INSTRUCTIONS.getPreferredName(), this.userInstructions).field(CONTEXT_SIZE.getPreferredName(), this.contextSize).field(INTERACTION_SIZE.getPreferredName(), this.interactionSize).field(TIMEOUT.getPreferredName(), this.timeout).field(LLM_RESPONSE_FIELD.getPreferredName(), this.llmResponseField);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.conversationId);
        out.writeOptionalString(this.llmModel);
        Preconditions.checkNotNull((Object)this.llmQuestion, (Object)"llm_question must not be null.");
        out.writeString(this.llmQuestion);
        out.writeOptionalString(this.systemPrompt);
        out.writeOptionalString(this.userInstructions);
        out.writeInt(this.contextSize.intValue());
        out.writeInt(this.interactionSize.intValue());
        out.writeInt(this.timeout.intValue());
        out.writeOptionalString(this.llmResponseField);
    }

    public static GenerativeQAParameters parse(XContentParser parser) throws IOException {
        return (GenerativeQAParameters)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerativeQAParameters other = (GenerativeQAParameters)o;
        return Objects.equals(this.conversationId, other.getConversationId()) && Objects.equals(this.llmModel, other.getLlmModel()) && Objects.equals(this.llmQuestion, other.getLlmQuestion()) && Objects.equals(this.systemPrompt, other.getSystemPrompt()) && Objects.equals(this.userInstructions, other.getUserInstructions()) && this.contextSize == other.getContextSize() && this.interactionSize == other.getInteractionSize() && this.timeout == other.getTimeout() && Objects.equals(this.llmResponseField, other.getLlmResponseField());
    }

    @Generated
    public GenerativeQAParameters() {
    }

    @Generated
    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public void setLlmModel(String llmModel) {
        this.llmModel = llmModel;
    }

    @Generated
    public String getLlmModel() {
        return this.llmModel;
    }

    @Generated
    public void setLlmQuestion(String llmQuestion) {
        this.llmQuestion = llmQuestion;
    }

    @Generated
    public String getLlmQuestion() {
        return this.llmQuestion;
    }

    @Generated
    public void setContextSize(Integer contextSize) {
        this.contextSize = contextSize;
    }

    @Generated
    public Integer getContextSize() {
        return this.contextSize;
    }

    @Generated
    public void setInteractionSize(Integer interactionSize) {
        this.interactionSize = interactionSize;
    }

    @Generated
    public Integer getInteractionSize() {
        return this.interactionSize;
    }

    @Generated
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
    }

    @Generated
    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    @Generated
    public void setUserInstructions(String userInstructions) {
        this.userInstructions = userInstructions;
    }

    @Generated
    public String getUserInstructions() {
        return this.userInstructions;
    }

    @Generated
    public void setLlmResponseField(String llmResponseField) {
        this.llmResponseField = llmResponseField;
    }

    @Generated
    public String getLlmResponseField() {
        return this.llmResponseField;
    }

    static {
        CONVERSATION_ID = new ParseField("memory_id", new String[0]);
        LLM_MODEL = new ParseField("llm_model", new String[0]);
        LLM_QUESTION = new ParseField("llm_question", new String[0]);
        CONTEXT_SIZE = new ParseField("context_size", new String[0]);
        INTERACTION_SIZE = new ParseField("message_size", new String[0]);
        TIMEOUT = new ParseField("timeout", new String[0]);
        SYSTEM_PROMPT = new ParseField("system_prompt", new String[0]);
        USER_INSTRUCTIONS = new ParseField("user_instructions", new String[0]);
        LLM_RESPONSE_FIELD = new ParseField("llm_response_field", new String[0]);
        PARSER = new ObjectParser("generative_qa_parameters", GenerativeQAParameters::new);
        PARSER.declareString(GenerativeQAParameters::setConversationId, CONVERSATION_ID);
        PARSER.declareString(GenerativeQAParameters::setLlmModel, LLM_MODEL);
        PARSER.declareString(GenerativeQAParameters::setLlmQuestion, LLM_QUESTION);
        PARSER.declareStringOrNull(GenerativeQAParameters::setSystemPrompt, SYSTEM_PROMPT);
        PARSER.declareStringOrNull(GenerativeQAParameters::setUserInstructions, USER_INSTRUCTIONS);
        PARSER.declareIntOrNull(GenerativeQAParameters::setContextSize, -1, CONTEXT_SIZE);
        PARSER.declareIntOrNull(GenerativeQAParameters::setInteractionSize, -1, INTERACTION_SIZE);
        PARSER.declareIntOrNull(GenerativeQAParameters::setTimeout, -1, TIMEOUT);
        PARSER.declareStringOrNull(GenerativeQAParameters::setLlmResponseField, LLM_RESPONSE_FIELD);
    }
}

