/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache.common.tier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.cache.common.tier.TieredSpilloverCache;
import org.opensearch.cache.common.tier.TieredSpilloverCacheSettings;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.cache.ICache;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.plugins.CachePlugin;
import org.opensearch.plugins.Plugin;

public class TieredSpilloverCachePlugin
extends Plugin
implements CachePlugin {
    public static final String TIERED_CACHE_SPILLOVER_PLUGIN_NAME = "tieredSpilloverCachePlugin";
    private final Settings settings;

    public TieredSpilloverCachePlugin(Settings settings) {
        this.settings = settings;
    }

    public Map<String, ICache.Factory> getCacheFactoryMap() {
        return Map.of("tiered_spillover", new TieredSpilloverCache.TieredSpilloverCacheFactory());
    }

    public List<Setting<?>> getSettings() {
        ArrayList settingList = new ArrayList();
        for (CacheType cacheType : CacheType.values()) {
            settingList.add(TieredSpilloverCacheSettings.TIERED_SPILLOVER_ONHEAP_STORE_NAME.getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
            settingList.add(TieredSpilloverCacheSettings.TIERED_SPILLOVER_DISK_STORE_NAME.getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
            settingList.add(TieredSpilloverCacheSettings.TOOK_TIME_POLICY_CONCRETE_SETTINGS_MAP.get(cacheType));
            if (!((Boolean)FeatureFlags.PLUGGABLE_CACHE_SETTING.get(this.settings)).booleanValue()) continue;
            settingList.add(TieredSpilloverCacheSettings.DISK_CACHE_ENABLED_SETTING_MAP.get(cacheType));
        }
        return settingList;
    }

    public String getName() {
        return TIERED_CACHE_SPILLOVER_PLUGIN_NAME;
    }
}

