/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.commons.alerting.action.DeleteWorkflowRequest;
import org.opensearch.commons.alerting.action.DeleteWorkflowResponse;
import org.opensearch.commons.alerting.action.IndexMonitorResponse;
import org.opensearch.commons.alerting.action.IndexWorkflowRequest;
import org.opensearch.commons.alerting.action.IndexWorkflowResponse;
import org.opensearch.commons.alerting.model.ChainedMonitorFindings;
import org.opensearch.commons.alerting.model.CompositeInput;
import org.opensearch.commons.alerting.model.Delegate;
import org.opensearch.commons.alerting.model.Sequence;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.RestRequest;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.securityanalytics.util.MonitorService;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class WorkflowService {
    private static final Logger log = LogManager.getLogger(WorkflowService.class);
    private Client client;
    private MonitorService monitorService;

    public WorkflowService() {
    }

    public WorkflowService(Client client, MonitorService monitorService) {
        this.client = client;
        this.monitorService = monitorService;
    }

    public void upsertWorkflow(List<Pair<String, Rule>> rulesById, List<IndexMonitorResponse> addedMonitorResponses, List<IndexMonitorResponse> updatedMonitorResponses, Detector detector, final WriteRequest.RefreshPolicy refreshPolicy, String workflowId, RestRequest.Method method, final ActionListener<IndexWorkflowResponse> listener) {
        List updatedMonitors;
        final List addedMonitors = addedMonitorResponses != null ? addedMonitorResponses.stream().map(IndexMonitorResponse::getId).collect(Collectors.toList()) : Collections.emptyList();
        List list = updatedMonitors = updatedMonitorResponses != null ? updatedMonitorResponses.stream().map(IndexMonitorResponse::getId).collect(Collectors.toList()) : Collections.emptyList();
        if (method != RestRequest.Method.POST && method != RestRequest.Method.PUT) {
            log.error(String.format("Method %s not supported when upserting the workflow", method.name()));
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(new OpenSearchException("Method not supported", new Object[0]))));
            return;
        }
        ArrayList<String> monitorIds = new ArrayList<String>(addedMonitors);
        if (updatedMonitorResponses != null && !updatedMonitorResponses.isEmpty()) {
            monitorIds.addAll(updatedMonitors);
        }
        ChainedMonitorFindings chainedMonitorFindings = null;
        String cmfMonitorId = null;
        if (addedMonitorResponses.stream().anyMatch(res -> (detector.getName() + "_chained_findings").equals(res.getMonitor().getName()))) {
            ArrayList<IndexMonitorResponse> monitorResponses = new ArrayList<IndexMonitorResponse>(addedMonitorResponses);
            if (updatedMonitorResponses != null) {
                monitorResponses.addAll(updatedMonitorResponses);
            }
            cmfMonitorId = addedMonitorResponses.stream().filter(res -> (detector.getName() + "_chained_findings").equals(res.getMonitor().getName())).findFirst().get().getId();
            chainedMonitorFindings = new ChainedMonitorFindings(null, DetectorUtils.getBucketLevelMonitorIds(monitorResponses));
        }
        IndexWorkflowRequest indexWorkflowRequest = this.createWorkflowRequest(monitorIds, detector, refreshPolicy, workflowId, method, chainedMonitorFindings, cmfMonitorId);
        AlertingPluginInterface.INSTANCE.indexWorkflow((NodeClient)this.client, indexWorkflowRequest, (ActionListener)new ActionListener<IndexWorkflowResponse>(){

            public void onResponse(IndexWorkflowResponse workflowResponse) {
                listener.onResponse((Object)workflowResponse);
            }

            public void onFailure(final Exception e) {
                log.error("Failed workflow saving. Removing created monitors: " + addedMonitors.stream().collect(Collectors.joining()), (Throwable)e);
                WorkflowService.this.monitorService.deleteAlertingMonitors(addedMonitors, refreshPolicy, new ActionListener<List<DeleteMonitorResponse>>(){

                    public void onResponse(List<DeleteMonitorResponse> deleteMonitorResponses) {
                        log.debug("Monitors successfully deleted");
                        listener.onFailure(e);
                    }

                    public void onFailure(Exception e2) {
                        log.error("Error deleting monitors", (Throwable)e2);
                        listener.onFailure(e2);
                    }
                });
            }
        });
    }

    public void deleteWorkflow(String workflowId, ActionListener<DeleteWorkflowResponse> deleteWorkflowListener) {
        DeleteWorkflowRequest deleteWorkflowRequest = new DeleteWorkflowRequest(workflowId, Boolean.valueOf(false));
        AlertingPluginInterface.INSTANCE.deleteWorkflow((NodeClient)this.client, deleteWorkflowRequest, deleteWorkflowListener);
    }

    private IndexWorkflowRequest createWorkflowRequest(List<String> monitorIds, Detector detector, WriteRequest.RefreshPolicy refreshPolicy, String workflowId, RestRequest.Method method, ChainedMonitorFindings chainedMonitorFindings, String cmfMonitorId) {
        AtomicInteger index = new AtomicInteger();
        ArrayList<Delegate> delegates = new ArrayList<Delegate>();
        ChainedMonitorFindings cmf = null;
        for (String monitorId : monitorIds) {
            if (cmfMonitorId != null && chainedMonitorFindings != null && Objects.equals(monitorId, cmfMonitorId)) {
                cmf = Objects.equals(monitorId, cmfMonitorId) ? chainedMonitorFindings : null;
                continue;
            }
            Delegate delegate = new Delegate(index.incrementAndGet(), monitorId, null);
            delegates.add(delegate);
        }
        if (cmf != null) {
            Delegate cmfDelegate = new Delegate(index.incrementAndGet(), cmfMonitorId, cmf);
            delegates.add(cmfDelegate);
        }
        Sequence sequence = new Sequence(delegates);
        CompositeInput compositeInput = new CompositeInput(sequence);
        Workflow workflow = new Workflow(workflowId, 1L, detector.getName(), detector.getEnabled().booleanValue(), detector.getSchedule(), detector.getLastUpdateTime(), detector.getEnabledTime(), Workflow.WorkflowType.COMPOSITE, detector.getUser(), 1, List.of(compositeInput), "security_analytics", Collections.emptyList(), Boolean.valueOf(false));
        return new IndexWorkflowRequest(workflowId, -2L, 0L, refreshPolicy, method, workflow, null);
    }
}

