/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.util.DetectorIndices;

public class RuleTopicIndices {
    private static final Logger log = LogManager.getLogger(DetectorIndices.class);
    private final Client client;
    private final ClusterService clusterService;
    private final LogTypeService logTypeService;

    public RuleTopicIndices(Client client, ClusterService clusterService, LogTypeService logTypeService) {
        this.client = client;
        this.clusterService = clusterService;
        this.logTypeService = logTypeService;
    }

    public static String ruleTopicIndexSettings() throws IOException {
        return new String(Objects.requireNonNull(DetectorIndices.class.getClassLoader().getResourceAsStream("mappings/detector-settings.json")).readAllBytes(), Charset.defaultCharset());
    }

    public void initRuleTopicIndexTemplate(ActionListener<AcknowledgedResponse> actionListener) throws IOException {
        this.getAllRuleIndices((ActionListener<List<String>>)ActionListener.wrap(allRuleIndices -> {
            ArrayList<CallSite> indexPatterns = new ArrayList<CallSite>();
            for (String ruleIndex : allRuleIndices) {
                indexPatterns.add((CallSite)((Object)(ruleIndex + "*")));
            }
            ComposableIndexTemplate template = new ComposableIndexTemplate(indexPatterns, new Template(Settings.builder().loadFromSource(RuleTopicIndices.ruleTopicIndexSettings(), (MediaType)XContentType.JSON).build(), null, null), null, Long.valueOf(500L), null, null);
            this.client.execute((ActionType)PutComposableIndexTemplateAction.INSTANCE, (ActionRequest)new PutComposableIndexTemplateAction.Request(".opensearch-sap-detectors-queries-index-template").indexTemplate(template).create(false), actionListener);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    public boolean ruleTopicIndexTemplateExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.metadata().templatesV2().get(".opensearch-sap-detectors-queries-index-template") != null;
    }

    private void getAllRuleIndices(ActionListener<List<String>> listener) {
        this.logTypeService.getAllLogTypes((ActionListener<List<String>>)ActionListener.wrap(logTypes -> listener.onResponse(logTypes.stream().map(logType -> DetectorMonitorConfig.getRuleIndex(logType)).collect(Collectors.toList())), arg_0 -> listener.onFailure(arg_0)));
    }
}

