/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.securityanalytics.commons.model.IOC;
import org.opensearch.securityanalytics.commons.model.STIX2;
import org.opensearch.securityanalytics.commons.model.UpdateAction;
import org.opensearch.securityanalytics.commons.model.UpdateType;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.services.STIX2IOCFeedStore;

public class STIX2IOCConsumer
implements Consumer<STIX2> {
    private final Logger log = LogManager.getLogger(STIX2IOCConsumer.class);
    private final LinkedBlockingQueue<STIX2IOC> queue;
    private final STIX2IOCFeedStore feedStore;
    private final UpdateType updateType;

    public STIX2IOCConsumer(int batchSize, STIX2IOCFeedStore feedStore, UpdateType updateType) {
        this.queue = new LinkedBlockingQueue(batchSize);
        this.feedStore = feedStore;
        this.updateType = updateType;
    }

    @Override
    public void accept(STIX2 ioc) {
        STIX2IOC stix2IOC = new STIX2IOC(ioc, this.feedStore.getSaTifSourceConfig().getId(), this.feedStore.getSaTifSourceConfig().getName());
        if (!this.feedStore.getSaTifSourceConfig().getIocTypes().contains(stix2IOC.getType().toString())) {
            this.log.error("{} is not a supported Ioc type for tif source config {}. Skipping IOC {}: of type {} value {}", (Object)stix2IOC.getType().toString(), (Object)this.feedStore.getSaTifSourceConfig().getId(), (Object)stix2IOC.getId(), (Object)stix2IOC.getType(), (Object)stix2IOC.getValue());
            return;
        }
        if (this.queue.offer(stix2IOC)) {
            return;
        }
        this.flushIOCs();
        this.queue.offer(stix2IOC);
    }

    public void flushIOCs() {
        if (this.queue.isEmpty()) {
            throw new OpenSearchStatusException("No compatible Iocs were downloaded for config " + this.feedStore.getSaTifSourceConfig().getName(), RestStatus.BAD_REQUEST, new Object[0]);
        }
        ArrayList<STIX2IOC> iocsToFlush = new ArrayList<STIX2IOC>(this.queue.size());
        this.queue.drainTo(iocsToFlush);
        Map<IOC, UpdateAction> iocToActions = this.buildIOCToActions(iocsToFlush);
        this.feedStore.storeIOCs(iocToActions);
    }

    private Map<IOC, UpdateAction> buildIOCToActions(List<STIX2IOC> iocs) {
        switch (this.updateType) {
            case REPLACE: {
                return this.buildReplaceActions(iocs);
            }
            case DELTA: {
                return this.buildDeltaActions(iocs);
            }
        }
        throw new IllegalArgumentException("Invalid update type: " + String.valueOf(this.updateType));
    }

    private Map<IOC, UpdateAction> buildReplaceActions(List<STIX2IOC> iocs) {
        return iocs.stream().map(ioc -> Map.entry(ioc, UpdateAction.UPSERT)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<IOC, UpdateAction> buildDeltaActions(List<STIX2IOC> iocs) {
        throw new UnsupportedOperationException("Delta update type is not yet supported");
    }
}

