/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.SearchCorrelationRuleAction;
import org.opensearch.securityanalytics.action.SearchCorrelationRuleRequest;

public class RestSearchCorrelationRuleAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestSearchCorrelationRuleAction.class);

    public String getName() {
        return "search_correlation_rule_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/correlation/rules/_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s/_search", request.method(), "/_plugins/_security_analytics/correlation/rules"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(null);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must(searchSourceBuilder.query());
        searchSourceBuilder.query((QueryBuilder)queryBuilder).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opensearch-sap-correlation-rules-config"}).preference(Preference.PRIMARY_FIRST.type());
        SearchCorrelationRuleRequest searchCorrelationRuleRequest = new SearchCorrelationRuleRequest(searchRequest);
        return channel -> client.execute((ActionType)SearchCorrelationRuleAction.INSTANCE, (ActionRequest)searchCorrelationRuleRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

