/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.alerts;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.AcknowledgeAlertRequest;
import org.opensearch.commons.alerting.action.AcknowledgeAlertResponse;
import org.opensearch.commons.alerting.action.GetAlertsRequest;
import org.opensearch.commons.alerting.action.GetAlertsResponse;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.securityanalytics.action.AckAlertsResponse;
import org.opensearch.securityanalytics.action.AlertDto;
import org.opensearch.securityanalytics.action.GetDetectorAction;
import org.opensearch.securityanalytics.action.GetDetectorRequest;
import org.opensearch.securityanalytics.action.GetDetectorResponse;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class AlertsService {
    private Client client;
    private static final Logger log = LogManager.getLogger(AlertsService.class);

    public AlertsService() {
    }

    public AlertsService(Client client) {
        this.client = client;
    }

    public void getAlertsByDetectorId(final String detectorId, final Table table, final String severityLevel, final String alertState, final Instant startTime, final Instant endTime, final ActionListener<org.opensearch.securityanalytics.action.GetAlertsResponse> listener) {
        this.client.execute((ActionType)GetDetectorAction.INSTANCE, (ActionRequest)new GetDetectorRequest(detectorId, -3L), (ActionListener)new ActionListener<GetDetectorResponse>(){

            public void onResponse(GetDetectorResponse getDetectorResponse) {
                Detector detector = getDetectorResponse.getDetector();
                List<String> monitorIds = detector.getMonitorIds();
                HashMap<String, String> monitorToDetectorMapping = new HashMap<String, String>();
                detector.getMonitorIds().forEach(monitorId -> monitorToDetectorMapping.put((String)monitorId, detector.getId()));
                AlertsService.this.getAlertsByMonitorIds(monitorToDetectorMapping, monitorIds, DetectorMonitorConfig.getAllAlertsIndicesPattern(detector.getDetectorType()), table, severityLevel, alertState, startTime, endTime, new ActionListener<org.opensearch.securityanalytics.action.GetAlertsResponse>(){

                    public void onResponse(org.opensearch.securityanalytics.action.GetAlertsResponse getAlertsResponse) {
                        listener.onResponse((Object)getAlertsResponse);
                    }

                    public void onFailure(Exception e) {
                        log.error("Failed to fetch alerts for detectorId: " + detectorId, (Throwable)e);
                        listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
                    }
                });
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public void getAlertsByMonitorIds(final Map<String, String> monitorToDetectorMapping, List<String> monitorIds, String alertIndex, Table table, String severityLevel, String alertState, Instant startTime, Instant endTime, final ActionListener<org.opensearch.securityanalytics.action.GetAlertsResponse> listener) {
        BoolQueryBuilder boolQueryBuilder = AlertsService.getBoolQueryBuilder(startTime, endTime);
        GetAlertsRequest req = new GetAlertsRequest(table, severityLevel, alertState, null, alertIndex, monitorIds, null, null, boolQueryBuilder);
        AlertingPluginInterface.INSTANCE.getAlerts((NodeClient)this.client, req, (ActionListener)new ActionListener<GetAlertsResponse>(){

            public void onResponse(GetAlertsResponse getAlertsResponse) {
                listener.onResponse((Object)new org.opensearch.securityanalytics.action.GetAlertsResponse(getAlertsResponse.getAlerts().stream().map(e -> AlertsService.this.mapAlertToAlertDto((Alert)e, (String)monitorToDetectorMapping.get(e.getMonitorId()))).collect(Collectors.toList()), getAlertsResponse.getTotalAlerts()));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    void setIndicesAdminClient(Client client) {
        this.client = client;
    }

    public void getAlerts(final List<Detector> detectors, String logType, Table table, String severityLevel, String alertState, Instant startTime, Instant endTime, final ActionListener<org.opensearch.securityanalytics.action.GetAlertsResponse> listener) {
        if (detectors.size() == 0) {
            throw new OpenSearchStatusException("detector list is empty!", RestStatus.NOT_FOUND, new Object[0]);
        }
        ArrayList<String> allMonitorIds = new ArrayList<String>();
        HashMap<String, String> monitorToDetectorMapping = new HashMap<String, String>();
        detectors.forEach(detector -> {
            detector.getMonitorIds().forEach(monitorId -> monitorToDetectorMapping.put((String)monitorId, detector.getId()));
            allMonitorIds.addAll(detector.getMonitorIds());
        });
        this.getAlertsByMonitorIds(monitorToDetectorMapping, allMonitorIds, DetectorMonitorConfig.getAllAlertsIndicesPattern(logType), table, severityLevel, alertState, startTime, endTime, new ActionListener<org.opensearch.securityanalytics.action.GetAlertsResponse>(){

            public void onResponse(org.opensearch.securityanalytics.action.GetAlertsResponse getAlertsResponse) {
                listener.onResponse((Object)getAlertsResponse);
            }

            public void onFailure(Exception e) {
                log.error("Failed to fetch alerts for detectors: [" + detectors.stream().map(d -> d.getId()).collect(Collectors.joining(",")) + "]", (Throwable)e);
                listener.onFailure((Exception)SecurityAnalyticsException.wrap(e));
            }
        });
    }

    private AlertDto mapAlertToAlertDto(Alert alert, String detectorId) {
        return new AlertDto(detectorId, alert.getId(), alert.getVersion(), alert.getSchemaVersion(), alert.getTriggerId(), alert.getTriggerName(), alert.getFindingIds(), alert.getRelatedDocIds(), alert.getState(), alert.getStartTime(), alert.getEndTime(), alert.getLastNotificationTime(), alert.getAcknowledgedTime(), alert.getErrorMessage(), alert.getErrorHistory(), alert.getSeverity(), alert.getActionExecutionResults(), alert.getAggregationResultBucket());
    }

    public void getAlerts(List<String> alertIds, Detector detector, Table table, Instant startTime, Instant endTime, ActionListener<GetAlertsResponse> actionListener) {
        BoolQueryBuilder boolQueryBuilder = AlertsService.getBoolQueryBuilder(startTime, endTime);
        GetAlertsRequest request = new GetAlertsRequest(table, "ALL", "ALL", null, DetectorMonitorConfig.getAllAlertsIndicesPattern(detector.getDetectorType()), null, null, alertIds, boolQueryBuilder);
        AlertingPluginInterface.INSTANCE.getAlerts((NodeClient)this.client, request, actionListener);
    }

    public void ackknowledgeAlerts(GetAlertsResponse getAlertsResponse, final GetDetectorResponse getDetectorResponse, final ActionListener<AckAlertsResponse> actionListener) {
        HashMap<String, List> alertsByMonitor = new HashMap<String, List>();
        for (Alert alert : getAlertsResponse.getAlerts()) {
            List alerts = alertsByMonitor.getOrDefault(alert.getMonitorId(), new ArrayList());
            alerts.add(alert.getId());
            alertsByMonitor.put(alert.getMonitorId(), alerts);
        }
        GroupedActionListener listener = new GroupedActionListener((ActionListener)new ActionListener<Collection<AcknowledgeAlertResponse>>(){

            public void onResponse(Collection<AcknowledgeAlertResponse> responses) {
                ArrayList<AlertDto> acks = new ArrayList<AlertDto>();
                ArrayList<AlertDto> fails = new ArrayList<AlertDto>();
                ArrayList<String> misses = new ArrayList<String>();
                for (AcknowledgeAlertResponse acknowledgeAlertResponse : responses) {
                    acks.addAll(acknowledgeAlertResponse.getAcknowledged().stream().map(a -> AlertsService.this.mapAlertToAlertDto((Alert)a, getDetectorResponse.getId())).collect(Collectors.toList()));
                    fails.addAll(acknowledgeAlertResponse.getFailed().stream().map(a -> AlertsService.this.mapAlertToAlertDto((Alert)a, getDetectorResponse.getId())).collect(Collectors.toList()));
                    misses.addAll(acknowledgeAlertResponse.getMissing());
                }
                actionListener.onResponse((Object)new AckAlertsResponse(acks, fails, misses));
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        }, alertsByMonitor.size());
        for (Map.Entry entry : alertsByMonitor.entrySet()) {
            AlertingPluginInterface.INSTANCE.acknowledgeAlerts((NodeClient)this.client, new AcknowledgeAlertRequest((String)entry.getKey(), (List)entry.getValue(), WriteRequest.RefreshPolicy.IMMEDIATE), (ActionListener)listener);
        }
    }

    private static BoolQueryBuilder getBoolQueryBuilder(Instant startTime, Instant endTime) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (startTime != null && endTime != null) {
            long startTimeMillis = startTime.toEpochMilli();
            long endTimeMillis = endTime.toEpochMilli();
            RangeQueryBuilder timeRangeQuery = QueryBuilders.rangeQuery((String)"start_time").from((Object)startTimeMillis).to((Object)endTimeMillis);
            boolQueryBuilder.filter((QueryBuilder)timeRangeQuery);
        }
        return boolQueryBuilder;
    }
}

