/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.internal.MutableReference;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.ExecutionRequestContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.reflect.validation.ValidationProblemBuilder;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.UnknownImplementationSnapshot;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.problems.BaseProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateStep<C extends BeforeExecutionContext, R extends Result>
implements Step<C, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateStep.class);
    private final VirtualFileSystem virtualFileSystem;
    private final ValidationWarningRecorder warningReporter;
    private final Step<? super ValidationFinishedContext, ? extends R> delegate;

    public ValidateStep(VirtualFileSystem virtualFileSystem, ValidationWarningRecorder warningReporter, Step<? super ValidationFinishedContext, ? extends R> delegate) {
        this.virtualFileSystem = virtualFileSystem;
        this.warningReporter = warningReporter;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        WorkValidationContext validationContext = ((ExecutionRequestContext)context).getValidationContext();
        work.validate(validationContext);
        ((BeforeExecutionContext)context).getBeforeExecutionState().ifPresent(beforeExecutionState -> this.validateImplementations(work, (BeforeExecutionState)beforeExecutionState, validationContext));
        Map problems = validationContext.getProblems().stream().collect(Collectors.groupingBy(BaseProblem::getSeverity, Collectors.mapping(Function.identity(), Collectors.toList())));
        ImmutableList warnings = ImmutableList.copyOf((Collection)((Collection)problems.getOrDefault(Severity.WARNING, ImmutableList.of())));
        ImmutableList errors = ImmutableList.copyOf((Collection)((Collection)problems.getOrDefault(Severity.ERROR, ImmutableList.of())));
        if (!warnings.isEmpty()) {
            this.warningReporter.recordValidationWarnings(work, (Collection<TypeValidationProblem>)warnings);
        }
        if (!errors.isEmpty()) {
            this.throwValidationException(work, validationContext, (Collection<TypeValidationProblem>)errors);
        }
        if (!warnings.isEmpty()) {
            LOGGER.info("Invalidating VFS because {} failed validation", (Object)work.getDisplayName());
            this.virtualFileSystem.invalidateAll();
        }
        return this.delegate.execute(work, new ValidationFinishedContext((BeforeExecutionContext)context, (ImmutableList<TypeValidationProblem>)warnings));
    }

    private void validateImplementations(UnitOfWork work, BeforeExecutionState beforeExecutionState, WorkValidationContext validationContext) {
        final MutableReference workClass = MutableReference.empty();
        work.visitImplementations(new UnitOfWork.ImplementationVisitor(){

            @Override
            public void visitImplementation(Class<?> implementation) {
                workClass.set((Object)GeneratedSubclasses.unpack(implementation));
            }

            @Override
            public void visitImplementation(ImplementationSnapshot implementation) {
            }
        });
        Class workType = (Class)workClass.get();
        TypeValidationContext workValidationContext = validationContext.forType(workType, true);
        this.validateImplementation(workValidationContext, beforeExecutionState.getImplementation(), "Implementation of ", work);
        beforeExecutionState.getAdditionalImplementations().forEach(additionalImplementation -> this.validateImplementation(workValidationContext, (ImplementationSnapshot)additionalImplementation, "Additional action of ", work));
        beforeExecutionState.getInputProperties().forEach((propertyName, valueSnapshot) -> {
            if (valueSnapshot instanceof ImplementationSnapshot) {
                ImplementationSnapshot implementationSnapshot = (ImplementationSnapshot)valueSnapshot;
                this.validateNestedInput(workValidationContext, (String)propertyName, implementationSnapshot);
            }
        });
    }

    private void validateNestedInput(TypeValidationContext workValidationContext, String propertyName, ImplementationSnapshot implementation) {
        if (implementation instanceof UnknownImplementationSnapshot) {
            UnknownImplementationSnapshot unknownImplSnapshot = (UnknownImplementationSnapshot)implementation;
            workValidationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)this.configureImplementationValidationProblem((ValidationProblemBuilder)problem)).forProperty(propertyName).withDescription(unknownImplSnapshot.getProblemDescription())).happensBecause(unknownImplSnapshot.getReasonDescription())).addPossibleSolution(unknownImplSnapshot.getSolutionDescription()));
        }
    }

    private void validateImplementation(TypeValidationContext workValidationContext, ImplementationSnapshot implementation, String descriptionPrefix, UnitOfWork work) {
        if (implementation instanceof UnknownImplementationSnapshot) {
            UnknownImplementationSnapshot unknownImplSnapshot = (UnknownImplementationSnapshot)implementation;
            workValidationContext.visitPropertyProblem(problem -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)this.configureImplementationValidationProblem((ValidationProblemBuilder)problem)).withDescription(descriptionPrefix + work + " " + unknownImplSnapshot.getProblemDescription())).happensBecause(unknownImplSnapshot.getReasonDescription())).addPossibleSolution(unknownImplSnapshot.getSolutionDescription()));
        }
    }

    private <T extends ValidationProblemBuilder<T>> T configureImplementationValidationProblem(ValidationProblemBuilder<T> problem) {
        return (T)problem.typeIsIrrelevantInErrorMessage().withId(ValidationProblemId.UNKNOWN_IMPLEMENTATION).reportAs(Severity.ERROR).documentedAt("validation_problems", "implementation_unknown");
    }

    protected void throwValidationException(UnitOfWork work, WorkValidationContext validationContext, Collection<TypeValidationProblem> validationErrors) {
        ImmutableSet uniqueErrors = (ImmutableSet)validationErrors.stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).collect(ImmutableSet.toImmutableSet());
        throw WorkValidationException.forProblems((Collection<String>)uniqueErrors).withSummaryForContext(work.getDisplayName(), validationContext).get();
    }

    public static interface ValidationWarningRecorder {
        public void recordValidationWarnings(UnitOfWork var1, Collection<TypeValidationProblem> var2);
    }
}

