"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVER_DELAY = exports.REQUEST = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENSEARCH_API = exports.NODE_API = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const PLUGIN_ID = 'notificationsDashboards';
exports.PLUGIN_ID = PLUGIN_ID;
const PLUGIN_NAME = 'notifications-dashboards'; // after delete operation returns, a delay is needed before the change reflects in another request

exports.PLUGIN_NAME = PLUGIN_NAME;
const SERVER_DELAY = 1000;
exports.SERVER_DELAY = SERVER_DELAY;
const NODE_API_BASE_PATH = '/api/notifications';
const NODE_API = Object.freeze({
  GET_CONFIGS: `${NODE_API_BASE_PATH}/get_configs`,
  GET_CONFIG: `${NODE_API_BASE_PATH}/get_config`,
  CREATE_CONFIG: `${NODE_API_BASE_PATH}/create_config`,
  DELETE_CONFIGS: `${NODE_API_BASE_PATH}/delete_configs`,
  UPDATE_CONFIG: `${NODE_API_BASE_PATH}/update_config`,
  GET_EVENT: `${NODE_API_BASE_PATH}/get_event`,
  GET_AVAILABLE_FEATURES: `${NODE_API_BASE_PATH}/features`,
  SEND_TEST_MESSAGE: `${NODE_API_BASE_PATH}/test_message`
});
exports.NODE_API = NODE_API;
const OPENSEARCH_API_BASE_PATH = '/_plugins/_notifications';
const OPENSEARCH_API = Object.freeze({
  CONFIGS: `${OPENSEARCH_API_BASE_PATH}/configs`,
  EVENTS: `${OPENSEARCH_API_BASE_PATH}/events`,
  TEST_MESSAGE: `${OPENSEARCH_API_BASE_PATH}/feature/test`,
  FEATURES: `${OPENSEARCH_API_BASE_PATH}/features`
});
exports.OPENSEARCH_API = OPENSEARCH_API;
const REQUEST = Object.freeze({
  PUT: 'PUT',
  DELETE: 'DELETE',
  GET: 'GET',
  POST: 'POST',
  HEAD: 'HEAD'
});
exports.REQUEST = REQUEST;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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