#include "cs.h"		/*					SPECTRA.C	*/
#include <math.h>
#include "window.h"
#include "spectra.h"

static  float   fzero = 0.0;
extern  long    kcounter;

static void DOWNset(downdp, npts)
 DOWNDAT *downdp;
 long    npts;
{
  register char *auxp;
  register long nbytes = npts * sizeof(float);

        if ((auxp = downdp->auxch.auxp) == NULL
	 || nbytes != downdp->auxch.size)
	    auxalloc(nbytes, &downdp->auxch);
        downdp->npts = npts;
}
	     
static void SPECset(specdp, npts)
 SPECDAT *specdp;
 long    npts;
{
  register char *auxp;
  register long nbytes = npts * sizeof(float);

        if ((auxp = specdp->auxch.auxp) == NULL
	 || nbytes != specdp->auxch.size)
	    auxalloc(nbytes, &specdp->auxch);
        specdp->npts = npts;
}
	     
void octdwnset(p)
 OCTDOWN *p;
{
	int	n, nocts, nsamps;
	float   *fltp;
	DOWNDAT *dwnp = p->dsig;
	OCTDAT  *octp;

	if ((p->disprd = ekr * *p->idisprd) < 0)  p->disprd = 0; /* posprd: display */
	nocts = *p->iocts;
	nsamps = *p->isamps;
	if (nocts != dwnp->nocts || nsamps != dwnp->nsamps     /* if params changed */
	 || !nocts || !nsamps || p->disprd && !p->dwindow.windid) {
	    long	totsamps, totsize;
	    double	hicps,oct,logtwo=0.693147;             /*   must alloc anew */
	    extern double onept;

	    if (nocts <= 0 || nocts > MAXOCTS)	initerror("illegal iocts");
	    if (nsamps <= 0)          	        initerror("illegal isamps");
	    if (inerrcnt) return;
	    if (p->h.optext->t.intype == 'k')
		dwnp->srate = ekr;                    /* define the srate           */
	    else dwnp->srate = esr;
	    hicps = dwnp->srate * 0.375;              /* top freq is 3/4 pi/2 ...   */
	    printf("octdown: high cps of %f\n",hicps);
	    if (p->h.optext->t.intype != 'k') {       /* for sr sampling:           */
	      oct = log(hicps / onept) / logtwo;      /* ... octcps()  (see aops.c) */
	      oct = ((int)(oct*12.0 + 0.5)) / 12.0;   /*     semitone round to A440 */
	      hicps = pow((double)2., oct) * onept;   /*     cpsoct()               */
	      printf("\t  retuned to %f\n",hicps);
	    }
	    dwnp->hifrq = hicps;
	    dwnp->lofrq = hicps / (1L << nocts);
	    dwnp->nsamps = nsamps;
	    dwnp->nocts = nocts;
	    totsamps = (long)nsamps * nocts;          /* calc totsamps reqd,        */
	    DOWNset(dwnp, totsamps);                  /* auxalloc in DOWNDAT struct */
	    fltp = (float *) dwnp->auxch.auxp;             /*  & distrib to octdata */
	    for (n=nocts,octp=dwnp->octdata+(nocts-1); n--; octp--) {
	        octp->begp = fltp;      fltp += nsamps;    /*        (lo oct first) */
		octp->endp = fltp;                     
	    }
	    if (p->disprd) {                               /* if display requested, */
	        totsize = totsamps * sizeof(float);        /*  alloc an equiv local */
		auxalloc((long)totsize, &p->auxch);        /*  linear output window */
	        dispset(&p->dwindow, (float *)p->auxch.auxp, (long)totsamps,
			"octdown buffers:", 0, "octdown");
	    }
	}
	for (octp=dwnp->octdata; nocts--; octp++) {   /* reset all oct params, &    */
	    octp->curp = octp->begp;
	    for (fltp=octp->feedback,n=6; n--; )
	        *fltp++ = fzero;
	    octp->scount = 0;
	}
	p->countdown = p->disprd;                    /* prime the display countdown */
}

static void linocts(dwnp, bufp)        /* linearize octdown data into one buffer */
 DOWNDAT *dwnp;                        /* presumes correct buffer alloc'd in set */
 register float  *bufp;
{
register float  *curp, *endp;
register int    wrap;
register OCTDAT *octp;
	 int    nocts;
	 float  *begp;

	nocts = dwnp->nocts;
	octp = dwnp->octdata + nocts;
	while (nocts--) {
	    octp--;                            /* for each octave (low to high) */
	    begp = octp->begp;
	    curp = octp->curp;
	    endp = octp->endp;
	    wrap = curp - begp;
	    while (curp < endp)                     /*   copy circbuf to linbuf */
	        *bufp++ = *curp++;
	    for (curp=begp; wrap--; )
	        *bufp++ = *curp++;
	}
}

static float bicoefs[] = { -0.2674054, 0.7491305, 0.7160484, 0.0496285, 0.7160484,
			    0.0505247, 0.3514850, 0.5257536, 0.3505025, 0.5257536,
			    0.3661840, 0.0837990, 0.3867783, 0.6764264, 0.3867783 };

void koctdown(p)
 OCTDOWN *p;
{
        float   *sigp = p->signal, SIG, yt1, yt2;
	int     nocts;
	DOWNDAT *dwnp = p->dsig;
	OCTDAT  *octp;

	SIG = *sigp++;                            /* for each source sample:     */
	octp = dwnp->octdata;                     /*   align onto top octave     */
	nocts = dwnp->nocts;
	do {                                      /*   then for each oct:        */
	    register float *coefp,*ytp,*curp;
	    register int   nfilt;
	    curp = octp->curp;
	    *curp++ = SIG;                            /*  write samp to cur buf  */
	    if (curp >= octp->endp)
		curp = octp->begp;                    /*    & modulo the pointer */
	    octp->curp = curp;
	    if (!(--nocts))  break;                   /*  if lastoct, break      */
	    coefp = bicoefs;  ytp = octp->feedback;
	    for (nfilt = 3; nfilt--; ) {              /*  apply triple biquad:   */
		yt2 = *ytp++; yt1 = *ytp--;                 /* get prev feedback */
		SIG -= (*coefp++ * yt1 + *coefp++ * yt2);   /* apply recurs filt */
		*ytp++ = yt1; *ytp++ = SIG;                 /* stor nxt feedback */
		SIG *= *coefp++;
		SIG += (*coefp++ * yt1 + *coefp++ * yt2);   /* apply forwrd filt */
	    }
	} while (!(++octp->scount & 01) && octp++);  /* send alt samps to nxtoct */

	if (p->disprd)                            /* if displays requested,      */
	    if (!(--p->countdown)) {              /*    on countdown             */
	        linocts(dwnp, p->auxch.auxp);     /*      linearize the oct bufs */
	        display(&p->dwindow);             /*      & display              */
		p->countdown = p->disprd;
	    }
}

void octdown(p)
 OCTDOWN *p;
{
        float   *sigp = p->signal, SIG, yt1, yt2;
	int     nocts, nsmps = ksmps;
	DOWNDAT *dwnp = p->dsig;
	OCTDAT  *octp;

	do {
	    SIG = *sigp++;                            /* for each source sample:     */
	    octp = dwnp->octdata;                     /*   align onto top octave     */
	    nocts = dwnp->nocts;
	    do {                                      /*   then for each oct:        */
	        register float *coefp,*ytp,*curp;
		register int   nfilt;
	        curp = octp->curp;
		*curp++ = SIG;                            /*  write samp to cur buf  */
		if (curp >= octp->endp)
		    curp = octp->begp;                    /*    & modulo the pointer */
		octp->curp = curp;
		if (!(--nocts))  break;                   /*  if lastoct, break      */
		coefp = bicoefs;  ytp = octp->feedback;
		for (nfilt = 3; nfilt--; ) {              /*  apply triple biquad:   */
		    yt2 = *ytp++; yt1 = *ytp--;                 /* get prev feedback */
		    SIG -= (*coefp++ * yt1 + *coefp++ * yt2);   /* apply recurs filt */
		    *ytp++ = yt1; *ytp++ = SIG;                 /* stor nxt feedback */
		    SIG *= *coefp++;
		    SIG += (*coefp++ * yt1 + *coefp++ * yt2);   /* apply forwrd filt */
		}
	    } while (!(++octp->scount & 01) && octp++);  /* send alt samps to nxtoct */
	} while (--nsmps);

	if (p->disprd)                                /* if displays requested,      */
	    if (!(--p->countdown)) {                  /*    on countdown             */
	        linocts(dwnp, p->auxch.auxp);         /*      linearize the oct bufs */
	        display(&p->dwindow);                 /*      & display              */
		p->countdown = p->disprd;
	    }
}

static char *getstrdbout(dbcode)
 int dbcode;
{
static char *outstring[] = {"mag", "db", "mag squared"};
        switch (dbcode) {
	case 0:
	case 1:
	case 2:  return(outstring[dbcode]);
	default: return("unknown dbcode");
	}
}

void nocdfset(p) /* noctdft - calcs disc Fourier transform of oct-downsampled data */
 NOCTDFT *p;	 /* outputs coefs (mag, db or mag2) of log freq within each octave */
{
	int	nfreqs, hanning, nocts, ncoefs;
	float   Q, *fltp;
	OCTDAT  *octp;
	DOWNDAT *downp = p->dsig;
	SPECDAT *specp = p->wsig;

	p->timcount = ekr * *p->iprd;
	nfreqs = *p->ifrqs;
	Q = *p->iq;
	hanning = (*p->ihann) ? 1 : 0;
	if ((p->dbout = *p->idbout) && p->dbout != 1 && p->dbout != 2) {
	    sprintf(errmsg, "noctdft: unknown dbout code of %d", p->dbout);
	    initerror(errmsg);
	}
	nocts = downp->nocts;
	ncoefs = nocts * nfreqs;
	if (nfreqs != p->nfreqs || Q != p->curq             /* if anything changed */
	     || p->timcount <= 0 || Q <= 0.
	     || hanning != p->hanning
	     || ncoefs != p->ncoefs) {                      /*     make new tables */
	    double	basfrq, curfrq, frqmlt, Qfactor;
	    double	theta, a, windamp, onedws, pidws;
	    float	*sinp, *cosp;
	    int         n, k, sumk, windsiz, *wsizp, nsamps;
	    long	auxsiz;

	    fprintf(stderr,"noctdft: %s window, %s out, making tables ...\n",
		    (hanning) ? "hanning":"hamming", getstrdbout(p->dbout));
	    if (p->timcount <= 0)                initerror("illegal iprd");
	    if (nfreqs <= 0 || nfreqs > MAXFRQS) initerror("illegal ifrqs");
	    if (Q <= fzero)                      initerror("illegal Q value");
	    if (inerrcnt)     return;
	    nsamps = downp->nsamps;
	    p->nfreqs = nfreqs;
	    p->curq = Q;
	    p->hanning = hanning;
	    p->ncoefs = ncoefs;
	    basfrq = downp->hifrq/2.0 * twopi/downp->srate; /* oct below retuned top */
	    frqmlt = pow((double)2.0,(double)1./nfreqs);    /* nfreq interval mult */
	    Qfactor = 6.2831854 * Q;
	    curfrq = basfrq;
	    for (sumk=0,wsizp=p->winlen,n=nfreqs; n--; ) {
	        *wsizp++ = k = Qfactor/curfrq + 0.5;         /* calc window sizes  */
		sumk += k;                                   /*   and find total   */
	/*	printf("frq %f, k = %d\n",curfrq,k);  */
		curfrq *= frqmlt;
	    }
	    if ((windsiz = *(p->winlen)) > nsamps) {        /* chk longest windsiz */
	        sprintf(errmsg,"Q %4.1f needs %d samples, octdown has just %d",
			Q, windsiz, nsamps);
		initerror(errmsg);
		return;
	    }
	    else printf("noctdft: Q %4.1f uses %d of %d samps per octdown\n",
			Q, windsiz, nsamps);
	    auxsiz = (nsamps + 2*sumk) * sizeof(float);    /* calc local space reqd */
	    auxalloc((long)auxsiz, &p->auxch);             /*     & alloc auxspace  */
	    fltp = (float *) p->auxch.auxp;
	    p->linbufp = fltp;  	fltp += nsamps; /* linbuf must handle nsamps */
	    p->sinp = sinp = fltp;	fltp += sumk;
	    p->cosp = cosp = fltp;                         /* cos gets rem sumk  */
	    wsizp = p->winlen;
	    for (curfrq=basfrq,n=nfreqs; n--; ) {      	    /* now fill tables */
	        windsiz = *wsizp++;
		onedws = 1.0 / windsiz;
		pidws = 3.1415927 / windsiz;
		for (k=0; k<windsiz; k++) {     	    /*   with sines    */
		    a = sin(k * pidws);
		    windamp = a * a;            	    /*   times hanning */
		    if (!hanning)
		        windamp = 0.08 + 0.92 * windamp;    /*   or hamming    */
		    windamp *= onedws;                      /*   scaled        */
		    theta = k * curfrq;
		    *sinp++ = windamp * sin(theta);
		    *cosp++ = windamp * cos(theta);
		}
		curfrq *= frqmlt;                           /*   step by log freq  */
	    }
	    if (*p->idsines != 0.0) {    /* if reqd, display windowed sines immediately */
	        dispset(&p->dwindow,p->sinp,(long)sumk,"octdft windowed sines:",
			0,"octdft");
		display(&p->dwindow);
	    }
	    SPECset(specp, (long)ncoefs);                /* prep the spec dspace */
	    specp->downsrcp = downp;                     /*  & record its source */
	}
	specp->dbout = p->dbout;                   /* enter specdata dbout type */
	specp->ktimstamp = 0;                      /* init specdata to not new  */
	specp->ktimprd = p->timcount;
	p->countdown = p->timcount;                /*     & prime the countdown */
}

void noctdft(p)
 NOCTDFT *p;
{
	DOWNDAT *downp;
	SPECDAT *specp;
        OCTDAT  *octp;
	float   *dftp;
        int     nocts, wrap;
	float   a, b;
	double  c;

	if ((--p->countdown))  return;         /* if not yet time for new spec, return */
	p->countdown = p->timcount;            /* else reset counter & proceed:        */
	downp = p->dsig;
	specp = p->wsig;
	nocts = downp->nocts;
	octp = downp->octdata + nocts;
	dftp = (float *) specp->auxch.auxp;
	while (nocts--) {
	    register float  *bufp, *sinp, *cosp;
	    register int    len, *lenp, nfreqs;
	    register float   *begp, *curp, *endp;
	    octp--;                              /* for each octave (low to high)   */
	    begp = octp->begp;
	    curp = octp->curp;
	    endp = octp->endp;
	    wrap = curp - begp;
	    bufp = p->linbufp;
	    while (curp < endp)                    /*   copy circbuf to linbuf   */
	        *bufp++ = *curp++;
	    for (curp=begp,len=wrap; len--; )
	        *bufp++ = *curp++;
	    cosp = p->cosp;                        /*   get start windowed sines */
	    sinp = p->sinp;
	    lenp = p->winlen;
	    for (nfreqs=p->nfreqs; nfreqs--; ) {   /*   now for each freq this oct: */
	        a = 0.0;
		b = 0.0;
		bufp = p->linbufp;
		for (len = *lenp++; len--; bufp++) {    /*  apply windowed sine seg */
		    a += *bufp * *cosp++;
		    b += *bufp * *sinp++;
		}
		c = a*a + b*b;                          /*  get magnitude squared   */
		if (!(p->dbout))                        /*    & optionally convert  */
		    c = sqrt(c);                        /*    to  mag or db         */
		else if (p->dbout == 1) {
		    if (c < .001) c = .001;
		    c = 10. * log10(c);
		}
		*dftp++ = c;                            /*  store in out spectrum   */
	    }
	}
	specp->ktimstamp = kcounter;                    /* time-stamp the output    */
}

void spsclset(p)
 SPECSCAL *p;
{
        SPECDAT *inspecp = p->wsig;
        SPECDAT *outspecp = p->wscaled;
	FUNC    *ftp;
	long    npts;

	if ((npts = inspecp->npts) != outspecp->npts) {  /* if size has changed,   */
	    SPECset(outspecp, (long)npts);               /*    realloc             */
	    outspecp->downsrcp = inspecp->downsrcp;
	    auxalloc((long)npts * 2 * sizeof(float), &p->auxch);
	}
	outspecp->ktimprd = inspecp->ktimprd;      /* pass the source spec info     */
	outspecp->dbout = inspecp->dbout;
	p->fscale = (float *) p->auxch.auxp;       /* setup scale & thresh fn areas */
	p->fthresh = p->fscale + npts;
	if ((ftp=ftfind(p->ifscale)) == NULL)            /* if fscale given,        */
	    initerror("missing fscale table");
	else {
	    register long nn = npts;
	    register long phs = 0;         
	    register long inc = (long)PMASK / npts;
	    register long lobits = ftp->lobits;
	    register float *ftable = ftp->ftable;
	    register float *flp = p->fscale;
	    do {
		*flp++ = *(ftable + (phs >> lobits));    /*  sample into scale area */
		phs += inc;
	    } while (--nn);
	}
	if ((p->thresh = *p->ifthresh)
	 && (ftp=ftfind(p->ifthresh)) != NULL) {         /* if fthresh given,       */
	    register long nn = npts;
	    register long phs = 0;         
	    register long inc = (long)PMASK / npts;
	    register long lobits = ftp->lobits;
	    register float *ftable = ftp->ftable;
	    register float *flp = p->fthresh;
	    do {
		*flp++ = *(ftable + (phs >> lobits));    /*  sample into thresh area */
		phs += inc;
	    } while (--nn);
	}
	else p->thresh = 0;
	outspecp->ktimstamp = 0;                        /* mark the out spec not new */
}

void specscal(p)
 SPECSCAL *p;
{
        SPECDAT *inspecp = p->wsig;

	if (inspecp->ktimstamp == kcounter) {          /* if inspectrum is new:      */
	    SPECDAT *outspecp = p->wscaled;
	    register float *inp = (float *) inspecp->auxch.auxp;
	    register float *outp = (float *) outspecp->auxch.auxp;
	    register float *sclp = p->fscale;
	    register long npts = inspecp->npts;

	    if (p->thresh) {                              /* if thresh requested,    */
	        register float *threshp = p->fthresh;
		register float val;
		do {
		    if ((val = *inp++ - *threshp++) > 0.) /*   for vals above thresh */
		        *outp++ = val * *sclp;            /*     scale & write out   */
		    else *outp++ = 0.;                    /*   else output is 0.     */
		    sclp++;
		} while (--npts);
	    }
	    else {
	        do *outp++ = *inp++ * *sclp++;            /* no thresh: rescale only */
		while (--npts);
	    }
	    outspecp->ktimstamp = kcounter;               /* mark the outspec as new */
	}
}

void spsumset(p)
 SPECSUM *p;
{
        p->kinterp = (*p->interp == 0.) ? 0 : 1;
        p->kval = 0.;
	p->kinc = 0.;
}

void specsum(p)    /* sum all vals of a spectrum and put as ksig */
 SPECSUM *p;       /*         optionally interpolate the output  */
{
        SPECDAT *specp = p->wsig;

        if (specp->ktimstamp == kcounter) {                  /* if spectrum is new   */
	    register float *valp = (float *) specp->auxch.auxp;
	    register float sum = 0.;
	    register long npts = specp->npts;                /*   sum all the values */
	    do 	sum += *valp++;
	    while (--npts);
	    if (p->kinterp)                                  /*   new kinc if interp */
	        p->kinc = (sum - p->kval) / specp->ktimprd;
	    else p->kval = sum;
	}
	*p->ksum = p->kval;       /* output current kval */
	if (p->kinterp)           /*   & interp if reqd  */
	    p->kval += p->kinc;
}

void spadmset(p)
 SPECADDM *p;
{
        SPECDAT *inspec1p = p->wsig1;
        SPECDAT *inspec2p = p->wsig2;
register int   npts;

	if ((npts = inspec1p->npts) != inspec2p->npts)
	    initerror("inputs have different sizes");    /* inspecs must agree in size */
	if (inspec1p->ktimprd != inspec2p->ktimprd)
	    initerror("inputs have diff. time periods"); /*                time period */
	if (inspec1p->dbout != inspec2p->dbout)
	    initerror("inputs have different amptypes"); /*                and db type */
	if (inerrcnt)
	    return;
	if (npts != p->waddm->npts) {                    /* if out doesn't match ins */
	    SPECset(p->waddm, (long)npts);               /*     reinit the out spec */
	    p->waddm->downsrcp = inspec1p->downsrcp;
	}
	p->waddm->ktimprd = inspec1p->ktimprd;           /* pass the other specinfo */
	p->waddm->dbout = inspec1p->dbout;
	p->waddm->ktimstamp = 0;                         /* mark the outspec not new */
}

void specaddm(p)
 SPECADDM *p;
{
	if (p->wsig1->ktimstamp == kcounter) {             /* if inspec1 is new:     */
	    register float *in1p = (float *) p->wsig1->auxch.auxp;
	    register float *in2p = (float *) p->wsig2->auxch.auxp;
	    register float *outp = (float *) p->waddm->auxch.auxp;
	    register float mul2 = p->mul2;
	    register int   npts = p->wsig1->npts;

	    do *outp++ = *in1p++ + *in2p++ * mul2;         /* out = in1 + in2 * mul2 */
	    while (--npts);
	    p->waddm->ktimstamp = kcounter;           /* mark the output spec as new */
	}
}

void spdifset(p)
 SPECDIFF *p;
{
        SPECDAT *inspecp = p->wsig;
register float *lclp;
register float *outp;
register int   npts;

	if ((npts = inspecp->npts) != p->specsave.npts) {  /* if inspec not matched  */
	    SPECset(&p->specsave, (long)npts);             /*   reinit the save spec */
	    SPECset(p->wdiff, (long)npts);                 /*   & the out diff spec  */
	    p->wdiff->downsrcp = inspecp->downsrcp;
	}
	p->wdiff->ktimprd = inspecp->ktimprd;             /* pass the other specinfo */
	p->wdiff->dbout = inspecp->dbout;
	lclp = (float *) p->specsave.auxch.auxp;
	outp = (float *) p->wdiff->auxch.auxp;
	do {
	    *lclp++ = 0.;                    /* clr local & out spec bufs */
	    *outp++ = 0.;
	} while (--npts);
	p->wdiff->ktimstamp = 0;             /* mark the out spec not new */
}

void specdiff(p)
 SPECDIFF *p;
{
        SPECDAT *inspecp = p->wsig;

	if (inspecp->ktimstamp == kcounter) {     /* if inspectrum is new:     */
	    register float *newp = (float *) inspecp->auxch.auxp;
	    register float *prvp = (float *) p->specsave.auxch.auxp;
	    register float *difp = (float *) p->wdiff->auxch.auxp;
	    register float newval, prvval, diff, possum = 0.;
	    register int   npts = inspecp->npts;

	    do {
	        newval = *newp++;                   /* compare new & old coefs */
		prvval = *prvp;
		if ((diff = newval-prvval) > 0.) {  /* if new coef > prv coef  */
		    *difp++ = diff;
		    possum += diff;                 /*   enter & accum diff    */
		}
		else *difp++ = 0.;                  /* else enter zero         */
		*prvp++ = newval;                   /* sav newval for nxt time */
	    } while (--npts);
	    p->wdiff->ktimstamp = kcounter;     /* mark the output spec as new */
	}
}

void spacmset(p)
 SPECACCM *p;
{
        SPECDAT *inspecp = p->wsig;
register float *lclp;
register float *outp;
register int   npts;

	if ((npts = inspecp->npts) != p->accumer.npts) { /* if inspec not matched   */
	    SPECset(&p->accumer, (long)npts);            /*   reinit the accum spec */
	    SPECset(p->wacout, (long)npts);              /*    & the output spec    */
	    p->wacout->downsrcp = inspecp->downsrcp;
	}
	p->wacout->ktimprd = inspecp->ktimprd;           /* pass the other specinfo */
	p->wacout->dbout = inspecp->dbout;
	lclp = (float *) p->accumer.auxch.auxp;
	outp = (float *) p->wacout->auxch.auxp;
	do {
	    *lclp++ = 0.;                    /* clr local & out spec bufs */
	    *outp++ = 0.;
	} while (--npts);
	p->wacout->ktimstamp = 0;             /* mark the out spec not new */
}

void specaccm(p)
 SPECACCM *p;
{
        SPECDAT *inspecp = p->wsig;

	if (inspecp->ktimstamp == kcounter) {     /* if inspectrum is new:     */
	    register float *newp = (float *) inspecp->auxch.auxp;
	    register float *acup = (float *) p->accumer.auxch.auxp;
	    register float *outp = (float *) p->wacout->auxch.auxp;
	    register float newval;
	    register int   npts = inspecp->npts;

	    do {
	        newval = *acup + *newp++;           /* add new to old coefs */
		*acup++ = newval;                   /* sav in accumulator   */
		*outp++ = newval;                   /* & copy to output     */
	    } while (--npts);
	    p->wacout->ktimstamp = kcounter;     /* mark the output spec as new */
	}
}

void spfilset(p)
 SPECFILT *p;
{
        SPECDAT *inspecp = p->wsig;
        SPECDAT *outspecp = p->wfil;
	FUNC    *ftp;
	long    npts;

	if ((npts = inspecp->npts) != outspecp->npts) {    /* if inspec not matched */
	    SPECset(outspecp, (long)npts);                 /*   reinit the out spec */
	    auxalloc((long)npts*2* sizeof(float), &p->auxch);/*   & local auxspace  */
	    p->coefs = (float *) p->auxch.auxp;            /*   reassign filt tbls  */
	    p->states = p->coefs + npts;
	}
	outspecp->ktimprd = inspecp->ktimprd;              /* pass other spect info */
	outspecp->dbout = inspecp->dbout;
	outspecp->downsrcp = inspecp->downsrcp;
	if ((ftp=ftfind(p->ifhtim)) == NULL) {          /* if fhtim table given,    */
	    initerror("missing htim ftable");
	    return;
	}
	{
	    register long nn = npts;
	    register long phs = 0;         
	    register long inc = (long)PMASK / npts;
	    register long lobits = ftp->lobits;
	    register float *ftable = ftp->ftable;
	    register float *flp = p->coefs;
	    do {
		*flp++ = *(ftable + (phs >> lobits));    /*  sample into coefs area */
		phs += inc;
	    } while (--nn);
	}
	{
	    register long  nn = npts;
	    register float *flp = p->coefs;
	    double halftim, reittim = inspecp->ktimprd/ekr;
	    do {
	        if ((halftim = *flp) > 0.)
		    *flp++ = pow((double).5, reittim/halftim);
		else initerror("htim ftable must be all-positive");
	    } while (--nn);
	}
  printf("coef range: %6.3f - %6.3f\n", *p->coefs, *(p->coefs+npts-1));
	{
	    register float *flp = (float *) p->states;
	    do  *flp++ = 0.;                       /* clr the persist buf state mem */
	    while (--npts);
	}
	outspecp->ktimstamp = 0;                 /* mark the output spec as not new */
}

void specfilt(p)
 SPECFILT *p;
{
	if (p->wsig->ktimstamp == kcounter) {          /* if input spec is new,  */
	    SPECDAT *inspecp = p->wsig;
	    SPECDAT *outspecp = p->wfil;
	    register float *newp = (float *) inspecp->auxch.auxp;
	    register float *outp = (float *) outspecp->auxch.auxp;
	    register float curval, *coefp = p->coefs;
	    register float *persp = p->states;
	    register int   npts = inspecp->npts;

	    do {                                         /* for npts of inspec:     */
	        *outp++ = curval = *persp;               /*   output current point  */
		*persp++ = *coefp++ * curval + *newp++;  /*   decay & addin newval  */
	    } while (--npts);
	    outspecp->ktimstamp = kcounter;              /* mark output spec as new */
	}
}

void spdspset(p)
 SPECDISP *p;
{
	if ((p->timcount = ekr * *p->iprd) <= 0) initerror("illegal iperiod");
	if (!(p->dwindow.windid)) {
	    SPECDAT *specp = p->wsig;
	    DOWNDAT *downp = specp->downsrcp;
	    if (downp->lofrq > 5.) {
	      sprintf(strmsg,"instr %d, dft (%s), %ld octaves (%d - %d Hz):",
		        p->h.insdshead->insno, getstrdbout(specp->dbout),
		        downp->nocts, (int)downp->lofrq, (int)downp->hifrq);
	    }
	    else {                      /* more detail if low frequency  */
	      sprintf(strmsg,"instr %d, dft (%s), %ld octaves (%3.1f - %3.1f Hz):",
		        p->h.insdshead->insno, getstrdbout(specp->dbout),
		        downp->nocts, downp->lofrq, downp->hifrq);
	    }
	    dispset(&p->dwindow, (float *)specp->auxch.auxp,
		    (long)specp->npts, strmsg, (int)*p->iwtflg, "specdisp");
	}
	p->countdown = p->timcount;          /* prime the countdown */
}

void specdisp(p)
 SPECDISP *p;
{
	if (!(--p->countdown)) {               /* on countdown     */
	    display(&p->dwindow);	       /*    display spect */
	    p->countdown = p->timcount;        /*    & reset count */
	}
}
