#define __RAWKS_SCORE__
#define DBG 0

#include "defines.h"
#include "struct.h"
#include "protos.h"
#include "globals.h"

#define SCR_BOTTOM		10
#define SCR_TOP			20
#define SCR_LEFT		10
#define SCR_RIGHT		Sizex-1

#define Y_SCORE_POS 0.95
#define X_SCORE_POS -0.98
static int spacing;
static char string[2][MAX_PLAYERS+1][2][80];
static int sfont[MAX_PLAYERS+1];

void init_score_fonts(void)
{
  int i;
  
  for(i=1;i<=MAX_PLAYERS;i++) {
    sfont[i] = openvecfont(60,25,0.7);
    vmov2(sfont[i],0.0,(i>2)?(-Y_SCORE_POS):(Y_SCORE_POS));
    if(i>2) vmovrel2(sfont[i],0,-1);
  }
}

void draw_text(void)
{
  int i;

  for(i=1;i<=Num_scores;i++) {
    if(!Opts.nodbuff) {
      C_BLACK;
      if(i&1) { /* P[13] */
	vlprint(sfont[i],string[0][i][Frm]);
	vlprint(sfont[i],string[1][i][Frm]);
      }
      else {
	vrprint(sfont[i],string[0][i][Frm]);
	vrprint(sfont[i],string[1][i][Frm]);
      }
      vmovrel2(sfont[i],0.0,-2.0);
      cpack(P[i].color);
      if(i&1) { /* If odd numbered player */
	sprintf(string[i>2][i][Frm],"\01%d \04%03d \02%d \03%05d",
	    P[i].numlives,
	    P[i].fired,
	    P[i].hit,
	    P[i].score
	);
	strcpy(string[i<3][i][Frm],P[i].message);

	vlprint(sfont[i],string[0][i][Frm]);
	vlprint(sfont[i],string[1][i][Frm]);
      }
      else {
	sprintf(string[i>2][i][Frm],"%05d\03 %d\02 %03d\04 %d\01",
	    P[i].score,
	    P[i].hit,
	    P[i].fired,
	    P[i].numlives
	);
	strcpy(string[i<3][i][Frm],P[i].message);

	vrprint(sfont[i],string[0][i][Frm]);
	vrprint(sfont[i],string[1][i][Frm]);
      }
      vmovrel2(sfont[i],0.0,-2.0);
    }
    else { /* No double buffering */

      static int framecount[4] = {0,5,10,15};

      if( framecount[i] > 20 )
      {
        static int ppong[4] = {0};

        ppong[i] = !ppong[i];
        framecount[i] = 0;

	cpack(P[i].color);

	if(i&1) { /* If odd numbered player */
	  sprintf(string[i>2][i][ppong[i]],"\01%d \04%03d \02%d \03%05d",
	      P[i].numlives,
	      P[i].fired,
	      P[i].hit,
	      P[i].score
	  );
	  strcpy(string[i<3][i][ppong[i]],P[i].message);

	  vleprint(sfont[i],string[0][i][ppong[i]],string[0][i][!ppong[i]]);
	  vleprint(sfont[i],string[1][i][ppong[i]],string[1][i][!ppong[i]]);
	  vmovrel2(sfont[i],0.0,-2.0);
	}
	else {
	  sprintf(string[i>2][i][ppong[i]],"%05d\03 %d\02 %03d\04 %d\01",
	      P[i].score,
	      P[i].hit,
	      P[i].fired,
	      P[i].numlives
	  );
	  strcpy(string[i<3][i][ppong[i]],P[i].message);

	  vreprint(sfont[i],string[0][i][ppong[i]],string[0][i][!ppong[i]]);
	  vreprint(sfont[i],string[1][i][ppong[i]],string[1][i][!ppong[i]]);
	  vmovrel2(sfont[i],0.0,-2.0);
	}
      }
      else /* No change in the player status */
      {
	framecount[i]++;
      }
    }
  }
}
