#include <string.h>
#include <stdio.h>

/* These f()'s are in libgutil and also in SYSVR4, and in BSD (I think).
   And they probably work better than the following functions.
   However, there are some functions that just can't be found in IRIX4.x
   that I have to rewrite to maintain some degree of portability across
   platforms. - Aaron Michael Hightower */

static char *dot = ".";
static char *slash = "/";
static char buffer[257];

/* This routine should not create or destroy any memory/strings */
char *amh_basename(char *string)
{
  int i;

  if(!string || !string[0]) return dot;

  strncpy(buffer,string,257);
  buffer[256] = 0;

  i=strlen(buffer)-1;
  while(buffer[i]=='/' && i) {
    buffer[i--] = 0; /* Remove trailing slashes */
  }
  while(i>0 && buffer[i-1]!='/') i--;

  if(i==0) return buffer;
  else return buffer+i;
}

char *amh_dirname(char *string)
{
  int len;
  char *rval;

  if(!string || !strcmp(string,".") || !strcmp(string,"..")) return dot;

  len = strlen(string);
  rval = amh_basename(string);
  if(rval - buffer >=1 && rval - buffer <= 256) {
    if(rval - buffer == 1 && buffer[0] == '/') buffer[1]=0;
    else rval[-1] = 0;
    return buffer;
  }
  else if(!strcmp(rval,".")) return buffer;
  else if(!strcmp(rval,"/")) return slash;
  else return dot;
}
