{
  v[i,0] = $1
  v[i,1] = $2
  v[i,2] = $3

  i = i + 1
}

END {
  num_verts = i

  if(ARGC < 3) {
    frame_delay = 0.2;
    num_frames = 10
    num_cubes = 1
    period = 2
  }
  else {
    num_frames  = ARGV[1];
    num_cubes   = ARGV[2];
    frame_delay = ARGV[3];
  }
  num_lines = 16
  temp = num_lines - 1
  pi2= 2*atan2(0,-1);

  printf("%d %d %f\n",num_frames,num_verts,frame_delay); 

  for(k=0;k<num_frames;k++) {
    t1 = (k/num_frames)*pi2;
    t3 = (k/(num_frames-1))*pi2;

    for(j=0;j<num_verts;j++) {
      t2 = (j/num_verts)*pi2;
      t4 = (j/(num_verts-1))*pi2;

      temp = temp + 1
      if(temp > 15) {
	temp = 0
        flags = !flags
      }
      else flags = !flags

      x = v[j,0];
      y = v[j,1];
      z = v[j,2];

      scale((int(j/16)+1)*(10/num_verts));
      rotz(pi2/0.3)
      rotx(1.06)
      roty(t1)
      red   = cos(t4) * 127 + 128
      green = sin(t4) * 127 + 128
      blue  = int((j/(num_verts-1)) * 255)

      printf("%d %f %f %f %02x%02x%02x\n",flags,x,y,z,blue,green,red);
    }
  }
  exit(0);
}

function rotx(angle) {
  y1 = y
  y =  cos(angle) * y1 + sin(angle) * z
  z = -sin(angle) * y1 + cos(angle) * z
}

function roty(angle) {
  z1 = z
  z =  cos(angle)*z1 + sin(angle) * x
  x = -sin(angle)* z1 + cos(angle) * x
}

function rotz(angle) {
  x1 = x
  x =  cos(angle) * x1 + sin(angle) * y
  y = -sin(angle) * x1 + cos(angle) * y
}

function scale(value) {
  x = x * value;
  y = y * value;
  z = z * value;
}
