/*
 * kw.h --
 *	Declarations for Keyword type.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/access/RCS/kw.h,v 1.6 1991/05/22 14:00:59 kemnitz Exp $
 */

#ifndef KWIncluded
#define KWIncluded

#ifdef NOTDEF

#include "tmp/postgres.h"

/*
 * Keyword class definitions.
 */

typedef	char16		KeywordData;
typedef	KeywordData	*Keyword;


/*
 * Interface procedure definitions.
 */

/*#define KWREGEX*/	/* regex operators */

#ifdef KWTEST
#define	palloc	malloc
#define pfree	free
#endif /* KWTEST */

extern Keyword	keyword_in();
extern char	*keyword_out();
extern int32	kw_cmp();
extern int32	kw_eq();
extern int32	kw_ne();
extern int32	kw_le();
extern int32	kw_lt();
extern int32	kw_ge();
extern int32	kw_gt();


/*
 * Internal macro definitions.
 */

#define	KeywordGetData(kw)	((kw)->data)

#define	InvalidKeyword		((Keyword) NULL)
#define	KeywordIsValid(kw)	((kw) != InvalidKeyword)

#endif /* NOTDEF */
#endif /* !KWIncluded */
