/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 6.1 of the 
*Andrew User Interface System and is 
*the property of IBM, Carnegie Mellon University, 
*and the other copyright holders.  The source 
*code of this version is for the sole use of 
*the individual named in ./config/allsys.h.  
*This source code is not to be redistributed.  
*Binary object code compiled or derived from 
*these sources is not to be distributed to non-
*members.  Members may have additional 
*distribution rights granted by prior written 
*permission of Carnegie Mellon University.
*
*IBM, CARNEGIE MELLON UNIVERSITY, 
*AND THE OTHER COPYRIGHT HOLDERS
* DISCLAIM ALL WARRANTIES WITH 
*REGARD TO THIS SOFTWARE, INCLUDING 
*ALL IMPLIED WARRANTIES OF MERCHANT-
*ABILITY AND FITNESS. IN 
*NO EVENT SHALL  IBM, CARNEGIE 
*MELLON UNIVERSITY, OR ANY OTHER 
*COPYRIGHT HOLDER BE LIABLE FOR 
*ANY SPECIAL, INDIRECT OR CONSE-
*QUENTIAL DAMAGES OR ANY DAMAGES 
*WHATSOEVER RESULTING FROM LOSS OF
*USE, DATA OR PROFITS, WHETHER IN AN
*ACTION OF CONTRACT, NEGLIGENCE OR
*OTHER TORTIOUS ACTION, ARISING OUT 
*OF OR IN CONNECTION WITH THE USE OR
*PERFORMANCE OF THIS SOFTWARE.
* $
*/


 

/* A hash table
 *
 */

#define ghash_BUCKETS 32

class ghash {

classprocedures:
    InitializeObject(struct ghash *self) returns boolean;
    FinalizeObject(struct ghash *self);
    InitializeClass() returns boolean;
methods:
    Lookup(char *key) returns char *;
    LookupKey(char *key) returns char *;
    Store(char *key, char *value) returns boolean;
    Delete(char *key) returns char *;
    Rename(char *key, char *new) returns char *;
    Clear();
    Enumerate(procedure proc, long rock) returns char *;
    Debug();
macromethods:
    SetHash(fn) (self->hash = ((procedure)fn))
    SetFreeVal(fn) (self->freeVal = ((procedure)fn))
    SetFreeKey(fn) (self->freeKey = ((procedure)fn))
    SetCopyKey(fn) (self->copyKey = ((procedure)fn))
    SetCopyVal(fn) (self->copyVal = ((procedure)fn))
    SetCompareKey(fn) (self->compKey = ((procedure)fn))
    GetFreeVal() (self->freeVal)
    GetFreeKey() (self->freeKey)
    GetCopyKey() ((char *(*)())self->copyKey)
    GetCopyVal() ((char *(*)())self->copyVal)
    GetCompareKey() ((int (*)())self->compKey)

data:
    struct glist *buckets[ghash_BUCKETS];
    procedure hash;
    procedure freeVal, freeKey;
    procedure copyVal, copyKey;
    procedure compKey;
};
