/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 6.1 of the 
*Andrew User Interface System and is 
*the property of IBM, Carnegie Mellon University, 
*and the other copyright holders.  The source 
*code of this version is for the sole use of 
*the individual named in ./config/allsys.h.  
*This source code is not to be redistributed.  
*Binary object code compiled or derived from 
*these sources is not to be distributed to non-
*members.  Members may have additional 
*distribution rights granted by prior written 
*permission of Carnegie Mellon University.
*
*IBM, CARNEGIE MELLON UNIVERSITY, 
*AND THE OTHER COPYRIGHT HOLDERS
* DISCLAIM ALL WARRANTIES WITH 
*REGARD TO THIS SOFTWARE, INCLUDING 
*ALL IMPLIED WARRANTIES OF MERCHANT-
*ABILITY AND FITNESS. IN 
*NO EVENT SHALL  IBM, CARNEGIE 
*MELLON UNIVERSITY, OR ANY OTHER 
*COPYRIGHT HOLDER BE LIABLE FOR 
*ANY SPECIAL, INDIRECT OR CONSE-
*QUENTIAL DAMAGES OR ANY DAMAGES 
*WHATSOEVER RESULTING FROM LOSS OF
*USE, DATA OR PROFITS, WHETHER IN AN
*ACTION OF CONTRACT, NEGLIGENCE OR
*OTHER TORTIOUS ACTION, ARISING OUT 
*OF OR IN CONNECTION WITH THE USE OR
*PERFORMANCE OF THIS SOFTWARE.
* $
*/


/* asmtext.ch: Text subclass specialized for dealing with Assembly code. */

#include <mark.ih>
#include <envrment.ih>

#define MAX_BANGCHARS 32 /* arbitrary limit for how many chars can be bang-comment-starters */
#define MAX_TABSTOPS  80 /* arbitrary number for how many Tab Stops can be set in preferences */

class asmtext: srctext {

  overrides:
    Indent(struct mark *range) returns long;
    Keywordify(char *buff, boolean checkforceupper) returns char *;
    RedoStyles();
    SetAttributes(struct attributes *atts);

  methods:

  classprocedures:
    InitializeClass() returns boolean;
    InitializeObject(struct asmtext *self) returns boolean;

  macromethods:
    SetCComments(boolean newValue) (((self)->CComments) = (newValue))
    UseCComments() ((self)->CComments)
    HasReindentFilter() ((self)->reindentFilterName!=NULL && *((self)->reindentFilterName)!='\0')
    ReindentFilterName() ((self)->reindentFilterName)

  data:
    boolean CComments;
    char bangComments[MAX_BANGCHARS+1];
    char *reindentFilterName;
};

