/* $Id: isdnlog.c,v 2.00 1996/01/10 20:10:16 akool Exp akool $
 *
 * ISDN accounting for isdn4linux. (log-module)
 *
 * Copyright 1995, 1996 by Andreas Kool (akool@Kool.f.EUnet.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: isdnlog.c,v $
 * Revision 2.00  1996/01/10  20:10:16  akool
 * Vollstaendiges Redesign, basierend auf der "call reference"
 * WARNING: Requires Patch of 'q931.c'
 *
 * Revision 1.25  1995/11/18  14:38:16  akool
 * AOC von Anrufen auf 0130-xxx werden korrekt ausgewertet
 *
 * Revision 1.24  1995/11/12  11:08:16  akool
 * Auch die "call reference" wird (ansatzweise) ausgewertet
 * Neue Option "-x" aktiviert X11-Popup
 * Date/Time wird ausgewertet
 * AOC-D wird korrekt ausgewertet
 * Neue Option "-t" setzt Systemzeit auf die von der VSt gemeldete
 * Die "-m" Option kann nun auch mehrfach (additiv) angegeben werden
 *
 * Revision 1.23  1995/11/06  18:03:16  akool
 * "-m16" zeigt die Cause im Klartext an
 * Auch Gebuehreneinheiten > 255 werden korrekt ausgewertet
 *
 * Revision 1.22  1995/10/22  14:43:16  akool
 * General cleanup
 * "isdn.log" um 'I' == dialin / 'O' == dialout erweitert
 * Auch nicht zustande gekommene Verbindungen werden (mit cause)
 * protokolliert
 *
 * Revision 1.21  1995/10/18  21:25:16  akool
 * Option "-r" implementiert
 * Charging-Infos waehrend der Verbindung (FACILITY) werden ignoriert
 * "/etc/isdnlog.pid" wird erzeugt
 *
 * Revision 1.20  1995/10/15  17:23:16  akool
 * Volles D-Kanal Protokoll implementiert (fuer Teles-0.4d Treiber)
 *
 * Revision 1.13  1995/09/30  09:34:16  akool
 * Option "-m", Console-Meldung implementiert
 * Flush bei SIGTERM implementiert
 *
 * Revision 1.12  1995/09/29  17:21:13  akool
 * "isdn.log" um Zeiteintrag in UTC erweitert
 *
 * Revision 1.11  1995/09/28  18:51:17  akool
 * First public release
 *
 * Revision 1.1  1995/09/16  16:54:12  akool
 * Initial revision
 *
 */


#define  PUBLIC extern
#include "isdnlog.h"

static char    usage[]   = "%s: usage: %s [ -%s ] file\n";
static char    options[] = "vsi:pm:rtxd:cC:";
static char    msg1[]    = "%s: Can't open %s (errno=%d)\n";


static FILE   *logf;
static FILE   *console = (FILE *)NULL;
static CALL    call[MAXCHAN];
static int     chan;
static int     message = 0;
#ifdef DEBUG
static int     debug = 0;
#else
static int     pid = -1;
#endif
static int     xinfo = 0;
static int     fifo = -1;
static time_t  t;
static clock_t tt;
static char    st[64];
static char    infocmd[BUFSIZ];
static double  einheit = 0.12;

static int     settime = 0, connectinfo = 0, replay = 0;


static void logger(int chan)
{
  register char  *p;
  auto 	   char   s[BUFSIZ];


  strcpy(s, ctime(&call[chan].connect));

  if ((p = strchr(s, '\n')))
    *p = 0;

  fprintf(logf, "%s|%-16s|%-16s|%5d|%10d|%10d|%5d|%c|%3d|\n",
    s + 4, call[chan].num[CALLING], call[chan].num[CALLED],
    (int)(call[chan].disconnect - call[chan].connect),
    (int)call[chan].duration, (int)call[chan].connect,
    call[chan].aoce, call[chan].dialin ? 'I' : 'O',
    call[chan].cause);

  fflush(logf);

} /* logger */


#ifdef DEBUG
static void diag(int cref, int dialin, int net, int type)
{
  fprintf(stderr, "%s: %3d/%3d %s %s-> ",
    st + 4, cref, cref & 0x7f,
    dialin ? " IN" : "OUT",
    net ? "NET" : "USR");

  if ((cref > 128) && (type == SETUP_ACKNOWLEDGE))
    fprintf(stderr, " *%d* ", cref);

  switch (type) {
    case ALERTING            : fprintf(stderr, " ALERTING\n");
    	 		       break;

    case CALL_PROCEEDING     : fprintf(stderr, " CALL PROCEEDING\n");
    	 		       break;

    case SETUP               : fprintf(stderr, " SETUP\n");
    	 		       break;

    case SETUP_ACKNOWLEDGE   : fprintf(stderr, " SETUP ACKNOWLEDGE\n");
    	 		       break;

    case CONNECT             : fprintf(stderr, " CONNECT\n");
    	 		       break;

    case CONNECT_ACKNOWLEDGE : fprintf(stderr, " CONNECT ACKNOWLEDGE\n");
    	 		       break;

    case FACILITY 	     : fprintf(stderr, " FACILITY\n");
    	 		       break;

    case NOTIFY 	     : fprintf(stderr, " NOTIFY\n");
    	 		       break;

    case STATUS 	     : fprintf(stderr, " STATUS\n");
    	 		       break;

    case DISCONNECT 	     : fprintf(stderr, " DISCONNECT\n");
    	 		       break;

    case RELEASE 	     : fprintf(stderr, " RELEASE\n");
    	 		       break;

    case RELEASE_COMPLETE    : fprintf(stderr, " RELEASE COMPLETE\n");
    	 		       break;

    default 		     : fprintf(stderr, " TYPE 0x%0x\n", type);
    			       break;
  } /* switch */
} /* diag */
#endif


static void info(int chan, int reason, char *msg)
{
  auto char  s[BUFSIZ];
#if 0
  auto XINFO x;
#endif


#ifdef DEBUG
  if (!(debug & DEBUG_INFO))
    return;
#endif

  if (message & reason) {
    if (!*msg && call[chan].self)
      msg = "(Selbstanruf!)";

    if (call[chan].dialin) {

      if (*call[chan].num[CALLING])
        sprintf(s, "(0%s) ", call[chan].num[CALLING]);
      else
        *s = 0;

      fprintf((console != (FILE *)NULL) ? console : stderr,
        "%s %sCall from %s %son %s  %s\r\n",
        st + 11, chan ? " " : "",
        *call[chan].vnum[CALLING] ? call[chan].vnum[CALLING] : "UNKNOWN",
        s,
        *call[chan].vnum[CALLED] ? call[chan].vnum[CALLED] : "UNKNOWN",
        msg);
    }
    else
      fprintf((console != (FILE *)NULL) ? console : stderr,
        "%s %sCalling %s with %s  %s\r\n", st + 11,
        chan ? " " : "",
        *call[chan].vnum[CALLED] ? call[chan].vnum[CALLED] : "UNKNOWN",
        *call[chan].vnum[CALLING] ? call[chan].vnum[CALLING] : "UNKNOWN",
        msg);
  } /* if */

#if 0
  x.dialin = call[chan].dialin;
  x.channel = chan;
  strcpy(x.calling, num2nam(call[chan].num[CALLING]));
  strcpy(x.called, num2nam(call[chan].num[CALLED]));
  strcpy(x.info, facts);

  if (xinfo)
    (void)write(fifo, (char *)&x, sizeof(XINFO));
#endif
} /* info */


#ifndef DEBUG
static void waitchild(int isig)
{
  signal(SIGCHLD, SIG_DFL);

  if (pid != -1) {
    (void)kill(pid, SIGTERM);
    (void)waitpid(pid, NULL, 0);

    pid = -1;
  } /* if */
} /* waitchild */
#endif


static void tell(char *infocmd, char *arg)
{
#ifndef DEBUG
  register char *p;
  auto 	   int   fd;
#endif


#ifdef DEBUG
  if (debug & DEBUG_EXEC)
    fprintf(stderr, "\t### exec(%s,%s)\n", infocmd, arg);
#else
  if (pid != -1)
    waitchild(SIGCHLD);

  pid = fork();

  if (!pid) { /* child */
    fd = open("/dev/null", O_RDWR);
    close(0);
    dup2(fd, 0);
    close(fd);
    fd = open("/dev/console", O_RDWR);
    close(1);
    close(2);
    dup2(fd, 1);
    dup2(fd, 2);
    close(fd);

    setpgrp();

    if ((p = strchr(infocmd, '$'))) {
      *p = 0;
      (void)execl(infocmd, infocmd, arg, p + 2, NULL);
    }
    else
      (void)execl(infocmd, infocmd, arg, NULL);

    _exit(1);
  }
  else if (pid > 0) /* parent */
    signal(SIGCHLD, waitchild);
#endif
} /* tell */


static void teller(int chan)
{
  register int i, hit = 0;


  if (*infocmd) {

    if (!*call[chan].num[CALLING] && !*call[chan].num[CALLED]) {
      if (*known[0]->infoarg)
        tell(infocmd, known[0]->infoarg);
    }
    else {
      hit = 0;

      for (i = mymsns; i < knowns; i++)
        if (*known[i]->infoarg &&
            match(call[chan].num[call[chan].dialin ? CALLING : CALLED],
                  known[i]->num)) {
          tell(infocmd, known[i]->infoarg);
          hit++;
          break;
        } /* if */

      if (!hit)
        for (i = 0; i < mymsns; i++)
          if (*known[i]->infoarg &&
            match(call[chan].num[call[chan].dialin ? CALLED : CALLING],
                  known[i]->num)) {
            tell(infocmd, known[i]->infoarg);
            break;
          } /* if */
    } /* else */
  } /* if */
} /* teller */


static void termin()
{
  exit(0);
} /* termin */


static int AOC(int l, char *p)
{
  register int   i, c, x = 0;
  auto	   int	 ID = 0, OP = 0, EH = 0;
#if V2
  register char *pc;
  auto 	   char  CUR[16];
#endif


  c = strtol(p += 3, NIL, 16);              /* Ext/Spare/Profile */

  c = strtol(p += 3, NIL, 16);        	    /* Invoke Comp Type */
  c = strtol(p += 3, NIL, 16);        	    /* Invoke Comp Length */
  c = strtol(p += 3, NIL, 16);        	    /* Invoke ID Type */

  l = strtol(p += 3, NIL, 16);        	    /* Invoke ID Length */

  while (l--) {
    ID = ID << 8;
    ID += strtol(p += 3, NIL, 16);    	    /* Invoke ID Contents */
  } /* while */

  c = strtol(p += 3, NIL, 16); 	      	    /* Operation Type */

  l = strtol(p += 3, NIL, 16); 	      	    /* Operation Length */

  while (l--) {
    OP = OP << 8;
    OP += strtol(p += 3, NIL, 16);    	    /* Operation Content */
  } /* while */

  c = strtol(p += 3, NIL, 16); 	      	    /* Sequence Type */

  l = strtol(p += 3, NIL, 16);        	    /* Sequence Length */

  if (!l)      	     	  	      	    /* VSt Giessen meldet so: */
    return(AOC_130);                        /* "Free of charge" */

  if (OP == 0x22) {

#if V2
    c = strtol(p += 3, NIL, 16);      	    /* Recorded Currency Type */
    l = strtol(p += 3, NIL, 16);      	    /* Recorded Currency Length */

    c = strtol(p += 3, NIL, 16);      	    /* Currency Type */
    l = strtol(p += 3, NIL, 16);            /* Currency Length */

    pc = CUR;

    while (l--) {
      *pc++ = (char)strtol(p += 3, NIL, 16) /* Currency Contents */
    } /* while */

    c = strtol(p += 3, NIL, 16);       	    /* Amount Type */
    l = strtol(p += 3, NIL, 16);      	    /* Amount Length */

    while (l--) {
      EH = EH << 8;
      EH += strtol(p += 3, NIL, 16);        /* Amount */
    } /* while */

#else

    for (i = 0; i < 5; i++)            	    /* 5 Byte unknown */
      c = strtol(p += 3, NIL, 16); 	    /* unknown */

    l = strtol(p += 3, NIL, 16);      	    /* length */

    while (l--) {
      EH = EH << 8;
      EH += strtol(p += 3, NIL, 16);
    } /* while */

    c = strtol(p += 3, NIL, 16); 	    /* unknown */

    l = strtol(p += 3, NIL, 16);      	    /* length */

    while (l--) {
      x = x << 8;
      x += strtol(p += 3, NIL, 16);
    } /* while */

    if (x)       /* AOC-E */
      EH = EH;
    else         /* AOC-D */
      EH = -EH;
#endif

  }
  else if (OP == 0x24) {
    for (i = 0; i < 7; i++) {          	    /* 7 Byte unknown */
      c = strtol(p += 3, NIL, 16); 	    /* unknown */

      if ((i == 1) && !c)     		    /* so melden andere VSt */
        return(AOC_130);		    /* "Free of charge" */
    } /* for */

    l = strtol(p += 3, NIL, 16);      	    /* length */

    while (l--) {
      EH = EH << 8;
      EH += strtol(p += 3, NIL, 16);
    } /* while */

  } /* else */

  return(EH);
} /* AOC */


static void decode(int chan, register char *p)
{
  register char     *pd, *px;
  register int       element, l, c, aoc;
  auto	   char	     s[BUFSIZ];
  auto 	   struct tm tm;


  while (1) {

    if (!*(p + 2))
      break;

    element = strtol(p += 3, NIL, 16);

    if (element < 128) {

      l = strtol(p += 3, NIL, 16);

      switch (element) {
        case 0x08 : /* Cause */
                    c = strtol(p += 3, NIL, 16);
                    call[chan].cause = strtol(p += 3, NIL, 16) & 0x7f;

                                         /* "Normal call clearing" */
                    if ((call[chan].cause != 0x10) &&
                                         /* "non-selected user clearing" */
                        (call[chan].cause != 0x1a) &&
                                         /* "Normal, unspecified" */
                        (call[chan].cause != 0x1f))
		      info(chan, SHOWCAUSE, CauseValue[call[chan].cause]);
                    break;

        case 0x1c : /* Facility */

#ifdef DEBUG
        	    if (debug & DEBUG_DECODE) {
          	      register char *p1 = p;
		      register int   i;


                      fprintf(stderr, "%s: FACILITY:", st + 4);

                      for (i = 0; i < l; i++)
                        fprintf(stderr, " 0x%02x", (int)strtol(p1 += 3, NIL, 16));

                      fprintf(stderr, "\n");

        	    } /* if */
#endif

	            aoc = AOC(l, p);

		    if (aoc == AOC_130)
                      info(chan, SHOWAOCD, "Free of charge");
		    else if (aoc < 0) {
                      sprintf(s, "%d.EH = DM %s (%d s)",
                        -aoc,
  	                double2str(-aoc * einheit, 6, 2, DEB),
                        (int)(t - call[chan].connect));

                      info(chan, SHOWAOCD, s);

                      if (*infocmd && aocd && ((-aoc > 1) || !connectinfo))
                        tell(infocmd, aocd);
		    }
                    else
                      call[chan].aoce = aoc;

                    p += (l * 3);
                    break;

        case 0x29 : /* Date/Time */
             	    tm.tm_year  = strtol(p += 3, NIL, 16);
	     	    tm.tm_mon   = strtol(p += 3, NIL, 16) - 1;
		    tm.tm_mday  = strtol(p += 3, NIL, 16);
		    tm.tm_hour  = strtol(p += 3, NIL, 16);
		    tm.tm_min   = strtol(p += 3, NIL, 16);

		    tm.tm_sec   = 0;
		    tm.tm_wday  = tm.tm_yday = 0;
		    tm.tm_isdst = -1;

                    call[chan].time = mktime(&tm);

                    if (settime) {
  		      auto time_t     tn;
  		      auto struct tms tms;

	      	      time(&tn);

                      if (labs(tn - call[chan].time) > 61) {
       			(void)stime(&call[chan].time);

                        /* Nicht gerade sauber, sollte aber all zu
                           grosse Spruenge verhindern! */

                        if (replay)
                	  t = tt = call[chan].time;
                        else {
      			  time(&t);
      			  tt = times(&tms);
                        } /* else */

  	      		strcpy(st, ctime(&t));
  	      		st[19] = 0;

                      } /* if */
		    } /* if */

                    sprintf(s, "Time:%s", ctime(&call[chan].time));
                    if ((px = strchr(s, '\n')))
                      *px = 0;

                    info(chan, SHOWTIME, s);
                    break;

        case 0x6c : /* Calling party number */
             	    c = strtol(p += 3, NIL, 16);

                    if (c < 128) {
                      c = strtol(p += 3, NIL, 16);
                      l--;
                    } /* if */

                    pd = call[chan].num[CALLING];

                    while (--l)
                      *pd++ = strtol(p += 3, NIL, 16);

                    *pd = 0;
  		    strcpy(call[chan].vnum[CALLING],
  		           num2nam(call[chan].num[CALLING]));

              	    break;

        case 0x70 : /* Called party number */
             	    c = strtol(p += 3, NIL, 16);

                    pd = call[chan].num[CALLED];

                    while (--l)
                      *pd++ = strtol(p += 3, NIL, 16);

                    *pd = 0;
  		    strcpy(call[chan].vnum[CALLED],
  		           num2nam(call[chan].num[CALLED]));

                    if (confentry != -1)
       		      call[chan].fax = known[confentry]->flags & FAX;

	            info(chan, SHOWNUMBERS, "");

                    if (!connectinfo)
                      teller(chan);

              	    break;


        case 0x04 : /* Bearer capability */
                    switch (l) {
                      case 2 : call[chan].bearer = 0;
#ifdef DEBUG
                      	       if (debug & DEBUG_DECODE)
                                 fprintf(stderr, "%s: Bearer=DIGITAL\n",
                               	                  st + 4);
#endif
                               break;

                      case 3 : call[chan].bearer = 1;
#ifdef DEBUG
                      	       if (debug & DEBUG_DECODE)
                                 fprintf(stderr, "%s: Bearer=ANALOG\n",
                                                  st + 4);
#endif
			       break;
                    } /* switch */

        	    p += (l * 3);
             	    break;


        case 0x18 : /* Channel identification */
             	    if (strtol(p + 3, NIL, 16) == 138) {
                      call[chan].self2 = 1;
#ifdef DEBUG
                      if (debug & DEBUG_DECODE)
                        fprintf(stderr, "%s: CHANNEL=Selbstanruf\n", st + 4);
#endif
                    } /* if */
        	    p += (l * 3);
             	    break;


        case 0x1e : /* Progress indicator */
#ifdef DEBUG
                    if (debug & DEBUG_DECODE) {
                      register int a = strtol(p + 3, NIL, 16);
                      register int b = strtol(p + 6, NIL, 16);
                      register int x = 0;


                      if ((a == 130) && (b == 129))
                        x = 1;
                      else if ((a == 130) && (b == 131))
                        x = 2;
                      else if ((a == 130) && (b == 136))
		        x = 3;
                      else if ((a == 132) && (b == 130))
		        x = 4;
                      else if ((a == 132) && (b == 131))
		      	x = 5;
                      else if ((a == 133) && (b == 130))
		      	x = 6;
                      else if ((a == 138) && (b == 129))
		      	x = 7;
                      else if ((a == 138) && (b == 136))
		      	x = 8;

                      fprintf(stderr, "%s: PROGRESS=%d\n", st + 4, x);
                    } /* if */
#endif
        	    p += (l * 3);
             	    break;


        case 0x7d : /* High layer compatibility */
#ifdef DEBUG
                    if (debug & DEBUG_DECODE) {
                      fprintf(stderr, "%s: HIGH LAYER=Phone\n", st + 4);
                    } /* if */
#endif
        	    p += (l * 3);
             	    break;


        default   :
#ifdef DEBUG
        	    if (debug & DEBUG_DECODE) {
          	      register char *p1 = p;
		      register int   i;

                      fprintf(stderr, "%s: ELEMENT=0x%02x :", st + 4,
                      		      	   		      element);

                      for (i = 0; i < l; i++)
                        fprintf(stderr, " 0x%02x", strtol(p1 += 3, NIL, 16));

                      fprintf(stderr, "\n");

        	    } /* if */
#endif
        	    p += (l * 3);
              	    break;
      } /* switch */

    } /* if */
  } /* while */
} /* decode */


/* --------------------------------------------------------------------------
   call reference:


    1 ..  63 DIALIN's    - ist dabei 8. Bit gesetzt, meine Antwort an VSt
                           (cref=1 : VSt->User // cref=129 : User->VSt)

   64 .. 127 DIALOUT's   - ist dabei 8. Bit gesetzt, Antwort der VSt an mich
      	     		   (cref=64 : User->VSt // cref=192 : VSt->User)

   kommt ein SETUP ACKNOWLEDGE mit cref > 128, beginnt ein DIALOUT (!)
   _nicht_ mit der Teles-Karte

   kommt ein CALL PROCEEDING mit cref > 191, beginnt ein DIALOUT
   mit der 2. Teles-Karte

   folgt danach sofort ein SETUP, ist das ein Selbstanruf!


   DIALOUT's erhalten vom Teles-Treiber staendig eine um jeweils 1
   erhoehte call references
   War die letzte cref also < 127, und die naechste = 64, bedeutet dies
   einen Reload des Teles-Treibers!
-------------------------------------------------------------------------- */


int main(int argc, char *argv[], char *envp[])
{
  register char      *p, *ps;
  auto 	   int        verbose = 0, sync = 0, pipe = 0;
  auto 	   int        c, i = -1, cref;
  auto 	   char       s[BUFSIZ], fn2[BUFSIZ], sx[BUFSIZ];
  auto 	   FILE      *fin = (FILE *)NULL, *log1 = (FILE *)NULL, *fp;
  auto 	   struct tms tms;
  auto	   int	      type, ref, dialin, net, me = 0, go;
  auto 	   struct tm *tm;


  *infocmd = 0;


  while ((c = getopt(argc, argv, options)) != EOF)
    switch (c) {
      case 'v' : verbose++;
      	       	 break;

      case 's' : sync++;
      	       	 break;

      case 'i' : strcpy(infocmd, optarg);
      	       	 break;

      case 'c' : connectinfo++;
      	       	 break;

      case 'p' : pipe++;
      	       	 break;

      case 'm' : message += atoi(optarg);

      	       	 if (!message) {
                   message = SHOWNUMBERS;
  	      	   fprintf(stderr, "%s: WARNING: \"-m\" Option now requires numeric Argument\n", argv[0]);
                 } /* if */
      	       	 break;

      case 'r' : replay++;
      	       	 break;

      case 't' : settime++;
      	       	 break;

      case 'x' : xinfo++;
      	       	 break;

#ifdef DEBUG
      case 'd' : debug += atoi(optarg);
      	       	 break;
#endif

      case 'C' : i = atoi(optarg);
      	       	 break;

      case '?' : fprintf(stderr, usage, argv[0], argv[0], options);
	         return(1);
    } /* switch */

  if (optind == argc) {
    fprintf(stderr, usage, argv[0], argv[0], options);
    return(1);
  } /* if */

  signal(SIGTERM, termin);


  if (!strcmp(argv[optind], "-"))
    fin = stdin;


  if (i != -1) {
    sprintf(fn2, "/dev/tty%d", i);
    console = fopen(fn2, "a");
  } /* if */

  if ((fin != (FILE *)NULL) || ((fin = fopen(argv[optind], "r")) != (FILE *)NULL)) {
    if ((logf = fopen(LOGFILE, "a")) != (FILE *)NULL) {

      if (verbose) {
        if ((p = strrchr(argv[optind], '/')))
	  p++;
        else
          p = argv[optind];

        sprintf(fn2, "%s/%s", TMPDIR, p);
      } /* if */

      if (!verbose || ((log1 = fopen(fn2, "a")) != (FILE *)NULL)) {

        memset(call, 0, sizeof(call));

        readconfig(argv[0]);

      	if (!xinfo || ((fifo = open(IFIFO, O_WRONLY | O_NONBLOCK)) >= 0)) {

          if (!replay)
    	    if ((fp = fopen(PIDFILE, "w")) != (FILE *)NULL) {
	      fprintf(fp, "%d\n", (int)getpid());
  	      fclose(fp);
    	      (void)chmod(PIDFILE, 0644);
            } /* if */


          while (1) {

            if (fgets(s, BUFSIZ, fin) && (*s != '\n')) {

              if ((p = strchr(s, '\n'))) {
                *p = 0;

                while (*--p == ' ')
                  *p = 0;
              } /* if */

              if (replay) {
                t = tt = atom(s + 4);

      		ps = s + 26;
	      }
              else {
      		time(&t);
      		tt = times(&tms);

        	ps = s;
	      } /* else */

       	      tm = localtime(&t);
  	      einheit = (tm->tm_year > 95) ? 0.12 : 0.23;

  	      strcpy(st, ctime(&t));

              if (verbose) {
                if ((p = strchr(st, '\n')))
                  *p = 0;

                fprintf(log1, "%s  %s\n", st, s);

      	        if (sync)
                  fflush(log1);
              } /* if */

  	      st[19] = 0;

              if (pipe)
                fprintf(stdout, "%s\n", s);


              if (!memcmp(ps, "hex: ", 5)) {
  	        cref = strtol(ps += 11, NIL, 16);
          	type = strtol(ps += 3, NIL, 16);

                ref  = cref & 0x7f;
                dialin = ref < 64;
                net = dialin ? (cref < 128) : (cref > 127);

#ifdef DEBUG
                if (debug & DEBUG_DIAG)
                  diag(cref, dialin, net, type);
#endif

#if IN_ARBEIT
		if (type == SETUP) {
                  register char *px = ps;
                  decode(2, px);

                  if (call[2].self2) {
                    me = 1;

#ifdef DEBUG
       		    fprintf(stderr, "%s: STARTING ``SELBSTANRUF2''\n", st + 4);
#endif
		  } /* if */
		} /* if */
#endif

                if ((type == SETUP) && me && dialin) { /* Ha! Selbstanruf! */
                  if (call[0].cref > 128)
                    chan = 0;
                  else if (call[1].cref > 128)
                    chan = 1;
                  else {
#ifdef DEBUG
       		    if (debug & DEBUG_BUGS)
                      fprintf(stderr, "%s: OOPS! CAN'T FIND ``SELBSTANRUF''! - ignored!\n", st + 4);
#endif
                    continue;
                  } /* else */

                  go = call[chan].cref;
                  memset((char *)&call[chan], 0, sizeof(CALL));
                  call[chan].aoce = -1;
                  call[chan].ocref = go;

                  if ((cref > 128) && (type == SETUP_ACKNOWLEDGE))
                    call[chan].cref = cref;
                  else {
                    call[chan].cref = ref;
	            call[chan].self = 1;
                  } /* else */

                  call[chan].net = 1;
	          call[chan].connect = t;
	          call[chan].duration = tt;
                  call[chan].state = SETUP;
                  call[chan].dialin = 0; /* Selbstanrufe immer als DIALOUT werten! */

                  decode(chan, ps);

#ifdef DEBUG
       		  if (debug & DEBUG_BUGS)
                    fprintf(stderr, "%s: > RESTART CHAN#%d %s %s->\n",
                      st + 4, chan,
                      call[chan].dialin ? " IN" : "OUT",
                      call[chan].net ? "NET" : "USR");
#endif

                  me = 0;
                  continue;
                } /* if */

                me = 0;


                /* SETUP ACKNOWLEDGE mit cref > 128 ist Sonderfall!
                   Und zwar DIALOUT - nicht mit Teles-Karte! */

                if (cref > 128) {
                  if (type == SETUP_ACKNOWLEDGE) {
                    chan = -1;
                    me = 1;
                  }
                  else if (call[0].cref == cref)
                    chan = 0;
                  else if (call[1].cref == cref)
                    chan = 1;
                  else {
                    if (call[0].ocref == cref)
                      chan = 0;
                    else if (call[1].ocref == cref)
                      chan = 1;
                    else {
                      if (call[0].cref == ref)
                        chan = 0;
                      else if (call[1].cref == ref)
                        chan = 1;
                      else
                        chan = -1;
                    } /* else */

#ifdef DEBUG2
                    if (call[chan].ocref == cref)
       		      if (debug & DEBUG_BUGS)
                        fprintf(stderr, "%s: OOPS! MATCH using ocref!\n", st + 4);
#endif
                  } /* else */
                }
                else {
                  if (call[0].cref == ref)
                    chan = 0;
                  else if (call[1].cref == ref)
                    chan = 1;
                  else
                    chan = -1;
                } /* else */

                if (chan == -1) {
                  if ((type != SETUP) && (type != SETUP_ACKNOWLEDGE)) {
                    if (type == CALL_PROCEEDING) {
#ifdef DEBUG
                      fprintf(stderr, "%s: START Teles2!\n", st + 4);
#endif
                      goto newchan;
                    } /* if */

#ifdef DEBUG
                    if (type != RELEASE_COMPLETE)
       		      if (debug & DEBUG_BUGS)
                        fprintf(stderr, "%s: OOPS! UNKNOWN cref %d - ignored ([0].c=%d [1].c=%d [0].o=%d [1].o=%d)\n", st + 4, cref, call[0].cref, call[1].cref, call[0].ocref, call[1].ocref);
#endif
                    continue;
                  } /* if */
                }
                else {
                  if ((type == SETUP) && (call[chan].state == SETUP)) {
                    if (!call[chan].self) {
#ifdef DEBUG
       		      if (debug & DEBUG_BUGS)
                        fprintf(stderr, "%s: OOPS! SETUP on already known cref %d\n", st + 4, cref);
#endif
                      continue; /* chan = -1; FIXME */
                    } /* if */
                  }
                  else {
                    if (net != call[chan].net)
                      call[chan].dialog = 1;

                    decode(chan, ps);
                  } /* else */
                } /* else */


                switch (type) {

     	          case SETUP               :
                  case SETUP_ACKNOWLEDGE   :

newchan:            if (chan == -1) {
                      if (!call[0].state)
                        chan = 0;
                      else if (!call[1].state)
                        chan = 1;
                      else {
#ifdef DEBUG
       		        if (debug & DEBUG_BUGS)
                          fprintf(stderr, "%s: OOPS! REQUEST FOR 3. CHANNEL - ignored\n", st + 4);
#endif
                        continue;
                      } /* else */

                      memset((char *)&call[chan], 0, sizeof(CALL));
                      call[chan].aoce = -1;

                      if ((cref > 128) && (type == SETUP_ACKNOWLEDGE)) {
	      	        call[chan].cref = cref;
            	        call[chan].dialin = 0;
                      }
                      else {
	      	        call[chan].cref = ref;
            	        call[chan].dialin = dialin;
                      } /* else */

            	      call[chan].net = net;
            	      call[chan].connect = t;
            	      call[chan].duration = tt;
                      call[chan].state = me ? SETUP_ACKNOWLEDGE : SETUP;

		      decode(chan, ps);

#ifdef DEBUG
       		      if (debug & DEBUG_BUGS)
            	        fprintf(stderr, "%s: > START CHAN#%d %s %s->\n",
                          st + 4, chan,
                          call[chan].dialin ? " IN" : "OUT",
                          call[chan].net ? "NET" : "USR");
#endif
                    } /* if */
                    break;


                  case CONNECT             :
                  case CONNECT_ACKNOWLEDGE :

                    if (net || ((call[chan].cref == 129) && !net)) {

#ifdef DEBUG
                      if (!net)
       		        if (debug & DEBUG_BUGS)
       		          fprintf(stderr, "%s: OOPS! CONNECT wg. self!\n", st + 4);

       		      if (debug & DEBUG_BUGS)
                        fprintf(stderr, "%s: > CONNECT%s CHAN#%d\n", st + 4, (type == CONNECT_ACKNOWLEDGE) ? " (ACKNOWLEDGE)" : "", chan);
#endif

                      call[chan].state   = CONNECT;

                      call[chan].connect = t;
                      call[chan].duration = tt;

                      info(chan, SHOWCONNECT, "CONNECTED");

                      if (connectinfo)
                        teller(chan);
                    } /* if */
                    break;


                  case DISCONNECT          :

  	            call[chan].disconnect = t;

		    if (replay)
                      call[chan].duration = (tt - call[chan].duration) * 100;
		    else
                      call[chan].duration = tt - call[chan].duration;

                    if (call[chan].state == CONNECT)
                      call[chan].state = DISCONNECT;

                    break;


  	          case RELEASE             :
  	          case RELEASE_COMPLETE    :


   	            if (call[chan].dialin) {
                      go = (net && (type == RELEASE_COMPLETE)) ||
                           (!net && (type == RELEASE));

                      if (!go && net && (type == RELEASE)) {
                        call[chan].release++;

                        if (call[chan].bearer && (call[chan].release == 2)) {
                          go = 1;
#ifdef DEBUG
       		          if (debug & DEBUG_BUGS)
       		            fprintf(stderr, "%s: OOPS! RELEASE wg. doppeltem RELEASE!!\n", st + 4);
#endif
                        } /* if */
                      } /* if */

                      if (!go) {
                        go = (net && (type == RELEASE) && !call[chan].dialog &&
                              (call[chan].state == DISCONNECT));
#ifdef DEBUG
                        if (go)
       		          if (debug & DEBUG_BUGS)
                            fprintf(stderr, "%s: OOPS! RELEASE wg. NON-DIALOG!!\n", st + 4);
#endif
                      } /* if */

                      if (!go) {
                        go = (net && (type == RELEASE) &&
                              !call[chan].dialog &&
                              (call[chan].bearer == 1) &&
                              call[chan].fax);
#ifdef DEBUG
                        if (go)
       		          if (debug & DEBUG_BUGS)
                            fprintf(stderr, "%s: OOPS! RELEASE wg. FAX\n", st + 4);
#endif
                      } /* if */
   	            }
                    else
                      go = 1;

                    if (go && call[chan].state) {
  	              if (!call[chan].disconnect) {
  	                call[chan].disconnect = t;

			if (replay)
                          call[chan].duration = (tt - call[chan].duration) * 100;
			else
              	          call[chan].duration = tt - call[chan].duration;
                      } /* if */

                      if (!call[chan].dialin && (call[chan].aoce == -1)) {
                        call[chan].duration = 0;
  	                call[chan].disconnect = call[chan].connect;

#ifdef DEBUG
       		        if (debug & DEBUG_BUGS)
                          fprintf(stderr, "%s: OOPS! DURATION=0\n", st + 4);
#endif
                      } /* if */

#ifdef DEBUG
       		      if (debug & DEBUG_BUGS) {
                        strcpy(sx, ctime(&call[chan].connect));
      	  	        sx[19] = 0;

                        fprintf(stderr, "%s: > LOG CHAN#%d(%s : DIAL%s : %s -> %s : %d s (%d s) : %d EH):%s\n\n",
                          st + 4, chan,
      	    	          sx + 4,
      	    	          call[chan].dialin ? "IN" : "OUT",
      	    	          call[chan].num[CALLING],
      	    	          call[chan].num[CALLED],
      	    	          (int)(call[chan].disconnect - call[chan].connect),
                          (int)call[chan].duration,
      	    	          call[chan].aoce,
      	    	          CauseValue[call[chan].cause]);
       		      } /* if */
#endif

                      logger(chan);

                      if (call[chan].dialin)
                        sprintf(sx, "HANGUP (%d s)\n",
                          (int)(call[chan].disconnect - call[chan].connect));
                      else {
                        if (call[chan].aoce > 0)
                          sprintf(sx, "HANGUP (%d EH = DM %s = %d s)\n",
  	                    call[chan].aoce,
  	                    double2str(call[chan].aoce * einheit, 6, 2, DEB),
                            (int)(call[chan].disconnect - call[chan].connect));
                        else
                          sprintf(sx, "HANGUP - %s\n", CauseValue[call[chan].cause]);
                      } /* else */

                      info(chan, SHOWHANGUP, sx);

                      if (*infocmd && hangup)
                        tell(infocmd, hangup);

      	  	      call[chan].state = 0;
      	  	      call[chan].cref = 0;
                    } /* if */

     	            break;
                } /* switch */
              } /* if */
	    }
            else if (replay)
              break;
          } /* while */

          if (xinfo)
            close(fifo);
	}
        else {
          fprintf(stderr, msg1, argv[0], IFIFO, errno);
          return(1);
        } /* else */

        if (verbose)
          fclose(log1);

      }
      else {
        fprintf(stderr, msg1, argv[0], fn2, errno);
        return(1);
      } /* else */

      fclose(logf);
    }
    else {
      fprintf(stderr, msg1, argv[0], LOGFILE, errno);
      return(1);
    } /* else */

    fclose(fin);
  }
  else {
    fprintf(stderr, msg1, argv[0], argv[optind], errno);
    return(1);
  } /* else */

  if (console != (FILE *)NULL)
    fclose(console);

  return(0);
} /* main */
