#!/bin/sh

ask () {
	yesno=x
	while true; do
		echo -n "${1}? [Y/n] "
		read yesno
		case "$yesno" in
			"")
			yesno=Y
			break
			;;
			[yY])
			yesno=Y
			break
			;;
			[nN])
			yesno=N
			break
			;;
		esac
	done
	return `[ $yesno = "Y" ]`
}

cfile=isdn/isdnconfig
echo "" > $cfile
echo "# Created by isdn configure-script, DO NOT CHANGE." >> $cfile
echo "" >> $cfile
SPPP=N
if ask "Support for Sync-PPP over ISDN"; then
	echo "PPPCFG1=-DCONFIG_ISDN_PPP" >> $cfile
	SPPP=Y
	if ask "Support for VJ-Compression with Sync-PPP"; then
		echo "PPPCFG2=-DCONFIG_ISDN_PPP_VJ" >> $cfile
	else
		echo "PPPCFG2=" >> $cfile
	fi
	echo "PPPOBJ=isdn_ppp.o" >> $cfile
else
	echo "PPPCFG1=" >> $cfile
	echo "PPPCFG2=" >> $cfile
	echo "PPPOBJ=" >> $cfile
fi
if [ $SPPP = Y ]; then
	if [ "`id | grep uid=0`" = "" ]; then
		echo "In order to install possible Kernel-Includes for new PPP"
		echo "you MUST run this as root."
		rm include/isdnconfig.h
		exit 1
	fi
	cd patches.ppp212.to.220
	kinstall.sh
	cd ..
fi

