#include <stdio.h>
#include <string.h>
#include <sys/time.h>

#include "atmd.h"

#include "sscop.h"


static SSCOP_LINK l1,l2;
static QUEUE q1,q2;


struct timeval now;


static void dump_queue(QUEUE *queue)
{
   BUFFER *walk;

   for (walk = queue->first; walk; walk = walk->next)
     printf("  [%d]\n",walk->length);
}


static void test_cpcs_send(SSCOP_LINK *link,void *user,void *buffer,int length)
{
    BUFFER *buf;

    buf = buffer_create(length,0);
    memcpy(buf->data,buffer,length);
    queue_put((QUEUE *) user,buf);
}


static void test_estab_ind(SSCOP_LINK *link,void *user,void *uu_data,
  int uu_length)
{
    fprintf(stderr,"%s: estab_ind\n",link->id);
    fprintf(stderr,"%s: calling sscop_estab_resp\n",link->id);
    sscop_estab_resp(link,NULL,0,0);
}


static void test_estab_conf(SSCOP_LINK *link,void *user,void *uu_data,
  int uu_length)
{
    BUFFER *x;

    fprintf(stderr,"%s: estab_conf\n",link->id);
    fprintf(stderr,"%s: calling sscop_send\n",link->id);
    sscop_send(link,"testing",7);
    sscop_send(link,"hello",5);
dump_queue(&q2);
x = queue_get(&q2);
buffer_discard(x);
fprintf(stderr,"snatched 0x%lx\n",(unsigned long) x);
    sscop_send(link,"world",5);
}


static void test_rel_ind(SSCOP_LINK *link,void *user_data,void *uu_data,
  int uu_length,int user)
{
    fprintf(stderr,"%s: rel_ind\n",link->id);
}


static void test_rel_conf(SSCOP_LINK *link,void *user)
{
    fprintf(stderr,"%s: rel_conf\n",link->id);
}


static void test_restart(SSCOP_LINK *link,void *user,void *uu_data,
  int uu_length,int ind)
{
    fprintf(stderr,"%s: restart (ind = %d)\n",link->id,ind);
}


static void test_res_ind(SSCOP_LINK *link,void *user,void *uu_data,
  int uu_length)
{
    fprintf(stderr,"%s: res_ind\n",link->id);
}


static void test_res_conf(SSCOP_LINK *link,void *user)
{
    fprintf(stderr,"%s: res_conf\n",link->id);
}


static void test_rec_ind(SSCOP_LINK *link,void *user)
{
    fprintf(stderr,"%s: rec_ind\n",link->id);
}


static void test_data_ind(SSCOP_LINK *link,void *user,void *data,int length,
  int sn)
{
  static int x = 0;
    fprintf(stderr,"%s: data_ind \"",link->id);
    while (length--) fputc(*((char *) data)++,stderr);
    fprintf(stderr,"\"\n");
    if (++x < 3) return;
    fprintf(stderr,"%s: calling sscop_rel_req\n",link->id);
    sscop_rel_req(link,NULL,0);
}


static int test_maa_error(SSCOP_LINK *link,void *user,char code,int count)
{
    fprintf(stderr,"%s: maa_error (%c,%d)\n",link->id,code,count);
    return 1;
}


static SSCOP_USER_OPS ops = {
    test_estab_ind,
    test_estab_conf,
    test_rel_ind,
    test_rel_conf,
    test_restart,
    test_res_ind,
    test_res_conf,
    test_rec_ind,
    test_data_ind,
    NULL,
    NULL,
    NULL,
    NULL,
    test_maa_error,
    test_cpcs_send
};


void main(void)
{
    set_verbosity(VERB_DEBUG);
    l1.id = "ONE";
    l2.id = "TWO";
    queue_init(&q1);
    queue_init(&q2);
    start_sscop(&l1,&ops,&q2);
    start_sscop(&l2,&ops,&q1);
    fprintf(stderr,"%s: calling sscop_estab_req\n",l1.id);
    sscop_estab_req(&l1,NULL,0,0);
    while (queue_peek(&q1) || queue_peek(&q2)) {
	BUFFER *buf;
	SSCOP_LINK *dest;

	if ((buf = queue_get(&q1))) dest = &l1;
	else {
	    buf = queue_get(&q2);
	    dest = &l2;
	}
	fprintf(stderr,"---------- %s ----------\n",dest->id);
	sscop_pdu(dest,buf->data,buf->length);
	buffer_discard(buf);
    }
    stop_sscop(&l1);
    stop_sscop(&l2);
}
