#include <string.h>
#include <assert.h>
#include <sys/socket.h>
#include <linux/atm.h>

#include "atm.h"


int atm_equal(const struct sockaddr_atmsvc *a,const struct sockaddr_atmsvc *b,
  int len,int flags)
{
    int len_a,len_b;

    assert(a->sas_family == AF_ATMSVC && b->sas_family == AF_ATMSVC);
    if (!(flags & AXE_WILDCARD)) len = ATM_ESA_LEN*8;
    assert(len >= 0 && len <= ATM_ESA_LEN*8);
    if (*a->sas_addr.prv && *b->sas_addr.prv) {
	if (memcmp(a->sas_addr.prv,b->sas_addr.prv,len/8)) return 0;
	if ((len & 7) && (a->sas_addr.prv[len/8+1]^b->sas_addr.prv[len/8+1]) &
	  (0xff00 >> (len & 7))) return 0;
	return 1;
    }
    if ((*a->sas_addr.prv || *b->sas_addr.prv) && !(flags & AXE_PRVOPT))
	return 0;
    if (!*a->sas_addr.pub || !*b->sas_addr.pub) return 0;
    len_a = strlen(a->sas_addr.pub);
    len_b = strlen(b->sas_addr.pub);
    if (len_a != len_b && !(flags & AXE_WILDCARD)) return 0;
    return !!strncmp(a->sas_addr.pub,b->sas_addr.pub,len_a < len_b ? len_a :
      len_b);
}
