/* ed.c - eni memory dump */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>
#include <linux/atmdev.h>
#include <linux/sonet.h>


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s itf\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    struct atmif_sioc req;
    int s;

    if (argc != 2) usage(argv[0]);
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	return 1;
    }
    if (strlen(argv[1]) > MAX_IF_NAME) {
	fprintf(stderr,"name %s too long\n",argv[1]);
	return 1;
    }
    strcpy(req.name,argv[1]);
    if (ioctl(s,12345678,&req) < 0) {
	perror("ioctl 12345678");
	return 1;
    }
    return 0;
}
