#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/atm.h>
#include <linux/atmclip.h>


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -0 ] itf vpi vci [ pcr ]\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    struct sockaddr_atmpvc addr;
    const char *name;
    int s,null;

    name = argv[0];
    null = 0;
    if (argc > 1 && *argv[1] == '-')
	if (strcmp(argv[1],"-0")) usage(name);
	else {
	    null = 1;
	    argc--;
	    argv++;
	}
    if (argc != 4 && argc != 5) usage(name);
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_CLIP))
      < 0) {
	perror("socket");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    addr.sap_family = AF_ATMPVC;
    addr.sap_addr.itf = atoi(argv[1]);
    addr.sap_addr.vpi = atoi(argv[2]);
    addr.sap_addr.vci = atoi(argv[3]);
    if (argc != 5) addr.sap_txtp.class = ATM_UBR;
    else {
	addr.sap_txtp.class = ATM_CBR;
	addr.sap_txtp.min_pcr = atoi(argv[4]);
    }
    addr.sap_rxtp.class = ATM_UBR;
    if (bind(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    if (null)
	if (ioctl(s,CLIP_NULENCAP,0) < 0) {
	    perror("ioctl CLIP_NULENCAP");
	    return 1;
	}
    return 0;
}
