/*
 *  Copyright 2000-2002 by Hans Reiser, licensing governed by reiserfs/README  
 */

#include <linux/config.h>
#include <linux/sched.h>
#include <linux/locks.h>
#include <linux/reiserfs_fs.h>
#include <linux/smp_lock.h>
#include <linux/kernel_stat.h>

/*
 * reiserfs_bread() reads a specified block and returns the buffer that contains
 * it. It returns NULL if the block was unreadable.
 */
/* It first tries to find the block in cache, and if it cannot do so
   then it creates a new buffer and schedules I/O to read the
   block. */
/* The function is NOT SCHEDULE-SAFE! */
struct buffer_head  * reiserfs_bread (struct super_block *super, int n_block, int n_size) 
{
    struct buffer_head  *result;
    PROC_EXP( unsigned int ctx_switches = nr_context_switches(); );

    result = bread (super -> s_dev, n_block, n_size);
    PROC_INFO_INC( super, breads );
    PROC_EXP( if( nr_context_switches() != ctx_switches ) 
	      PROC_INFO_INC( super, bread_miss ) );
    return result;
}

struct buffer_head  * journal_bread (struct super_block *s, int block)
{
	return bread (SB_JOURNAL_DEV(s), block, s->s_blocksize );
}

struct buffer_head  * journal_getblk (struct super_block *s, int block)
{
	return getblk (SB_JOURNAL_DEV(s), block, s->s_blocksize );
}

struct buffer_head  * journal_get_hash_table (struct super_block *s, int block)
{
  return get_hash_table (SB_JOURNAL_DEV(s), block, s->s_blocksize );
}
