/*******************************************************************************

  Copyright(c) 2002 - 2005 Promise Technology, Inc. All rights reserved.
  
  cam_isr.c - contains declaration for global variables

  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Promise Technology, Inc.
  <support@promise.com.tw>	[TAIWAN]
  <support@promise.com>		[U.S.A]
  <support-china@promise.com>	[CHINA]

*******************************************************************************/
#include "cam_con.h"
#include "cam_def.h"
#include "cam_imp.h"
#include "cam_macr.h"
#include "cam_gb.h"
#include "cam_exp.h"

/*
When the ISR of channel driver is called by OS, it should call CAM_ISR immediately.
Channel driver will tell CAM the interrupt may caused by which adapters. If several adapters 
share the same IRQ, channel driver will set mapped bits of IRQHandle to 1.
CAM will determine if its controllers generated a interrupt. CAM will return FALSE as soon as
possible if this interrupt is not generated by its controllers.
*/
U32 CAM_ISR(U32 IRQHandle)		/* bit#1	The interrupt may caused by adapter# */
{
	U8 bAdapterNumber;
	U8 SEQID;
	U8 returnValue=FALSE;	
	U32 INTStatus;

	U8	SEQCntCtrl;
	PSEQ_INFO	pCurSEQ_INFO;

	U8 ModuleType;

	U8	i;
	U8	errorFlag=FALSE;
	U8	IntReason=0;
	
	U8	PlugData;
	U8	MaskFlags;
	U8 	RestartModule=FALSE;

	for (bAdapterNumber=0;bAdapterNumber<MAX_ADAPTER_NUM;bAdapterNumber++){
		if (!((IRQHandle >> bAdapterNumber)&0x01))
			continue;
		/* channel dirver set the interrupt may caused by adapter# */
		
		/* read Sequence Interrupt Status register, if no sequence INT, return ASAP. */
#ifndef NETWARE
		ReadPortUlong(HostBaseAddr[bAdapterNumber], SEQINT_REGISTER_OFFSET, INTStatus);			
#else
		ReadPortUchar(HostBaseAddr[bAdapterNumber], SEQINT_REGISTER_OFFSET+1, i);
		INTStatus = (U32)i << 8;
#endif
		if (!(INTStatus & 0xFFFF))		/* check SEQ#0~F INT  */
			continue;	/* no SEQ INT */
				
		returnValue = TRUE;

		for (SEQID=START_SEQ_ID;SEQID<MAX_SEQ_ID;SEQID++) {
			if (!((INTStatus >> SEQID) & 0x01))
				continue;
				
			/* SEQ# INT */
			pCurSEQ_INFO = &(gSEQ_INFO[bAdapterNumber][SEQID]);
			
			/* if is a invalid seqID interrupt. */
			if (pCurSEQ_INFO->SEQID2PacketHead == ((PVOID)U32NULL) )
				continue;
						
			ModuleType= (U8)pCurSEQ_INFO->Owner;

			/* read Sequence Counter Control Register # */
			ReadPortUchar(HostBaseAddr[bAdapterNumber], SEQID*4, SEQCntCtrl);
			SEQCntCtrl &= 0x1F;
					
			{	/* ATA Modules */

				PCAM_ATA_PACKET ultmpATAPacketAddress;
				PCAM_ATA_PACKET ultmpATAPacketAddress_next;
				PATA_TASK pATATask;
				U8 bChannelNumber;
				U8    SATAerrorFlag=FALSE;
				U8	RestartFlag=FALSE;

				bChannelNumber = bAdapterNumber*MAX_ATA_CHNL+ModuleType;

				errorFlag = FALSE;
						
				/* remove ata timeout timer */
				camTimer(0,(void *)ATA_Timeout_TimerID[bChannelNumber]);	
				ATA_Timeout_TimerID[bChannelNumber]=ZERO_NULL;
						
				ultmpATAPacketAddress = (PCAM_ATA_PACKET)pCurSEQ_INFO->SEQID2PacketHead;
				ATAModuleSEQID[bChannelNumber] = U8NULL;
				
				if ((U32)ultmpATAPacketAddress != U32NULL){
					/* check SATA Error Register */
					/* when SATA error , can't know what packet is error of a chain-packets, so set first packet error and try to retry it, others abort.*/
					if ( gChnlConfig[bChannelNumber].ChnlType == CHNL_SATA )
					{	
						U32 ldata;
						/* if the regidter offset large than 0x80, when use MMIO, must use this method */
						#ifdef	_MMIO_
						ReadIndexUlong( ATABaseAddr[bAdapterNumber*MAX_ATA_CHNL]  + 0x100 * (bChannelNumber%MAX_ATA_CHNL) , iNDEXIDESATAError, ldata );
						WriteIndexUlong( ATABaseAddr[bAdapterNumber*MAX_ATA_CHNL]  + 0x100 * (bChannelNumber%MAX_ATA_CHNL) , iNDEXIDESATAError, ldata );
						#else
						ReadIndexUlong( ATABaseAddr[bChannelNumber], iNDEXIDESATAError, ldata );
						WriteIndexUlong( ATABaseAddr[bChannelNumber], iNDEXIDESATAError, ldata );
						#endif				
						if ( ldata & (R_ERR|CRC_ERR|DISPARITY_ERR|Decode_10B_TO_8B_ERR|DATA_ERR) ) { /* 0x00380100 */
							SATAerrorFlag = TRUE;
						}
					}
				}
				
				/* if no error(SATA error and packet error) and no data or ide register status need to transfer(PIO, ATA_STATUS_RETURN or ATAPI ), try to execute other packets.*/
				if (!(SEQCntCtrl || (SATAerrorFlag == TRUE))) {
					
					if (pCurSEQ_INFO->GO==TRUE)
						RestartFlag = TRUE;
					
					if (RestartFlag == TRUE) {
						ATAModuleBusy[bChannelNumber]=FALSE;
						RestartModule = TRUE;
						
						if ( (ATAModuleNeedPush[bChannelNumber]==TRUE) && (ATAModuleBusy[bChannelNumber]==FALSE) ){
							/* start ata module */
							StartATAOperation(bChannelNumber);
						}
					}
				}
				
				ultmpATAPacketAddress = (PCAM_ATA_PACKET)pCurSEQ_INFO->SEQID2PacketHead;
				pCurSEQ_INFO->SEQID2PacketHead=(PVOID)U32NULL;
				pCurSEQ_INFO->SEQID2PacketTail=(PVOID)U32NULL;
								
				while ((U32)ultmpATAPacketAddress != U32NULL){						

					pATATask=(PATA_TASK)ultmpATAPacketAddress->PacketHead.PTA;
					pATATask->ATAStatus= 0;		/* default no error */
							
					if ( (SEQCntCtrl) || (SATAerrorFlag == TRUE) )	/* not success done all seq's packets or SATAerrorFlag */
					{
						/* check is error packet */
						if ( (pCurSEQ_INFO->PACCNT == SEQCntCtrl) || (SATAerrorFlag == TRUE) )
						{
							errorFlag = TRUE;								

							/* if swap box nop command, it will return error at all time, and it will not queue with others packets when execute,
									, needn't abort others packet at waiting queue */
							if (!(pATATask->ATACmdFlag & SWAPBOX_CMD)){
								/* abort packets queue at the rear of this packet and and wait queue packets. */
								Abort_All_Undone_ATAPackets(bChannelNumber,(PCAM_ATA_PACKET)ultmpATAPacketAddress->PacketHead.NPA);
								ultmpATAPacketAddress->PacketHead.NPA=(PVOID)U32NULL;
							}
							else /* SWAPBOX_CMD */
								goto CommandCompleted;
															
							/* get ATA Global control & Status Register */
							ReadPortUchar(ATABaseAddr[bChannelNumber], (ATA_STATUS_REGISTER_OFFSET+2), pATATask->ATAStatus);
							
							/* soft reset ATA Module after getting status. */
							ATASoftResetModule(bChannelNumber);

							pATATask->ATAStatus &= ATAERR_HWERROR;
							pATATask->ATAStatus |= ATA_ERROR;						

							if (SATAerrorFlag == TRUE) {
								pATATask->ATAStatus |= ATAERR_DRV;
								pATATask->Cmd.ATACmd.bStatus = IDE_STATUS_DF+IDE_STATUS_IDLE;	
								goto CommandCompleted;						
							}
							
							/* read 3f6 */
							for ( i = 0; i < 100; i++ ) {
								if (!(ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDEAlternateStatus) & IDE_STATUS_BUSY))
									break; /* wait a while for ATAPI device */
							}
							GetStatus(ATABaseAddr[pATATask->bCh], pATATask->Cmd.ATACmd.bStatus);
							
							if (pATATask->Cmd.ATACmd.bStatus & IDE_STATUS_BUSY){
								pATATask->ATAStatus &= ~ATAERR_DRV;
								pATATask->ATAStatus |= ATA_TIMEOUT;
							}
							else{				
								pATATask->ATAStatus |= ATAERR_DRV;
								/* set disk status */
								if (pATATask->ATACmdFlag & ATA_DEVICE)									
									ATAErrorStatus(pATATask);
								else if (pATATask->ATACmdFlag & SWAPBOX_CMD)
									ATAErrorStatus(pATATask);
								else { 	/* ATAPI device */
									if ( pATATask->ATAStatus & ATAERR_OVERRUN )
									{	/* that is not a device error */
										pATATask->ATAStatus = 0;
										goto CommandCompleted;
									}
									if (!(pATATask->ATACmdFlag & INTERNAL_SENSE)){
										/* get ATAPI error , if INTERNAL_SENSE error, ingore it.*/
										ATAPIErrorStatus(pATATask);
										
										/* must have sense buffer so can do internel sense command */
										if ((pATATask->SenseInfoLength > 1)){
											/* If ATAPI packet command error, than send a internel "REQUEST SENSE Command" 
											     to get the sense datas. 	*/
											pATATask->ATACmdFlag = INTERNAL_SENSE;
											IntReason = INT_WAITCMD;
										}
									}
									else {
										pATATask->ATACmdFlag &= ~INTERNAL_SENSE;
										ATAPIErrorStatus(pATATask); /* even request sense is failed. */
 										ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDEStatus); /*clear possible device INT */
 									}											
								}
							}
						}
						else
						{
							pCurSEQ_INFO->PACCNT--;
						}
					}
					else { /* success done all seq's packets */
						pATATask->ATAStatus= 0;
						
						/* get INT reason */
						if (!(pATATask->ATACmdFlag & ATA_DEVICE))
							IntReason = ReadIndexUchar(ATABaseAddr[bChannelNumber], iNDEXIDESectorCount)& 0x07;
							
						/* If the packet's ATACmdFlag be set with ATA_STATUS_RETURN , it only can queued at the tail of execute packets queue(or only itself at the queue),
		     				   so when error or success completed, will return ata registers statses.*/
						if (pATATask->ATACmdFlag & ATA_STATUS_RETURN) /* need read it's ata registers statses when command success completed */
							ATAErrorStatus(pATATask);
					}
CommandCompleted:					
				
					
					if (pATATask->ATACmdFlag & INTERNAL_SENSE) {
						switch (IntReason) {
							case INT_WAITCMD:
								SubmitInternelSense(pATATask);
								break;
						
							case INT_DATAIN:
								/* read sense data */
								WaitForDrq(ATABaseAddr[pATATask->bCh]);
								ReadBuffer(ATABaseAddr[pATATask->bCh],(PU16)pATATask->SenseInfoBuffer,((U32)pATATask->SenseInfoLength >>1) );									
								/* wait complete INT at here and clear it */
								pATATask->ATACmdFlag &= ~INTERNAL_SENSE;
								pATATask->ATAStatus = ATA_ERROR + ATAERR_DRV;
								for ( i = 0; i < 100; i ++ ) {
									if( ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDECICR+3) & 0x08 )
										break;
								}
								ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDEStatus); /*clear device INT */
								break;
						}
					}
					else if ( pATATask->ATACmdFlag & PIO_XFER )
					{
						U32	DataTransferLength = (pATATask->DataTransferLength >> 1);
						if (!(pATATask->ATACmdFlag & ATA_DEVICE) ) {
							DataTransferLength = (U32)ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDECylinderLow)
							                    | ((U32)ReadIndexUchar(ATABaseAddr[pATATask->bCh], iNDEXIDECylinderHigh) << 8);
							DataTransferLength >>= 1;           
						}
						
						if ( pATATask->ATACmdFlag & camDATA_IN ){
  							ReadBuffer(ATABaseAddr[pATATask->bCh],(PU16)pATATask->DataBuffer, DataTransferLength );
						}
						else {
							WriteBuffer(ATABaseAddr[pATATask->bCh],(PU16)pATATask->DataBuffer, DataTransferLength );
    						}
					}										
				
					if ( !(pATATask->ATACmdFlag & INTERNAL_SENSE) )
						pATATask->callback(pATATask);		

					/* free sg resource */
					CAMFreeSG(bAdapterNumber, ATA_PAC, (PVOID)ultmpATAPacketAddress->PacketHead.PSG);	
							
					ultmpATAPacketAddress_next = (PCAM_ATA_PACKET)ultmpATAPacketAddress->PacketHead.NPA;
					/* free packet resource. */
					CAMFreePacket(bAdapterNumber, ATA_PAC, (PVOID)ultmpATAPacketAddress);
					
					if (errorFlag==TRUE)
						break;
						
					/* next packet */
					ultmpATAPacketAddress = ultmpATAPacketAddress_next;
					
				}/* end of while ((U32)ultmpATAPacketAddress != U32NULL)*/

				if (RestartModule==FALSE) 
					ATAModuleBusy[bChannelNumber]=FALSE;

				CAMFreeSEQID(bAdapterNumber,SEQID);	

				/* must check module is need to push, By it maybe pushed when no SQEID. */
				for (i=(bAdapterNumber*MAX_ATA_CHNL);i<((bAdapterNumber+1)*MAX_ATA_CHNL);i++) {
					if ( (ATAModuleNeedPush[i]==TRUE) && (ATAModuleBusy[i]==FALSE) ){
						/* start ata module */
						StartATAOperation(i);
						break;
					}
				}
			} /* end of ATA module */	
		}/* end of SEQID */
	}/* end of bAdapterNumber */

	if (returnValue == TRUE)
		return TRUE;
		
	for (bAdapterNumber=0;bAdapterNumber<MAX_ADAPTER_NUM;bAdapterNumber++) {
		if (!((IRQHandle >> bAdapterNumber)&0x01) )
			continue;
		
		/* interrupt caused by adapter# */
		/* check is SATA plug/unplug interrupt */
		/* read SATA plug control and status register */
		ReadPortUchar(HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG, PlugData);
		ReadPortUchar(HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG+2, MaskFlags);
		PlugData &= ~MaskFlags;
		if (!PlugData)
			continue;
						
		/* clear plug/unplug flags */
		WritePortUchar(HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG, PlugData);
		
		/* check unplug flag */
		for ( i=0; i < MAX_ATA_CHNL; i++){
			if ( (PlugData & 0x01) && (gChnlConfig[bAdapterNumber*MAX_ATA_CHNL+i].ChnlType == CHNL_SATA))
			{
				returnValue = TRUE;
				gDrvConfig[bAdapterNumber*MAX_ATA_CHNL+i][0].DevFlag = DEV_NOTFOUND;
				camCheckDriveStatus((U8) (bAdapterNumber*MAX_ATA_CHNL+i), 0, NO_DRIVE);
			}
			PlugData >>= 1;
		}
				
		/* check plug flag */
		for ( i=0; i < MAX_ATA_CHNL; i++){
			if ( (PlugData & 0x01) && (gChnlConfig[bAdapterNumber*MAX_ATA_CHNL+i].ChnlType == CHNL_SATA))
			{
				U32 ldata;
				U8 	bData;
				U8	j;
				
				returnValue = TRUE;

				/* mask plug/unplug INT */
				ReadPortUchar( HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG+2, bData );	
				bData |= (0x11 << i);		/* mask plug/unplug INT */
				WritePortUchar( HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG+2, bData );

				/* do hard reset */ 
				ReadPortUchar(HostBaseAddr[bAdapterNumber],oFFSETHOSTPCICTL+1 , bData );
				bData &= ~ (0x10 << i);
				WritePortUchar(HostBaseAddr[bAdapterNumber],oFFSETHOSTPCICTL+1 , bData );
				bData |= (0x10 << i);
				WritePortUchar(HostBaseAddr[bAdapterNumber],oFFSETHOSTPCICTL+1 , bData );
						
				/* wait SATA connect well */
				for ( j=0; j<100;j++)
				{
					ReadPortUlong( HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG, ldata );
					ldata >>= i;
					if ( ldata & 0x100 )
						break;
					camStallExecution(1);
				}	
		
				/* clear plug/unplug flags */
				ReadPortUchar( HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG, bData );	
				bData |= (0x11 << i);		/* clear plug/unplug flags */
				WritePortUchar( HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG, bData );
				/* unmask plug/unplug INT */
				ReadPortUchar( HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG+2, bData );	
				bData &= ~(0x11 << i);   /* unmask plug/unplug INT */
				WritePortUchar( HostBaseAddr[bAdapterNumber], oFFSETHOSTSATAPLUG+2, bData );
			
				camCheckDriveStatus((U8) (bAdapterNumber*MAX_ATA_CHNL+i), 0, NEW_DRIVE);
			}
			PlugData >>= 1;
		}
		
	}

	return returnValue;
}
