/*
 * High performance packet classification module for netfilter
 *
 * Authors: Michael Bellion and Thomas Heinz
 * (c) 2002-2003 by the hipac core team <nf@hipac.org>:
 *      +-----------------------+----------------------+
 *      |   Michael Bellion     |     Thomas Heinz     |
 *      | <mbellion@hipac.org>  |  <creatix@hipac.org> |
 *      +-----------------------+----------------------+
 * Licenced under the GNU General Public Licence, version >= 2.
 */


#ifndef _NFHP_MOD_H
#define _NFHP_MOD_H

#include <linux/module.h>
#include <asm/semaphore.h>

/* use these macros to protect hipac api calls */
#define HIPAC_LOCK                \
do {                              \
	down(&nlhp_lock);         \
	down(&nlhp_listing_lock); \
	up(&nlhp_listing_lock);   \
} while (0)

#define HIPAC_UNLOCK up(&nlhp_lock)

/* hipac data structures for INPUT, FORWARD and OUTPUT hook and the
   corresponding netfilter hook ops */
extern void *hipac_input;
extern struct nf_hook_ops input_op;

extern void *hipac_forward;
extern struct nf_hook_ops forward_op;

extern void *hipac_output;
extern struct nf_hook_ops output_op;

/* netlink mutex */
extern struct semaphore nlhp_lock;

/* listing mutex */
extern struct semaphore nlhp_listing_lock;

int
nfhp_register_cthelp(struct module *nfhp_cthelp_module);

void
nfhp_unregister_cthelp(struct module *nfhp_cthelp_module);

#endif
