/************************************ */
/* Rule Set Based Access Control      */
/* Author and (c) 1999-2001:          */
/*   Amon Ott <ao@rsbac.org>          */
/* Data Structs etc. for Access       */
/* Control Decision Facility          */
/* Last modified: 21/Nov/2002         */
/************************************ */

#ifndef __RSBAC_ADF_MAIN_H
#define __RSBAC_ADF_MAIN_H

#include <linux/sched.h>
#include <rsbac/types.h>

#if defined(CONFIG_RSBAC_REG) || defined(CONFIG_RSBAC_REG_MAINT)
#include <rsbac/reg.h>
#endif

#ifdef CONFIG_RSBAC_SECDEL
#include <linux/dcache.h>
#endif

/***************************************************/
/*              Global Variables                   */
/***************************************************/

extern u_long rsbac_adf_request_count[T_NONE+1];
extern u_long rsbac_adf_set_attr_count[T_NONE+1];
#ifdef CONFIG_RSBAC_XSTATS
extern u_long rsbac_adf_request_xcount[T_NONE+1][R_NONE];
extern u_long rsbac_adf_set_attr_xcount[T_NONE+1][R_NONE];
#endif

/***************************************************/
/*              General Prototypes                 */
/***************************************************/

/* We call this function in kernel/sched.c         */
extern struct task_struct * find_process_by_pid(pid_t);

#ifdef CONFIG_RSBAC_DEBUG
extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_check(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern int rsbac_adf_set_attr_check( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */
#endif

extern enum rsbac_adf_req_ret_t
    adf_and_plus(enum rsbac_adf_req_ret_t res1,
                 enum rsbac_adf_req_ret_t res2);

/***************************************************/
/*              Module Prototypes                  */
/***************************************************/

#if !defined(CONFIG_RSBAC_MAINT)

/******* MAC ********/

#ifdef CONFIG_RSBAC_MAC
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_mac;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_mac(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_mac( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_mac(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif

#endif  /* MAC */


/******* FC ********/

#ifdef CONFIG_RSBAC_FC
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_fc;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_fc(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_fc ( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_fc(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif

#endif  /* FC */


/******* SIM ********/

#ifdef CONFIG_RSBAC_SIM
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_sim;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_sim(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_sim( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_sim(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif

#endif  /* SIM */


/******* PM ********/

#ifdef CONFIG_RSBAC_PM
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_pm;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_pm(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_pm ( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern boolean rsbac_need_overwrite_pm(struct dentry * dentry_p);
#endif

#endif  /* PM */

/******* MS ********/

#ifdef CONFIG_RSBAC_MS
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_ms;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_ms(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_ms ( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_ms(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif

#endif  /* MS */
 
/******* FF ********/

#ifdef CONFIG_RSBAC_FF
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_ff;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_ff(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_ff ( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern boolean rsbac_need_overwrite_ff(struct dentry * dentry_p);
#endif

#endif  /* FF */
 
/******* RC ********/

#ifdef CONFIG_RSBAC_RC
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_rc;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_rc(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_rc ( enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

/* Secure delete/truncate for this module */
#ifdef CONFIG_RSBAC_SECDEL
extern boolean rsbac_need_overwrite_rc(struct dentry * dentry_p);
#endif
#endif  /* RC */

/****** AUTH *******/

#ifdef CONFIG_RSBAC_AUTH
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_auth;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_auth(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_auth(enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_auth(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif
#endif /* AUTH */

/****** ACL *******/

#ifdef CONFIG_RSBAC_ACL
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_acl;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_acl(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_acl (enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_acl(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif
#endif /* ACL */

/****** CAP *******/

#ifdef CONFIG_RSBAC_CAP
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_cap;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_cap(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_cap (enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_cap(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif
#endif /* CAP */

/****** JAIL *******/

#ifdef CONFIG_RSBAC_JAIL
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_jail;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_jail(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_jail(enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_jail(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif
#endif /* JAIL */

/****** RES *******/

#ifdef CONFIG_RSBAC_RES
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_res;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_res(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_res (enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_res(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif
#endif /* RES */

/****** REG *******/

#if defined(CONFIG_RSBAC_REG)
#ifdef CONFIG_RSBAC_SWITCH
extern  boolean rsbac_switch_reg;
#endif

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_reg(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

extern  int  rsbac_adf_set_attr_reg (enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                           rsbac_uid_t); /* process owner */

#ifdef CONFIG_RSBAC_SECDEL
extern inline boolean rsbac_need_overwrite_reg(struct dentry * dentry_p)
  {
    return FALSE;
  }
#endif
#endif /* REG */

#endif /* !MAINT */

#if defined(CONFIG_RSBAC_REG) || defined(CONFIG_RSBAC_REG_MAINT)
/* Init */
#ifdef CONFIG_RSBAC_INIT_DELAY
void rsbac_reg_init(void);
#else
void rsbac_reg_init(void) __init;
#endif

/* mounting and umounting */
extern int rsbac_mount_reg(kdev_t kdev);
extern int rsbac_umount_reg(kdev_t kdev);

/* RSBAC attribute saving to disk can be triggered from outside
 * param: call lock_kernel() before writing?
 */
#if defined(CONFIG_RSBAC_AUTO_WRITE)
extern int rsbac_write_reg(boolean);
#endif /* CONFIG_RSBAC_AUTO_WRITE */

/* Status checking */
extern int rsbac_check_reg(int correct, int check_inode);

#endif /* REG */

#endif /* End of adf_main.h */
