#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/file.h>
#include <linux/grinternal.h>
#include <linux/grsecurity.h>

void
gr_log_textrel(struct vm_area_struct * vma)
{
#ifdef CONFIG_GRKERNSEC_AUDIT_TEXTREL
	if (grsec_enable_audit_textrel)
		security_audit(GR_TEXTREL_AUDIT_MSG, vma->vm_file ?
				gr_to_filename(vma->vm_file->f_dentry, vma->vm_file->f_vfsmnt)
				: "<anonymous mapping>", vma->vm_start,
				vma->vm_pgoff, DEFAULTSECARGS); 
#endif
	return;
}
