#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/smp_lock.h>
#include <linux/grsecurity.h>
#include <linux/grinternal.h>

extern int last_pid;

int
gr_random_pid(spinlock_t * pid_lock)
{
#ifdef CONFIG_GRKERNSEC_RANDPID
	struct task_struct *p;
	int pid;

	if (grsec_enable_randpid && current->fs->root) {
		read_lock(&tasklist_lock);
		spin_lock(pid_lock);

	      repeater:

		pid = 1 + (get_random_long() % PID_MAX);

		for_each_task(p) {
			if (p->pid == pid || p->pgrp == pid ||
			    p->tgid == pid || p->session == pid)
				goto repeater;
		}
		last_pid = pid;
		spin_unlock(pid_lock);
		read_unlock(&tasklist_lock);
		return pid;
	}
#endif
	return 0;
}
