/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   Copyright (C) Andrew Tridgell 1994
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
   This file does all the #includes's. This makes it easier to
   port to a new unix. Hopefully a port will only have to edit the Makefile
   and add a section for the new unix below.
*/


/* the first OS dependent section is to setup what includes will be used.
   the main OS dependent section comes later on 
*/

#ifdef MIPS
#define POSIX_H
#define NO_UTIMEH
#endif

#ifdef sun386
#define NO_UTIMEH
#endif

#ifdef NEXT2
#define NO_UTIMEH
#endif

#ifdef NEXT3_0
#define NO_UTIMEH
#define NO_UNISTDH
#endif

#ifdef APOLLO
#define NO_UTIMEH
#define NO_SYSMOUNTH
#define NO_UNISTDH
#endif

#ifdef M88K_R3
#define SVR3H
#define NO_RESOURCEH
#endif

#ifdef DNIX
#define NO_SYSMOUNTH
#define NO_NETIFH
#define NO_RESOURCEH
#endif


#ifdef ISC
#define SYSSTREAMH
#define NO_RESOURCEH
#endif

#if (defined(SHADOW_PWD)||defined(OSF1_ENH_SEC)||defined(SecureWare)||defined(PWDAUTH))
#define PASSWORD_LENGTH 16
#endif


/* here is the general includes section - with some ifdefs generated 
   by the previous section 
*/
#include "local.h"
#include <stdio.h>
#ifdef POSIX_STDLIBH
#include <posix/stdlib.h>
#else
#include <stdlib.h>
#endif
#include <ctype.h>
#include <time.h>
#ifndef NO_UTIMEH
#include <utime.h>
#endif
#include <sys/types.h>

#ifdef SVR3H
#include <sys/statfs.h>
#include <sys/stream.h>
#include <netinet/types.h>
#include <netinet/ether.h>
#include <netinet/ip_if.h>
#endif

#include <sys/socket.h>
#include <sys/ioctl.h>
#include <stddef.h>
#ifdef POSIX_H
#include <posix/utime.h>
#include <bsd/sys/time.h>
#include <bsd/netinet/in.h>
#else
#include <sys/time.h>
#include <netinet/in.h>
#endif 
#include <netdb.h>
#include <signal.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <grp.h>
#ifndef NO_RESOURCEH
#include <sys/resource.h>
#endif
#ifndef NO_SYSMOUNTH
#include <sys/mount.h>
#endif
#include <pwd.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#ifndef NO_UNISTDH
#include <unistd.h>
#endif
#include <sys/wait.h>
#ifdef SYSSTREAMH
#include <sys/stream.h>
#endif
#ifndef NO_NETIFH
#ifdef POSIX_H
#include <bsd/net/if.h>
#else
#include <net/if.h>
#endif
#endif

#if USE_MMAP
#include <sys/mman.h>
#endif

#if defined(GETPWANAM)
#include <sys/types.h>
#include <sys/label.h>
#include <sys/audit.h>
#include <pwdadj.h>
#endif

#if defined(SHADOW_PWD) && !defined(NETBSD)
#include <shadow.h>
#endif

/* this might be different on different systems */
#ifdef QUOTAS 
#include <sys/quota.h>
#ifndef CRAY
#include <devnm.h>
#else
#include <mntent.h>
#endif
#endif



/***************************************************************************
Here come the platform specific sections
***************************************************************************/


#ifdef LINUX
#include <arpa/inet.h>
#include <dirent.h>
#include <string.h>
#include <sys/vfs.h>
#include <netinet/in.h>
#ifndef NO_ASMSIGNALH
#include <asm/signal.h>
#endif
#define SIGNAL_CAST (__sighandler_t)
#define USE_GETCWD
#define USE_SETSID
#ifdef SHADOW_PWD
#ifndef crypt
#define crypt pw_encrypt
#endif
#endif
#endif


/* this is for SunOS 4 */
#ifdef SUN
#define SIGNAL_CAST (void (*)(int))
#include <netinet/tcp.h>
#include <sys/dirent.h>
#include <sys/acct.h>
#include <sys/vfs.h>
#include <string.h>
#include <errno.h>
#include <sys/wait.h>
#include <signal.h>
#ifdef sun386
#define NO_STRFTIME
#define NO_UTIMBUF
typedef unsigned short mode_t;
#else
#include <utime.h>
#define NO_STRERROR
#endif
#endif


/* this is for solaris 2.2 and above */
#ifdef SOLARIS
#include <sys/fcntl.h>
#include <dirent.h>
#include <sys/acct.h>
#include <sys/statfs.h>
#include <sys/statvfs.h>
#include <sys/filio.h>
#include <netinet/in_systm.h>
#include <netinet/tcp.h>
#include <netinet/ip.h>
#include <string.h>
#define USE_SETVBUF
#define SIGNAL_CAST (void (*)(int))
#ifndef SYSV
#define SYSV
#endif
#define USE_WAITPID
#define REPLACE_STRLEN
#define USE_STATVFS
#define USE_GETCWD
#define DEFAULT_PRINTING PRINT_SYSV
#define USE_SETSID
#endif


#ifdef SGI
#include <netinet/tcp.h>
#include <sys/statfs.h>
#include <string.h>
#include <signal.h>
#define SYSV
#define SIGNAL_CAST (void (*)())
#define STATFS4
#define USE_WAITPID
#define USE_DIRECT
#endif

#ifdef SGI5
#include <netinet/tcp.h>
#include <sys/statfs.h>
#include <string.h>
#include <signal.h>
#include <dirent.h>
#define USE_WAITPID
#define NETGROUP 
#ifndef SYSV
#define SYSV
#endif
#define SIGNAL_CAST (void (*)())
#define STATFS4
#define USE_WAITPID
#endif


#ifdef MIPS
#include <bsd/net/soioctl.h>
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/statfs.h>
#include <sys/wait.h>
#include <sys/termio.h>
#define SIGNAL_CAST (void (*)())
typedef int mode_t;
extern struct group *getgrnam();
extern struct passwd *getpwnam();
#define STATFS4
#define NO_STRERROR
#define REPLACE_STRSTR
#endif /* MIPS */



#ifdef DGUX
#include <string.h>
#include <dirent.h>
#include <sys/statfs.h>
#include <sys/statvfs.h>
#include <fcntl.h>
#include <termios.h>
#define SYSV
#define USE_WAITPID
#define SIGNAL_CAST (void (*)(int))
#define STATFS4
#define USE_GETCWD
#endif


#ifdef SVR4
#include <string.h>
#include <sys/dir.h>
#include <dirent.h>
#include <sys/statfs.h>
#include <sys/statvfs.h>
#include <sys/vfs.h>
#include <sys/filio.h>
#include <fcntl.h>
#include <sys/sockio.h>
#include <termios.h>
#define SYSV
#define USE_WAITPID
#define SIGNAL_CAST (void (*)(int))
#define USE_STATVFS
#define USE_GETCWD
#define DEFAULT_PRINTING PRINT_SYSV
#endif


#ifdef ULTRIX
#include <strings.h>
#include <nfs/nfs_clnt.h>
#include <nfs/vfs.h>
#include <netinet/tcp.h>
#ifdef ULTRIX_AUTH
#include <auth.h>
#endif
char *getwd(char *);
#define GID_TYPE int
#define NOSTRDUP
#ifdef __STDC__
#define SIGNAL_CAST (void(*)(int))
#endif
#define USE_DIRECT
#endif


#ifdef OSF1
#include <termios.h>
#include <strings.h>
#include <dirent.h>
char *getwd(char *);
char *mktemp(char *); /* No standard include */
#include <netinet/in.h>
#include <arpa/inet.h> /* both for inet_ntoa */
#define SIGNAL_CAST ( void (*) (int) )
#define STATFS3
#define USE_F_FSIZE
#include <netinet/tcp.h>
#ifdef OSF1_ENH_SEC
#include <pwd.h>
#include <sys/types.h>
#include <sys/security.h>
#include <prot.h>
#include <unistd.h>
#define PASSWORD_LENGTH 16
#endif  /* OSF1_ENH_SEC */
#endif


#ifdef CLIX
#include <dirent.h>
#define SIGNAL_CAST	(void (*)())
#include <sys/fcntl.h>
#include <sys/statfs.h>
#include <string.h>
#define NO_EID
#define USE_WAITPID
#define STATFS4
#define NO_FSYNC
#define USE_GETCWD
#define USE_SETSID
#endif	/* CLIX */



#ifdef BSDI
#include <string.h>
#include <netinet/tcp.h>
#define SIGNAL_CAST (void (*)())
#define USE_DIRECT
#endif


#ifdef NETBSD
#include <strings.h>
#include <netinet/tcp.h>
/* you may not need this */
#define NO_GETSPNAM
#define SIGNAL_CAST (void (*)())
#define USE_DIRECT
#endif 



#ifdef FreeBSD
#include <strings.h>
#include <netinet/tcp.h>
#define SIGNAL_CAST (void (*)())
#define USE_DIRECT
#endif 



#ifdef AIX
#include <strings.h>
#include <sys/dir.h>
#include <sys/select.h>
#include <dirent.h>
#include <sys/statfs.h>
#include <sys/vfs.h>
#include <sys/id.h>
#include <sys/priv.h>
#include <netinet/tcp.h>
#define SYSV
#define USE_WAITPID
#define SIGNAL_CAST (void (*)())
#define DEFAULT_PRINTING PRINT_AIX
#endif


#ifdef HPUX
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/vfs.h>
#include <sys/types.h>
#include <sys/termios.h>
#include <netinet/tcp.h>
#define SIGNAL_CAST (void (*)(__harg))
#define SELECT_CAST (int *)
#define SYSV
#define USE_WAITPID
#define WAIT3_CAST2 (int *)
#define USE_GETCWD
#define USE_SETSID
#define USE_SETRES
#define DEFAULT_PRINTING PRINT_HPUX
#endif


#ifdef SEQUENT
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/statfs.h>
#include <sys/stat.h>
#include <sys/buf.h>
#include <sys/socket.h>
#include <unistd.h>
#include <fcntl.h>
#define SIGNAL_CAST (void (*)(int))
#define USE_WAITPID
#define USE_GETCWD
#define NO_EID
#define USE_DIRECT
#endif


#ifdef NEXT
#include <strings.h>
#include <sys/dir.h>
#include <dirent.h>
#include <sys/vfs.h>
#define bzero(b,len) memset(b,0,len)
#include <libc.h>
#define NOSTRDUP
#define USE_WAITPID
#define NO_STRFTIME
#define USE_GETCWD
#define WAIT3_CAST1 (union wait *)
#endif


#ifdef NEXT2
#include <sys/types.h>
#include <strings.h>
#include <dirent.h>
#include <sys/vfs.h>
#define bzero(b,len) memset(b,0,len)
#define mode_t int
#define NO_UTIMBUF
#include <libc.h>
#define NOSTRDUP
#define USE_DIRECT
#define USE_WAITPID
#endif 


#ifdef NEXT3_0
#include <strings.h>
#include <sys/dir.h>
#include <sys/vfs.h>
#define bzero(b,len) memset(b,0,len)
#define NO_UTIMBUF
#include <libc.h>
#define NOSTRDUP
#define USE_DIRECT
#define mode_t int
#endif



#ifdef APOLLO
#include <string.h>
#include <fcntl.h>
#include <sys/statfs.h>
#define NO_UTIMBUF
#define USE_DIRECT
#define USE_GETCWD
#define SIGNAL_CAST     (void (*)())
#define HAVE_FCNTL_LOCK 0
#define HAVE_GETTIMEOFDAY
#define STATFS4
#endif



#ifdef SCO
#include <dirent.h>
#include <string.h>
#include <fcntl.h>
#include <sys/statfs.h>
#include <sys/stropts.h>
#ifdef NETGROUP
#include <rpcsvc/ypclnt.h>
#endif
#ifdef SecureWare
#include <sys/security.h>
#include <sys/audit.h>
#include <prot.h>
#define crypt bigcrypt
#endif
#define ftruncate(f,l) syscall(0x0a28,f,l)
#define SIGNAL_CAST (void (*)(int))
#define USE_WAITPID
#define USE_GETCWD
#define USE_SETSID
#ifdef SCO3_2_2
#define NO_EID
#else
#define USE_IFREQ
#endif
#define STATFS4
#define NO_FSYNC
#define NO_INITGROUPS
#define HAVE_PATHCONF
#endif



/* Definitions for RiscIX */
#ifdef RiscIX
#define SIGNAL_CAST (void (*)(int))
#include <sys/dirent.h>
#include <sys/acct.h>
#include <sys/vfs.h>
#include <string.h>
#include <utime.h>
#include <signal.h>
#define HAVE_GETTIMEOFDAY
#define NOSTRCASECMP
#define NOSTRDUP
#endif



#ifdef ISC
#include <net/errno.h>
#include <string.h>
#include <sys/dir.h>
#include <dirent.h>
#include <sys/statfs.h>
#include <fcntl.h>
#include <sys/sioctl.h>
#include <stropts.h>
#include <limits.h>
#include <netinet/tcp.h>
#define FIONREAD FIORDCHK
#define SYSV
#define USE_WAITPID
#define SIGNAL_CAST (void (*)(int))
#define USE_GETCWD
#define USE_SETSID
#define USE_IFREQ
#define NO_FTRUNCATE
#define STATFS4
#define NO_FSYNC
#endif



#ifdef AUX
#include <fstab.h>
#include <string.h>
#include <dirent.h>
#include <sys/vfs.h>
#include <fcntl.h>
#include <termios.h>
#define SYSV
#define USE_WAITPID
#define SIGNAL_CAST (void (*)(int))
char *strdup (char *);
#define USE_GETCWD
#endif


#ifdef M88K_R3
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <termios.h>
#define STATFS4
#define SYSV
#define USE_WAITPID
#define SIGNAL_CAST (void (*)(int))
char *strdup (char *);
#define USE_GETCWD
#define NO_FSYNC
#define DEFAULT_PRINTING PRINT_SYSV
#define NO_EID
#endif


#ifdef DNIX
#include <dirent.h>
#include <string.h>
#include <fcntl.h>
#include <sys/statfs.h>
#include <sys/stropts.h>
#define NO_GET_BROADCAST
#define USE_WAITPID
#define USE_GETCWD
#define USE_SETSID
#define STATFS4
#define NO_EID
#define PF_INET AF_INET
#define NO_STRERROR
#define ftruncate(f,l) chsize(f,l)
#endif /* DNIX */



#ifdef CRAY
#define MAXPATHLEN 1024
#include <dirent.h>
#include <string.h>
#include <fcntl.h>
#include <sys/statfs.h>
#define SIGNAL_CAST (void (*)(int))
#define SIGCLD_IGNORE
#define HAVE_FCNTL_LOCK 1
#define USE_SETSID
#define STATFS4
#endif



/*******************************************************************
end of the platform specific sections
********************************************************************/


/* Now for some other grungy stuff */
#ifdef NO_GETSPNAM
struct spwd { /* fake shadow password structure */
       char *sp_pwdp;
};
#endif

#ifdef USE_DIRECT
#include <sys/dir.h>
#endif

/* this unix might use int for gid_t (eg: Ultrix) */
#ifndef GID_TYPE
#define GID_TYPE gid_t
#endif

/* some unixes have ENOTTY instead of TIOCNOTTY */
#ifndef TIOCNOTTY
#ifdef ENOTTY
#define TIOCNOTTY ENOTTY
#endif
#endif

#ifndef SIGHUP
#define SIGHUP 1
#endif

/* if undefined then use bsd printing */
#ifndef DEFAULT_PRINTING
#define DEFAULT_PRINTING PRINT_BSD
#endif


#ifdef AFS_AUTH
#include <afs/stds.h>
#include <afs/kautils.h>
#endif

#ifdef NO_UTIMBUF
struct utimbuf {
  time_t actime;
  time_t modtime;
};
#endif

#ifdef NO_STRERROR
#ifndef strerror
extern char *sys_errlist[];
#define strerror(i) sys_errlist[i]
#endif
#endif

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 255
#endif

#include "version.h"
#include "smb.h"
#include "byteorder.h"

#ifdef KANJI
#ifndef _KANJI_C_
#include "kanji.h"
#endif /* _KANJI_C_ */
#endif /* KANJI */

#include "charset.h"

#ifndef S_IFREG
#define S_IFREG 0100000
#endif

#ifndef S_ISREG
#define S_ISREG(x) ((S_IFREG & x)!=0)
#endif

#ifndef S_ISDIR
#define S_ISDIR(x) ((S_IFDIR & x)!=0)
#endif

#ifdef UFC_CRYPT
#define crypt ufc_crypt
#endif

#ifdef REPLACE_STRLEN
#define strlen(s) Strlen(s)
#endif

#ifdef REPLACE_STRSTR
#define strstr(s,p) Strstr(s,p)
#endif

#ifndef NGROUPS_MAX
#define NGROUPS_MAX 128
#endif

#ifndef EDQUOT
#define EDQUOT ENOSPC
#endif

#ifndef HAVE_GETGRNAM
#define HAVE_GETGRNAM 1
#endif

#ifndef SOL_TCP
#define SOL_TCP 6
#endif

/* default to using ftruncate workaround as this is safer than assuming
it works and getting lots of bug reports */
#ifndef FTRUNCATE_CAN_EXTEND
#define FTRUNCATE_CAN_EXTEND 0
#endif

/* maybe this unix doesn't separate RD and WR locks? */
#ifndef F_RDLCK
#define F_RDLCK F_WRLCK
#endif

#ifndef ENOTSOCK
#define ENOTSOCK EINVAL
#endif

#ifndef SIGCLD
#define SIGCLD SIGCHLD
#endif 

#ifndef HAVE_FCNTL_LOCK
#define HAVE_FCNTL_LOCK 1
#endif

#ifndef WAIT3_CAST2
#define WAIT3_CAST2 (struct rusage *)
#endif

#ifndef WAIT3_CAST1
#define WAIT3_CAST1 (int *)
#endif


/* this is a rough check to see if this machine has a lstat() call.
   it is not guaranteed to work */
#if !(defined(S_ISLNK) || defined(S_IFLNK))
#define lstat stat
#endif

/* Not all systems declare ERRNO in errno.h... and some systems #define it! */
#ifndef errno
extern int errno;
#endif 


#ifdef NO_EID
#define geteuid() getuid()
#define getegid() getgid()
#define seteuid(x) setuid(x)
#define setegid(x) setgid(x)
#endif


#if (HAVE_FCNTL_LOCK == 0)
/* since there is no locking available, system includes  */
/* for DomainOS 10.4 do not contain any of the following */
/* #define's. So, to satisfy the compiler, add these     */
/* #define's, although they arn't really necessary.      */
#define F_GETLK 0
#define F_SETLK 0
#define F_WRLCK 0
#define F_UNLCK 0
#endif /* HAVE_FCNTL_LOCK == 0 */


/* possibly wrap the malloc calls */
#if WRAP_MALLOC

/* undo the old malloc def if necessary */
#ifdef malloc
#define xx_old_malloc malloc
#undef malloc
#endif

#define malloc(size) malloc_wrapped(size,__FILE__,__LINE__)

/* undo the old realloc def if necessary */
#ifdef realloc
#define xx_old_realloc realloc
#undef realloc
#endif

#define realloc(ptr,size) realloc_wrapped(ptr,size,__FILE__,__LINE__)

/* undo the old free def if necessary */
#ifdef free
#define xx_old_free free
#undef free
#endif

#define free(ptr) free_wrapped(ptr,__FILE__,__LINE__)

/* and the malloc prototypes */
void *malloc_wrapped(int,char *,int);
void *realloc_wrapped(void *,int,char *,int);
void free_wrapped(void *,char *,int);

#endif


