/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the shell user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
 */

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */

#ifndef _H_QCOMMANDS
#define _H_QCOMMANDS

typedef struct _sbuff {
  Source s;
  char* buffer;
  long buffer_offset;
  long toRead;
  long read_state;
  long page;
  long chars_per_page;
  long doc_size;
  Textbuff textstruct;
  XtInputId xid; /* Input Id from XtAddInput */
} _Sbuff, *Sbuff;

XawTextPosition findstring (char* text, char* string, Boolean casesensitive);
void fuzzButtons (boolean fuzz);
void Abort (Widget w, XtPointer closure, XtPointer call_data);
void Prefs (Widget w, XtPointer closure, XtPointer call_data);
void DoPSave (Widget w, XtPointer closure, XtPointer call_data);
void DontPSave (Widget w, XtPointer closure, XtPointer call_data);
void DoSearch (Widget w, XtPointer closure, XtPointer call_data);
void CloseQuestionEdit (Widget w, XtPointer closure, XtPointer call_data);
void AddResponseToQuestion (Widget w, XtPointer closure, XtPointer call_data);
void AddDocToQuestion (Widget w, XtPointer closure, XtPointer call_data);
void DeleteQuestionDoc (Widget w, XtPointer closure, XtPointer call_data);
void PopupSourceMenu (Widget w, XtPointer closure, XtPointer call_data);
void AddSourceToQuestion (Widget w, XtPointer closure, XtPointer call_data);
void EditQuestionSource (Widget w, XtPointer closure, XtPointer call_data);
void DeleteQuestionSource (Widget w, XtPointer closure, XtPointer call_data);
void doType (Widget w, XtPointer closure, XtPointer call_data);
void SensitizeDelSource (Widget w, XtPointer closure, XtPointer call_data);
void SensitizeAddDoc (Widget w, XtPointer closure, XtPointer call_data);
void SensitizeDelDoc (Widget w,XtPointer closure,XtPointer call_data);
void ViewDoc (DocumentID doc, char* type, long size, Boolean saveit);
void ViewResponse (Widget w, XtPointer closure, XtPointer call_data);
void ViewRelevant (Widget w, XtPointer closure, XtPointer call_data);
void EndText (Widget w, XtPointer closure, XtPointer call_data);
void showKeyword (Widget w, XtPointer closure, XtPointer call_data);
void SaveText (Widget w, XtPointer closure,XtPointer call_data);
void DoSave (Widget w, XtPointer closure, XtPointer call_data);
void DoTSave (Widget w, XtPointer closure, XtPointer call_data);
void DontTSave (Widget w, XtPointer closure, XtPointer call_data);
void setSourceMenu (void);
void addSection (Widget w, XtPointer closure, XtPointer call_data);
void DoSSave (Widget w, XtPointer closure, XtPointer call_data);
void DontSSave (Widget w, XtPointer closure, XtPointer call_data);
void showNext (Widget w, XtPointer closure, XtPointer call_data);
void showPrevious (Widget w, XtPointer closure, XtPointer call_data);
void setFile (Widget w, XtPointer closure, XtPointer call_data);
void quitFile (Widget w, XtPointer closure, XtPointer call_data);
char* GetKeywordsUsed (void);
#endif

/*
 * $Log: qcommands.h,v $
 * Revision 1.1.1.1  1996/06/04 20:38:45  julia
 * autoconf baseline
 *
 * Revision 1.1.1.1  1996/04/30 18:22:46  dmitriy
 * Version 2.1 -- autoconf baseline
 *
 * Revision 1.1.1.2  1996/04/23  19:47:30  dmitriy
 * autoconf baseline
 *
 * Revision 2.0.1.1  1995/09/15 09:57:00  pfeifer
 * patch7: Fixed CNIDR copyright line.
 *
 * Revision 2.0  1995/09/08  08:07:00  pfeifer
 * Metaconfig baseline
 *
 * Revision 1.2  1994/08/05  07:26:01  pfeifer
 * Release beta 04
 *
 * Revision 1.1  1993/02/16  15:10:18  freewais
 * Initial revision
 *
 * Revision 1.8  92/06/22  10:53:06  jonathan
 * Added prototype for GetKeywordsUsed.
 * 
 * Revision 1.7  92/06/15  13:53:52  jonathan
 * Added prototype for findkey (now public, for use by myAsciiSink.c)
 * 
 * Revision 1.6  92/04/28  15:29:00  jonathan
 * More prototypes.
 * 
 * Revision 1.5  92/03/23  16:09:10  jonathan
 * Added prototype for unfuzzButtons
 * 
 * Revision 1.4  92/03/17  14:24:41  jonathan
 * Prototyped everything.
 * 
 */
