/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */

/*
 * $Log: source.h,v $
 * Revision 1.1.1.1  1996/06/04 20:37:54  julia
 * autoconf baseline
 *
 * Revision 1.1.1.1  1996/04/30 18:22:40  dmitriy
 * Version 2.1 -- autoconf baseline
 *
 * Revision 1.1.1.2  1996/04/23  19:46:15  dmitriy
 * autoconf baseline
 *
 * Revision 2.0.1.1  1995/09/15 09:53:57  pfeifer
 * patch7: Fixed CNIDR copyright line.
 *
 * Revision 2.0  1995/09/08  08:05:21  pfeifer
 * Metaconfig baseline
 *
 * Revision 1.2  1994/08/05  07:18:33  pfeifer
 * Release beta 04
 *
 * Revision 1.1  93/06/23  20:02:38  warnock
 * Initial revision
 * 
 * Revision 1.1  1993/02/16  15:09:27  freewais
 * Initial revision
 *
 * Revision 1.8  92/04/02  14:23:06  jonathan
 * Added more prototypes.
 * 
 * Revision 1.7  92/03/17  14:31:23  jonathan
 * Merged SourceID.h in, prototyped everything.
 * 
 * Revision 1.6  92/03/06  14:51:04  jonathan
 * New and Improved source loading!
 * 
 * Revision 1.5  92/03/01  13:55:10  jonathan
 * fixed boolean to Boolean as X didn't know about it.
 * 
 * Revision 1.4  92/03/01  13:35:44  jonathan
 * Added functions for X interface.
 * 
 */

#ifndef _H_SOURCE
#define _H_SOURCE

#include <cdialect.h>

/* (jp) */
#ifndef EXTERN_SOURCE_ITEMS
#define EXTERN_SOURCE_ITEMS extern
#endif
EXTERN_SOURCE_ITEMS char **Source_items;
#undef EXTERN_SOURCE_ITEMS

#ifndef EXTERN_SOURCE_PATH
#define EXTERN_SOURCE_PATH extern
#endif
EXTERN_SOURCE_PATH char *sourcepath;
#undef EXTERN_SOURCE_PATH

typedef struct SourceID {
  char *filename;
} _SourceID, *SourceID;

typedef struct source{
  char *name;
  char *directory;
  char server[STRINGSIZE];
  char service[STRINGSIZE];
  char database[STRINGSIZE];
  char cost[STRINGSIZE];
  char units[STRINGSIZE];
  char *description;
  FILE *connection;
  long buffer_length;
  Boolean initp;
  char *maintainer;
} _Source, *Source;

typedef struct sourcelist {
  SourceID thisSource;
  struct sourcelist *nextSource;
} _SourceList, *SourceList;

typedef struct slist {
  Source thisSource;
  struct slist *nextSource;
} _SList, *SList;

/* functions */

void freeSourceID (SourceID sid);
SourceID copysourceID (SourceID sid);
char** buildSourceItemList (SourceList sourcelist);
char** buildSItemList (SList sourcelist);
short ReadSourceID (FILE* file, SourceID sid);
SourceList ReadListOfSources (FILE* fp);
Boolean ReadSource (Source source, FILE* file);
Boolean ReadSourceFile (Source asource, char* filename, char* directory);
Source loadSource (char* name, char *path);
void set_connection (Source source);
Boolean newSourcep (char* name);
Boolean is_source (char* name, Boolean test);
void SortSourceNames (int n);
void GetSourceNames (char* directory);
void ReadSourceDirectory (char* directory, Boolean test);
void WriteSource (char* directory, Source source, Boolean overwrite);
SourceList makeSourceList (SourceID source, SourceList rest);
SList makeSList (Source source, SList rest);
void FreeSource (Source source);
void FreeSources (SList sources);
Source findsource (char* name, char *path);
Source findSource (int n);
void format_source_cost (char* str, Source source);
void freeSource (SourceID sourceID);
void freeSourceList (SourceList slist);
Boolean init_for_source (Source source, char* request,
			 long length, char* response);
#endif
