/* WIDE AREA INFORMATION SERVER SOFTWARE
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.    
   Brewster@think.com
*/

/* Copyright (c) CNIDR (see ../doc/CNIDR/COPYRIGHT) */


/* list utilities */
#ifndef LIST_H
#define LIST_H

#include "cutil.h" /* for boolean */

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

void* car (void **list);

void* first (void **list);

void* second (void **list);

void* last (void **list);

void** cdr (void **list);

void** nth_cdr (void **list,long n);

void** rest (void **list);

void* cadr (void **list);

void* nth (long number, void **list);

void setf_nth (long number,void* elem,void**list);

/* length of a list.  returns -1 if error.*/
long length (void **list);

void mapcar (void **list, void function (void* argument));

/* pushes the item on the end of the list. returns the list. */
void **collecting (void **list, void *item);

void setf_car (void** list, void* item);

boolean null (void **list);

boolean free_list (void **list);

void sort_list (void** list,int (*cmp)(void* arg1,void* arg2));

void** remove_item_from_list (void** list,long pos);

#ifdef __cplusplus
	}
#endif /* def __cplusplus */


#endif /* ndef LIST_H */
