#include <stdio.h>
#include "cci.h"

#include "mosaic.h"
extern mo_window *current_win;

extern char *mo_post_pull_er_over (char *url, char *content_type,
                                   char *post_data,
                                   char **texthead);

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/* This module contains bindings between the new cci code and the browser  */
/* If you are retrofitting the cci on to your browser strip out everything */
/* except the function headers and the return values and stick in the      */
/* appropriate calls for your browser.                                     */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/


void MCCIRequestGetURL(retCode,retText,url,output,additionalHeader)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
char *url;
int output;
char *additionalHeader; 	/* currently additional header ignored */
{
mo_status moStatus;

#ifdef DEBUG
if (additionalHeader)
  printf("MCCIRequestGetURL(url=\"%s\",output=%d,header=\"%s\")\n",
	 url,output,additionalHeader);
else
  printf("MCCIRequestGetURL(url=\"%s\",output=%d)\n",
	 url,output);
#endif

	/*do it */
	if (!strchr (url, ':')) {
		url = mo_url_canonicalize_local (url);
		}

	switch (output) {
	    case MCCI_OUTPUT_CURRENT:
		moStatus = mo_load_window_text (current_win, url, NULL);
		if (moStatus == mo_succeed) {
			*retCode = MCCIR_GET_OK;
			strcpy(retText,"Got the URL");
			}
		else {
			*retCode = MCCIR_GET_FAILED;
			sprintf(retText,"Couldn't get URL %s",url);
			}
			break;
	    case MCCI_OUTPUT_NEW:
		if (!mo_open_another_window(current_win,url,NULL,NULL)) {
			*retCode = MCCIR_GET_FAILED;
			sprintf(retText,"Couldn't get URL %s",url);
			}
		else {
			*retCode = MCCIR_GET_OK;
			strcpy(retText,"Got the URL");
			}
		break;
	    case MCCI_OUTPUT_NONE:
		*retCode = MCCIR_GET_FAILED;
		strcpy(retText,"Sorry, OUTPUT to no where not supported yet");
		break;
	    default:
		*retCode = MCCIR_GET_FAILED;
		strcpy(retText,"Send output where???");
		break;
	    }

	return;
}

void MCCIRequestSendAnchor(retCode,retText,client,status)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int status; /* 0, MCCI_SEND_BEFORE, or MCCI_SEND_AFTER */
/* anchor replies may be sent back using MCCISendAnchorHistory(client,url)*/
{

#ifdef DEBUG
		printf("MCCIRequestSendAnchor(%d)\n",status);
#endif

		switch (status) {
		      case MCCI_SEND_BEFORE:
			MoCCISendAnchor(client,1);
			*retCode = MCCIR_SEND_ANCH_BEF_OTHR_OK;
			strcpy(retText,"Send Anchor Before enabled");
			break;
		      case MCCI_SEND_AFTER:
		        MoCCISendAnchor(client,2);
			*retCode = MCCIR_SEND_ANCH_AFT_OTHR_OK;
			strcpy(retText,"Send Anchor After enabled");
			break;
		      case 0:
			MoCCISendAnchor(client,0);
			*retCode = MCCIR_SEND_A_STOP_OK;
			strcpy(retText,"Send Anchor disabled");
			break;
		}
}

void MCCIRequestSendOutput(retCode,retText,client,on,type)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int on;		/* boolean value....turn on - true, off - false */
char *type;	/* if null, assume all types */
{

#ifdef DEBUG
		printf("MCCIRequestSendOutput(%d,%s)\n",on,type);
#endif
	if (on) {
		MoCCISendOutput(client,1,type);
		*retCode = MCCIR_SEND_OUTPUT_OK;
		strcpy(retText,"Send OUTPUT enabled");
		}
	else {
		MoCCISendOutput(client,0,type);
		*retCode = MCCIR_SEND_O_STOP_OK;
		strcpy(retText,"Send OUTPUT disabled");
		}
	return;
}



void MCCIRequestSendBrowserView(retCode,retText,client,on)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int on;		/* boolean value....turn on - true, off - false */
{

#ifdef DEBUG
		printf("MCCIRequestSendBrowserView(%d)\n",on);
#endif
	if (on) {
		MoCCISendBrowserView(client,1);
		*retCode = MCCIR_BROWSERVIEW_OK;
		strcpy(retText,"Send BROWSERVIEW enabled");
		}
	else {
		MoCCISendBrowserView(client,0);
		*retCode = MCCIR_BROWSERVIEW_STOP_OK;
		strcpy(retText,"Send BROWSERVIEW disabled");
		}
	return;
}



void MCCIRequestPost(client,retCode,retText,url,contentType,
			postData,dataLength,output)
MCCIPort client;
int *retCode;
char *retText;
char *url;
char *contentType;
char *postData;
int dataLength;
int output;
{
char *textHead;
char *response;
char buff[256];
int length;

#ifdef DEBUG
	printf("MCCIRequestPost(): about to mo_post_pull_er_over()\n");
	printf("mo_post_pull_er_over(url=\"%s\",type=\"%s\",postData=\"%s\")\n"
			,url,contentType,postData);
#endif

	*retCode = MCCIR_POST_OK;
	strcpy(retText,"Post Request ok");

	switch(output) {
		case MCCI_OUTPUT_NONE:
			/* do not display output of post, but send the
			   output back through the cci to the client */
			response = mo_post_pull_er_over(url, 
				contentType, postData, &textHead);

			/* send response back through cci */
			if (response && (length = strlen(response))) {
				MCCISendResponseLine(client,MCCIR_POST_OUTPUT,
							"POST output");
				sprintf(buff,"Content-Length: %d\r\n",length);
				if (length!=NetServerWrite(client,
							buff,strlen(buff))){
					/* this is pointless... I know */
					strcpy(retText,"couldn't send output");
					*retCode = MCCI_FAIL;
					}
				if (length!=NetServerWrite(client,
							response,length)) {
					/* this is pointless... I know */
					strcpy(retText,"couldn't send output");
					*retCode = MCCI_FAIL;
					}
				}
			
			break;
		case MCCI_OUTPUT_NEW:
			/* open a new window and display posting... */
			/* ...not done yet...*/

		case MCCI_DEFAULT: /* default to output current */
		case MCCI_OUTPUT_CURRENT:
		default:
			/* display in current window */
			response = mo_post_pull_er_over(url, 
				contentType, postData, &textHead);
			/*mo_decode_internal_reference(url,response,url);*/
			mo_do_window_text(current_win,url,
						response,response,1,url);
			
			break;
		}

#ifdef DEBUG
	printf("result from mo_post_pull_er_over():\"%s\"\n",response);
	printf("MCCIRequestPost(): returning now\n");
#endif

}


MCCIRequestQuit()
/* time to die */
{
	mo_exit();
}
