/*
**	net.c	- 
**
**
** Copyright (c) 1993  David J. Hughes
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <netdb.h>

#include <common/portability.h>
#include "msql_priv.h"


static 	u_char	packetBuf[PKT_LEN + 4];
static	int	readTimeout;
u_char	*packet = NULL;

initNet()
{
	packet = (u_char *)packetBuf + 4;
}



void writePkt(fd)
	int	fd;
{
	u_char	*cp;
	int	len,
		offset,
		remain,
		numBytes;

	cp = packetBuf;
	len = strlen(packet);
	*cp++ = (unsigned int)(len & 0x000000ff);
	*cp++ = (unsigned int)(len & 0x0000ff00) >> 8;
	*cp++ = (unsigned int)(len & 0x00ff0000) >> 16;
	*cp++ = (unsigned int)(len & 0xff000000) >> 24;

	offset = 0;
	remain = len+4;
	while(remain > 0)
	{
		numBytes = write(fd,packetBuf,len + 4);
		if (numBytes == -1)
		{
			return;
		}
		offset += numBytes;
		remain -= numBytes;
	}
}


RETSIGTYPE alarmHandler(sig)
	int	sig;
{
	readTimeout = 1;
}


int readPkt(fd)
	int	fd;
{
	u_char	*c,
		buf[4];
	int	len,
		remain,
		offset,
		numBytes;
	static	int init = 1;

#ifdef MSQL_SERVER
	if (init)
	{
		signal(SIGALRM,alarmHandler);
		init = 0;
	}
	alarm(10);
#endif
	readTimeout = 0;
	(void)bzero(packetBuf,(PKT_LEN + 4));
	if(read(fd,buf,4) <= 0)
	{
		alarm(0);
         	return(-1);
	}
#ifdef MSQL_SERVER
	if (readTimeout)
	{
		alarm(0);
		return(-1);
	}
#endif
        c = buf;
	len = *c++;
	len += ((int) *c++) << 8 ;
	len += ((int) *c++) << 16;
	len += ((int) *c++) << 24;
	if (len > PKT_LEN)
	{
		alarm(0);
		return(-1);
	}
	remain = len;
	offset = 0;
	while(remain > 0)
	{
		numBytes = read(fd,packet+offset,remain);
		if (readTimeout)
		{
			alarm(0);
			return(-1);
		}
		if (numBytes < 0)
		{
			alarm(0);
         		return(-1);
		}
		remain -= numBytes;
		offset += numBytes;
	}
	alarm(0);
        return(len);
}


