/* 
        COPYRIGHT (C) 1992, 1993, 1994 Oesterreich & Assc. Inc.

        NOTE: NAG is not free - it is shareware! See 'License Terms'
        in nag/README file

*/



#include "nag.h"
#include "utils.h"
#include "hooks.h"
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <setjmp.h>
#include <string.h>
#include <termios.h>

/* array size for terminal escape sequences */
#define ESCAPESIZE 16

extern char	*HomeMenu,*RcFile,*MessageFile,*ContextDir;
extern char	buf[];

#ifdef TERMIOS
struct termios orig; /* save tty settings so they can be restored */
struct termios work; /* save tty settings so they can be restored */

#else
struct termio tp; /* save tty settings so they can be restored */
                   /* needed since if readnews is interrupted, it */
                   /* trashes current settings */
unsigned short	c_lflag; /* stores normal local mode for terminal */
unsigned char	c_cc[NCC];
#endif

int     stin,sout,serr; /* terminal lines file desc. */
char    BOLDON[ESCAPESIZE],BOLDOFF[ESCAPESIZE],CLEAR[ESCAPESIZE];
int     rows; /* Number of lines that are displayed at a time */


surex()
{
char	c;

	wrline("To exit, type Y (or y). ");
	read1(&c,1); 
	if((c=='y')||(c=='Y')) return(1);
	clears();
	return(0); /* 0 = no exit */
}

void
beep(void)
{
	wrline("");
}

void
wrline(line)
char	*line;
{
char	p[UBUFSIZE];
char	*s;
int	i=0;

	if(line==NULL)return;
	if(!strlen(line))return;
	/* process nl -> cr + nl */
	s=line;
	while(*s)
	{
		if(*s=='\n')
		{
			p[i]='\r';
			i++;
		}
		p[i]=*s;
		i++;
		s++;
	}	
	p[i]='\0';
	write(sout,p,(strlen(p))); 
	tcdrain(sout);
	tcflush(stin,TCIFLUSH);
}

crpause()
{
int	c;
char	xtra[UBUFSIZE];

	sprintf(xtra,"Type <CR> to continue, or <ESC> to return to %s menu. ",HomeMenu);
	wrline(xtra);

	/* signal(SIGINT,doint); */
	read1(&c,1); 
	/* signal(SIGINT,SIG_IGN); */
	if((char)c==ESC)
	{
		doint(c);
		/* no return */
	}
	clears();
}

crpause_noclear()
{
int	c;
char	xtra[UBUFSIZE];

	sprintf(xtra,"Type <CR> to continue, or <ESC> to return to %s menu. ",HomeMenu);
	wrline(xtra);

	/* signal(SIGINT,doint); */
	read1(&c,1); 
	if((char)c==ESC)
	{
		doint(c);
		/* no return */
	}
	/* signal(SIGINT,SIG_IGN); */
}


can()
{
int	c;

	wrline("Type y (or Y) to continue; anything else cancels. ");
	read1(&c,1); 
	wrline("\n");
	if(((char)c=='y')||((char)c=='Y')) {return(0);}
	return(1); /* 0 = no exit */
}

clears()
{
char	tmp[UBUFSIZE];
int	i;

	if(strlen(CLEAR))
	{
	/* do twice to make up for flaky modems that might screw up 
	   the escape-command sequence                              */
		wrline(CLEAR);
		wrline(CLEAR);
	}
	else
	{
		for(i=0;i<rows;i++)
		{
			tmp[i]='\n';
			tmp[i+1]='\0';
		}
		wrline(tmp);
	}
}

read1(c,dummy2)
int	dummy2;
char	*c;
{
char	one;
	
	tcflush(stin,TCIFLUSH);
	do {
		read(stin,c,1);
		/* ignore XON/OFF chars */
		if((int)*c>=127)
		{
			goto loop;
		}
		if(*c=='\020')
		{
			goto loop;
		}
		if(*c=='\021')
		{
			goto loop;
		}
		if(*c=='\022')
		{
			goto loop;
		}
		if(*c=='\023')
		{
			goto loop;
		}
		one=*c;
		break;
		loop:;
	}
	while(1);
	*c=one;
}

int
InitTty(void)
{

        close(0); /* must close/ignore error. If not closed, file desc */
        close(1); /* values for open stdio are wrong */
        close(2);

	/* open/dup in the following order: */

        stin=open("/dev/tty",O_RDWR);
        sout=dup(stin);
        serr=dup(stin);

	if( stin<0 || sout<0 || serr<0)
	{
        	printf("ERROR: tty open/dup: stin=%d, sout=%d, serr=%d\n",
			stin,sout,serr);
        	return(0);
	}
        if(tcgetattr(stin,&work)<0)
	{
		printf("ERROR: tcgetattr fails: %s\n",strerror(errno));
		return(0);
	}
        if(tcgetattr(stin,&orig)<0)
	{
		printf("ERROR: tcgetattr fails: %s\n",strerror(errno));
		return(0);
	}
        cfmakeraw(&work);
        if(tcsetattr(stin,TCSANOW,&work)<0)
	{
		printf("ERROR: tcsetattr fails: %s\n",strerror(errno));
		return(0);
	}
	return(1);
}

void
SetTty(void)
{
        tcsetattr(stin,TCSANOW,&work);
}

void
RestoreTty()
{
	tcsetattr(stin,TCSANOW,&orig);
}

char
GetChar(void)
{
char	c;

        tcflush(stin,TCIFLUSH);
	read(stin,&c,1);
	return(c);
}

gl(len,pr,stat,notchars)
int	len,stat;
char	*pr,*notchars;
{
int	Busy=1,i=0,j;
int	error=0,skipc=0,first=1;
char	c,tmp[UBUFSIZE];

	strcpy(tmp,pr);
	boldit(tmp); 
	wrline(tmp);
	buf[1]='\0'; /* end of string for ESC return */
	do {
		c=GetChar();
		/* ignore XON/OFF & ctrl+q/ctrl+s chars */
		/* cntl-s = 023, cntl-q = 020 */
		/* map DEL to BS */
		if(c==DEL)c=BS;
		if((int)c>=127)
		{
			goto loop; 
		}
		if(c=='\023')
		{
			goto loop; 
		}
		if(c=='\021')
		{
			goto loop;
		}
		if(first&&(c=='-')) {return(-2);}
		if(first&&((c=='\n')||(c=='\r'))) {buf[0]='\0';return(0);}
		if(first&&(c==ESC)) {buf[0]=ESC;return(0);}
		if((c!='\n')&&(c!='\r')) 
		{
			if(c==BS)
			{
				if(i>0)
				{
					write(sout,&c,1);
					write(sout," ",1);
					write(sout,&c,1);
					i--;
					if(isspace(buf[i]))skipc=0;
					buf[i]='\0';
					if(i==0)first=1;
					goto loop;
				}
				else
				{
					goto loop;
				}
			}
			if((isspace(c))&&skipc)
			{
				continue;
			}
			else if(isspace(c)) {
				if(first)continue; /* ignore leading space */
				skipc=1;
				c=' '; /* change all whitespace to space */
				write(sout,&c,1);
				buf[i++]=c;
			}
			else {
				first=0;
				skipc=0;
				buf[i++]=c;
				write(sout,&c,1);
			}
		}
		else
		{
			/* either cr or nl - exit input loop */
			/* neither cr nor nl are placed in input buffer */
			Busy=0;
		}
		if(i>(len+1)) break;
		loop:;
	}
	while(Busy);
	buf[i]='\0';
	if(!strlen(buf)) {
		if(stat==REQUIRED) {
			beep();
			wrline("\n");
			wrline("ERROR: Line too short; input required.\n");
			return(-1);
		}
		else
			return(0);
	}
	if(i>len) {
		beep();
		wrline("\n");
		wrline("ERROR: Line too long.\n");
		return(-1);
	}

	i=0;
	while(buf[i]) {
		j=0;
		while(notchars[j]) {
			if(buf[i]==notchars[j++]) {	
				beep();
				wrline("\n");
				wrline("ERROR: ");
				buf[i+1]='\0';
				wrline(&buf[i]);
				wrline(" not allowed.\n");
				return(-1);
			}
		}
		i++;
	}

	i=0;
	while(buf[i]) {
		if(buf[i]=='~') {	
			beep();
			wrline("\n");
			wrline("ERROR: Tilde (~) not allowed.\n");
			return(-1);
		}
		if(!isprint(buf[i])) {	
			beep();
			wrline("\n");
			wrline("ERROR: Illegal (non-printable) character.\n");
			return(-1);
		}
		i++;
	}

clears();
return(strlen(buf));
}

