/* 
        COPYRIGHT (C) 1992, 1993, 1994 Oesterreich & Assc. Inc.

        NOTE: NAG is not free - it is shareware! See 'License Terms'
        in nag/README file

*/



#include "nag.h"
#include "utils.h"
#include "hooks.h"
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <setjmp.h>
#include <string.h>
#include <termios.h>

/* array size for terminal escape sequences */
#define ESCAPESIZE 16

extern char	*HomeMenu,*RcFile,*MessageFile,*ContextDir;

#ifdef TERMIOS
struct termios orig; /* save tty settings so they can be restored */
struct termios work; /* save tty settings so they can be restored */

#else
struct termio tp; /* save tty settings so they can be restored */
                   /* needed since if readnews is interrupted, it */
                   /* trashes current settings */
unsigned short	c_lflag; /* stores normal local mode for terminal */
unsigned char	c_cc[NCC];
#endif

int     stin,sout,serr; /* terminal lines file desc. */
extern char    BOLDON[],BOLDOFF[],CLEAR[];
extern int     rows; /* Number of lines that are displayed at a time */

terminfo()
{
char	c;
char	s[UBUFSIZE],xtra[UBUFSIZE];

	wrline("                   TERMINAL SETUP QUESTIONS.\n\n");
	wrline("Set your terminal to support ANSI mode (or compatible such as xterm or vt102).\n\n");
	wrline("After you enter a <CR>, the screen should be cleared.\n\n");
	crpause_noclear();
	sleep(1);
	wrline(ANSI_CLEAR_SCREEN);
	wrline("\n");
	wrline("Did the screen clear?\n");
	wrline("Enter y or n followed by a <CR> -> ");
	read1(&c,1); 
	if(c=='Y')c='y';
	if(c!='y')
	{
	        strcpy(CLEAR,""); /* can't clear screen */
	        strcpy(BOLDON,"");
        	strcpy(BOLDOFF,"");
		wrline("\n\n");
		wrline("Your terminal does not support simple screen functions.\n\n");
		wrline("Menu display will use line mode.\n\n");
		crpause();
		goto getout;
	}
        strcpy(CLEAR,ANSI_CLEAR_SCREEN); /* can clear screen */
	clears();
	wrline(ANSI_BOLD_OFF);
	wrline("\n");
	wrline("\n      ");
	wrline(ANSI_BOLD_ON);
	sprintf(s,"BOLD%s      NORMAL\n\n",ANSI_BOLD_OFF);
	wrline(s);
	wrline("Is the word BOLD brighter than the word NORMAL?\n\n");
	wrline("Enter y or n followed by a <CR> -> ");
	read1(&c,1); 
	if(c=='Y')c='y';
	if(c=='y')
	{
	        strcpy(BOLDON,ANSI_BOLD_ON);
        	strcpy(BOLDOFF,ANSI_BOLD_OFF);
		clears();
		wrline("Your terminal supports ANSI bold characters.\n\n");
		wrline("Menu system will use screen-clear and bold characters.\n\n");
		sprintf(xtra,"If display looks wrong, type TERMINAL at %s menu prompt.\n\n",HomeMenu);
		wrline(xtra);
                SetValue(RcFile,"#","TERM","~","ansi",1);
                if(strlen(ErrorMessage)) /* assume field did not exist */
                {
                        sprintf(s,"%s~%s\n","TERM","ansi");
                        AppendFile(RcFile,s);
                        if(strlen(ErrorMessage))
                        {
                                wrline("ERROR: ");
                                wrline(ErrorMessage);
                                wrline("\n");
                                crpause();
                                return;
                        }
                }
		crpause();
		return;
	}
	else
	{
	        strcpy(BOLDON,"");
        	strcpy(BOLDOFF,"");
	}
	wrline("Your terminal does not support ANSI bold characters.\n\n");
	crpause();
getout:
        SetValue(RcFile,"#","TERM","~","linemode",1);
        if(strlen(ErrorMessage)) /* assume field did not exist */
        {
                sprintf(s,"%s~%s\n","TERM","linemode");
                AppendFile(RcFile,s);
                if(strlen(ErrorMessage))
                {
                        wrline("ERROR: ");
                        wrline(ErrorMessage);
                        wrline("\n");
                        crpause();
                        return;
                }
        }
	return;
}

int
Prologue()
{
char    *s,*s2,*s3;

        rows=DEFAULT_ROWS;
        s=getenv("ROWS");
        if(s!=NULL)
        {
                rows=atoi(s);
                if((rows<18)||(rows>50))
                {
                        beep();
                        printf("ERROR: Environment variable ROWS value error.\n");
                        printf("       ROWS must be range 18 - 50.\n");
                        return(0);
                }
        }
        s=getenv("BOLDON");
        s2=getenv("BOLDOFF");
        s3=getenv("CLEAR");
        if(s&&s2&&s3)
        {
                strcpy(BOLDON,s);
                strcpy(BOLDOFF,s2);
                strcpy(CLEAR,s3);
        }
	return(1);
}

int
Epilogue(int checkuidflag,int ansiflag,int *termsetupflag)
{
struct stat     sbuf;
int	uid;

	if(stat(ContextDir,&sbuf))
	{
        	beep();
        	printf("ERROR: ContextDir not specified, or does not exist.\n");
               	return(0);
	}
	if(stat(MessageFile,&sbuf))
	{
        	beep();
        	printf("ERROR: MessageFile not specified, or does not exist.\n");
               	return(0);
	}
	if(stat(RcFile,&sbuf))
	{
        	beep();
        	printf("ERROR: Init file not specified, or does not exist.\n");
               	return(0);
	}
	
	uid=getuid();
	if(checkuidflag>-1)
	{
        	if(uid)
        	{
                	beep();
                	printf("ERROR: Wrong uid - UID=%d\n",(int)uid);
                	return(0);
        	}
	}
	if(ansiflag)
	{
        	termsetupflag=0;
        	strcpy(CLEAR,ANSI_CLEAR_SCREEN);
        	strcpy(BOLDON,ANSI_BOLD_ON);
        	strcpy(BOLDOFF,ANSI_BOLD_OFF);
	}
	return(1);	
}
