/*
 * xchrom.c - program which uses the Xchrom widget.
 * Copyright (c) Olaf Heimburger 1990
 * Last edited: Wed Oct 24 12:10:00 1990 by olafh (Olaf Heimburger) on GECKO
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "Xchrom.h"
#include "xchrom.xbm"
#include "xchrom_mask.xbm"
#include "patchlevel.h"

#ifdef ICCCM_COMP
#include <X11/Xmu/Atoms.h>
#endif

#define ever (;;)
#define NAME "CHROMACHRON"

static char *Version = "xchrom, version 1";

main(argc, argv)
    int argc;
    char *argv[];
{
    Widget toplevel, clock_w;
    Arg args[4];
    Pixmap icon_pixmap = None;
#ifdef ICCCM_COMP
    Atom wm_delete_window;
    XEvent event;
#endif
    
    if (argc != 1) {
	printf ("%s Patchlevel: %s \n", Version, PATCHLEVEL);
    }
    toplevel = XtInitialize (argv[0], "XChrom", NULL, 0, &argc, argv);
    XtSetArg (args[0], XtNtitle, NAME);
    XtSetArg (args[1], XtNiconName, NAME);
    XtSetArg (args[2], XtNminWidth, MINWIDTH);
    XtSetArg (args[3], XtNminHeight, MINHEIGHT);
    XtSetValues (toplevel, args, XtNumber (args));
    clock_w = XtCreateManagedWidget (argv[0], xchromWidgetClass, toplevel,
				     NULL, 0);
    /*
     * set the icon bits
     */
    XtSetArg(args[0], XtNiconPixmap, &icon_pixmap);
    XtGetValues(toplevel, &args[0], 1);
    if (icon_pixmap == None) {
	args[0].value =
	    (XtArgVal) XCreateBitmapFromData (XtDisplay (toplevel),
					      (XtScreen (toplevel))->root,
					      xchrom_bits, xchrom_width,
					      xchrom_height);
	XtSetValues (toplevel, &args[0], 1);
    }
    /*
     * set the icon mask bits
     */
    XtSetArg (args[0], XtNiconMask, &icon_pixmap);
    XtGetValues (toplevel, &args[0], 1);
    if (icon_pixmap == None) {
	args[0].value =
	    (XtArgVal) XCreateBitmapFromData (XtDisplay (toplevel),
					      (XtScreen(toplevel))->root,
					      xchrom_mask_bits,
					      xchrom_mask_width, 
					      xchrom_mask_height);
	XtSetValues (toplevel, &args[0], 1);
    }
    XtRealizeWidget (toplevel);
#ifdef ICCCM_COMP
    /*
     * for ICCCM compatibilty
     */
    wm_delete_window =
	XmuInternAtom (XtDisplay (toplevel), XmuMakeAtom ("WM_DELETE_WINDOW"));
    (void) XSetWMProtocols (XtDisplay (toplevel), XtWindow (toplevel),
			    &wm_delete_window, 1);
    for ever {
	XtNextEvent (&event);
	if (event.type == ClientMessage
	    && event.xclient.data.l[0] == wm_delete_window) {
	    XtDestroyWidget (toplevel);
	    exit(1);
	} else {
	    XtDispatchEvent (&event);
	}
    }
#else
    XtMainLoop ();
#endif
}
