.\" t
.\" @(#)GoodStuff.1	1/28/94
.TH GoodStuff 1.20 "Jan 28 1994"
.UC
.SH NAME
GoodStuff \- the FVWM button panel module
.SH SYNOPSIS
GoodStuff is spawned by fvwm, so no command line invocation will work.

.SH DESCRIPTION
The GoodStuff module provides a button panel which sits on the X
terminal's root window. The user can press the buttons at any time,
and trigger invocation of a user-specified command by the window
manager. GoodStuff only works when fvwm is used as the window manager.

The button panel can be of any configuration or geometry, and can have
monochrome or color icons to represent the actions which would be
invoked.

.SH COPYRIGHTS
The GoodStuff program, and the concept for
interfacing this module to the Window Manager, are all original work
by Robert Nation

Copyright 1993, Robert Nation. No guarantees or warranties or anything
are provided or implied in any way whatsoever. Use this program at your
own risk. Permission to use this program for any purpose is given,
as long as the copyright is kept intact. 


.SH INITIALIZATION
During initialization, \fIGoodStuff\fP will search for a configuration
file which describes the button panel geometry, color, icons, and
actions. The format of 
this files will be described later. The configuration file will be the
one which fvwm used during its initialization.

If the GoodStuff executable is linked to another name, ie ln -s
GoodStuff TermStuff, then another module called TermStuff can be
started, with a completely different configuration than GoodStuff,
simply by changing the keywords Good??? to Term???. This way multiple
button-bars can be used.

.SH INVOCATION
GoodStuff can be invoked by inserting the line 'Module GoodStuff' in
the .fvwmrc file. This can be placed on a line by itself, if GoodStuff
is to be spawned during fvwm's initialization, or can be bound to a
menu or mouse button or keystroke to invoke it later. Fvwm will search
directory specified in the ModulePath configuration option to attempt
to locate GoodStuff.

.SH CONFIGURATION OPTIONS
The following options can be placed in the .fvwmrc file

.IP "*GoodStuffGeometry \fIgeometry\fP"
Specifies the GoodStuff window location and/or size. If the size is
not specified, GoodStuff will auto-size itself in a reasonable manner.
The geometry is a standard X11 window geometry specification.

.IP "*GoodStuffFont \fIfont\fP"
Specifies the font to be used for labeling the buttons.

.IP "*GoodStuffRows \fIrows\fP"
Specifies the number of rows of buttons to be created. If unspecified,
2 rows will be used.

.IP "*GoodStuffColumns \fIcolumns\fP"
Specifies the number of columns of buttons to be created. If unspecified,
the number of columns will be set to the number of buttons requested,
divided by the number of rows. If both the rows and columns are
specified, but do not specify as many buttons as are defined, then the
users columns specification will be ignored.

.IP "*GoodStuffFore \fIcolor\fP"
Specifies the color for button label text and monochrome icons.

.IP "*GoodStuffBack \fIcolor\fP"
Specifies the color for the buttons.

.IP "*GoodStuff\fI[(w x h)]\fP \fIlabel icon command\fP"
Specifies a window manager built-in command, as described in the fvwm
man page, which should be executed when a button is pressed. The label
field is the text which will be written on the button. The icon field
specifies an X11 bitmap file or XPM color icon file, containing the
icon to display on the button. GoodStuff will search through the path
specified in the fvwm IconPath or PixmapPath configuration items to
find the icon file. If the optional \fI(w x h)\fP is specified, then
this button will be \fIw\fP times the normal button width and \fIh\fP
times the normal button height. If label is "-" then the button label
will not be displayed.

If \fIcommand\fP is an fvwm Exec command, then the button will remain
pushed in until a window whose name or class matches the
qouted portion of the command is encountered. This is intended to
provide visual feedback to the user that the action he has requested
will be performed. If the qouted portion
contains no characters, then the button will pop out immediately.
Note that users can continue pressing the button, and re-executing the
command, even when it looks "pressed in."

A single extension to the fvwm built-in command set is provided.
A command of the form: *GoodStuff junk clock.xpm Swallow "Clock"
rclock & will cause GoodStuff to spawn an rclock process, and capture 
the first window whose name or resource is "Clock", and display it in
the button-bar. This is handy for applications like xclock, xbiff, and
xload. Modules can be swallowed by specifying  SwallowModule instead
of just "swallow" NOTE: if you use xclock for this application, you will want
to specify xclock -padding 0. 


.SH SAMPLE CONFIGURATION
The following are excepts from a .fvwmrc file which describe GoodStuff
initialization commands:

.nf
.sp
##############################################################
# Load any modules which should be started during 
# fvwm initialization
ModulePath /usr/lib/X11/fvwm:/usr/bin/X11
Module GoodStuff

# Make goodstuff title-bar-less, sticky, and give it an icon	
NoTitle GoodStuff
Sticky GoodStuff
Icon "GoodStuff"    toolbox.xpm

##############################################################
##############################################################
#Definitions used by the modules
*GoodStuffFore Black
*GoodStuffBack #908090

*GoodStuffGeometry -135-5
*GoodStuffRows 1
*GoodStuffFont -adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*

*GoodStuff Resize  resize.xpm  Resize
*GoodStuff Move    arrows2.xpm Move
*GoodStuff Lower   Down        Lower
*GoodStuff Raise   Up          Raise
*GoodStuff Kill    bomb.xpm    Destroy

*GoodStuff Dopey   rterm.xpm   Exec "big_win" xterm -T big_win -geometry 80x50&
*GoodStuff Snoopy  rterm.xpm   Exec "small_win" xterm -T small_wi &
*GoodStuff Xcalc   rcalc.xpm   Exec "Calculator" xcalc &
*GoodStuff XMag    magnifying_glass2.xpm    Exec "xmag" xmag &
*GoodStuff Mail    mail2.xpm   Exec "xmh" xmh &
*GoodStuff(4x1) - whatever SwallowModule "Fvwm Pager" FvwmPager 0 3   
.sp
.fi

The last line is a little tricky - it spawns an FvwmPager module, and
captures it to display in a quadruple width button. Since "-" is used
for the button label, the Pager will be resized to be as big as
possible within the button's borders. "whatever", of course, is a
non-existent icon file, and will be ignored by GoodStuff.

.SH AUTHOR
Robert Nation

