#define	MAINLINE

/*
 *	rbefix
 *
 *	This simple program runs through the specified notesfiles
 *	and sets some fields in the descriptor to default
 *	values.  You'll have to pick which fields you actually
 *	want to change, this will depend on how recent your code is.
 *
 *
 *	Ray Essick	September 6, 1983
 *
 * $Header: /home/ace/master/rmtc/misc/notes/utility/changetime.c,v 1.1 1989/05/15 11:05:00 polk Exp $
 */

#include "../src/parms.h"
#include "../src/structs.h"

main (argc, argv)
char  **argv;
{
    int     i,
            j,
            k;
    int     c;
    int     start;
    int     verbose = 0;
    char   *p,
           *q,
           *r;
    char    cmdline[CMDLEN];
    struct io_f io;
    struct note_f   note;
    int     age = 0;

    startup (argc, argv);				/* common initialization */

    start = 1;
    if (strcmp (argv[1], "-v") == 0)
    {
	start++;
	verbose++;
    }

    while (1)
    {
	printf ("Age: ");
	if (scanf ("%d", &age) == 1)
	    break;
	printf ("need a number\n");
    }


    for (i = start; i < argc; i++)			/* for each notesfile  */
    {
	if (init (&io, argv[i]) < 0)
	{
	    printf ("bong %s\n", argv[i]);
	    continue;
	}
	if (verbose)
	    printf ("%s\n", argv[i]);

	locknf (&io, DSCRLOCK);
	getdscr (&io, &io.descr);			/* grab up to date */

	io.descr.d_archtime = age;
	putdscr (&io, &io.descr);
	unlocknf (&io, DSCRLOCK);
	closenf (&io);

    }
    exit (GOOD);
}
