
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)dialog.c	1.4	NCSA	8/10/87";
#endif lint

/*
** A dialog box package for SunView
**
**	Steve Alexander, NCSA
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

static		Panel_item text_item;	/* must be global so that dialog 
									   can get the text string	*/

extern Frame base_frame;

/*
** perform a dialog with the user
*/

int dialog(result, message, display_length, real_length, defl,ok_only)
char *result;				/* pointer to text returned			*/
char *message;
int display_length;				/* length of item */
int real_length;				/* length of item */
char *defl;
int ok_only;
{
	Frame dialog_box;
	int status;
	int l;

	Frame init_dialog();

	/*
	** initialize the dialog box
	*/

	dialog_box = init_dialog(message, display_length, real_length, defl,
							 ok_only);

	/*
	** wait for input
	*/

	status = (int)window_loop(dialog_box);

	/*
	** read the text
	*/

	(void)strcpy(result, (char *)panel_get_value(text_item));

	l = strlen(result);

	if (l > 0) {
		l--;
		if ((result[l] == '\r') || (result[l] == '\n'))
			result[l] = '\0';
	}

	/*
	** blow away the box
	*/

	window_set(dialog_box, FRAME_NO_CONFIRM, TRUE, 0);
	window_destroy(dialog_box);

	/*
	** tell the caller what they wanted to know
	*/

	return status;

}

/*
** set up the panel and display the box
*/

static Frame init_dialog(message, d, r, s, ok_only)
char *message;
int d, r;
char *s;
int ok_only;
{

	Frame			dialog_window;		/* the basic dialog box frame		*/
	Panel			dialog_panel;		/* the panel that goes on the frame */
	Panel_item		message_item;		/* the dialog box title				*/
	Panel_item		cancel_button;		/* button to cancel					*/
	Panel_item		ok_button;			/* button to proceed				*/
	struct pixrect	*pr;				/* scratch rectangle image			*/
	int				width;
	int				top;
	int				left;
	int				height;
	Rect			*rect;
	Rect			rr;
	void			cancel_ok();
	Panel_setting	eotproc();

	/*
	** create the basic dialog window
	*/

	dialog_window = window_create(0,FRAME, FRAME_SHOW_LABEL, FALSE, 0);

	dialog_panel = window_create(dialog_window,PANEL,PANEL_LAYOUT,
								 PANEL_VERTICAL,
								 PANEL_BLINK_CARET,TRUE,
								 PANEL_LABEL_BOLD,TRUE,0);

	/*
	** create the initial message
	*/

	message_item = panel_create_item(dialog_panel, PANEL_MESSAGE,
									 PANEL_LABEL_STRING, message, 0);

	/*
	** create the box the user types the information into
	*/

	text_item = panel_create_item(dialog_panel,PANEL_TEXT,PANEL_LAYOUT,
								  PANEL_VERTICAL, PANEL_VALUE_STORED_LENGTH,r,
								  PANEL_NOTIFY_STRING,"\r\t\n",
								  PANEL_VALUE,s,
								  PANEL_NOTIFY_PROC,eotproc,
								  PANEL_VALUE_DISPLAY_LENGTH,d,0);

	/*
	** now compute size & location of the action buttons
	*/

	pr = panel_button_image(dialog_panel, " OK ", 6, 0);

	width = pr->pr_width + 10;

	pr = panel_button_image(dialog_panel, "CANCEL", 7, 0);

	width += pr->pr_width;
	width += 10;

	rect = (Rect *) panel_get(text_item, PANEL_ITEM_RECT);

	left = (rect->r_width + (10 * strlen(message)) - width) / 2;

	if (left < 0)
		left = 0;

	top = rect_bottom(rect) + 5;

	/*
	** make the buttons
	*/

	panel_create_item(dialog_panel, PANEL_BUTTON,
					  PANEL_ITEM_X, left, PANEL_ITEM_Y, top,
					  PANEL_LABEL_IMAGE, pr,
					  PANEL_CLIENT_DATA, FALSE,
					  PANEL_NOTIFY_PROC, cancel_ok,0);

	panel_create_item(dialog_panel, PANEL_BUTTON,
					  PANEL_LABEL_IMAGE,
					  panel_button_image(dialog_panel," OK ",6, 0),
					  PANEL_CLIENT_DATA, TRUE,
					  PANEL_NOTIFY_PROC, cancel_ok,0);

	/*
	** make it look nice
	*/

	window_fit(dialog_panel);
	window_fit(dialog_window);

	/*
	** now center the dialog box on the screen
	*/

	win_getsize(window_get(base_frame, WIN_FD), &rr);

	width = (int) window_get(dialog_window, WIN_WIDTH);
	height = (int) window_get(dialog_window, WIN_HEIGHT);

	left = (rr.r_width - width) / 2;
	top = (rr.r_height - height) / 2;

	if (left < 0)
		left = 0;

	if (top < 0)
		top = 0;

	left += (int) window_get(base_frame, WIN_X);
	top += (int) window_get(base_frame, WIN_Y);

	window_set(dialog_window, WIN_X, left, WIN_Y, top, 0);
	return dialog_window;

}

/*
** return TRUE if OK, FALSE if CANCEL -- note: this procedure
** is declared void, the return is handled by window_return.
** This value is used as the return from window_loop in routine
** dialog.
*/

static void cancel_ok(item, event)
Panel_item	item;
Event		*event;
{
	window_return(panel_get(item, PANEL_CLIENT_DATA));
}

static Panel_setting eotproc(item, event)
Panel_item	item;
Event		*event;
{
	char buf[15];
	debug(5,"In eotproc ; ");
	sprintf(buf,"event = %d\r\n",event_id(event));
	debug(5,buf);

	switch (event_id(event)) {
		case '\t':
			return PANEL_INSERT;
		case '\r':
		case '\n':
			window_return(TRUE);
			return PANEL_NONE;

		default:
			return PANEL_INSERT;
	}
			
}
