/*
	Author		: John Plevyak
	Notes		:
	
		Test function to determine performance under various
		conditions.
*/

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <dtmint.h>
#include <time.h>
#include "test.h"
#include "debug.h"


#define	DEFAULT_BLOCK_SIZE	512

char buf[ MAX_BLOCK_SIZE];

static char * testStr = "TestBlk.";
static char	headerbuf[ 250 ];
char * performHeader = 
			"Perform num_msgs %d nmsg %d num_sets %d block_size %d\n"; 

int	DTMtestPerform( outpname, num_msgs, num_sets, block_size )
	char	*outpname;
	int		num_msgs;
	int		num_sets;
	int		block_size;
{
	int		nset;
	int		nmsg;
	int		i;
	int		outport;

	/*
		Check args
	*/
	DBGMSG3( "DTMtestPerform num_msgs %d, num_sets %d, block_size %d\n",
			num_msgs, num_sets, block_size);
	if ( num_msgs <= 0 ) num_msgs = 1;
	if ( num_sets <= 0 ) num_sets = 1;
	if (block_size <= 0 ) block_size = DEFAULT_BLOCK_SIZE;
	if (block_size > MAX_BLOCK_SIZE ) block_size = DEFAULT_BLOCK_SIZE;

	/*
		Set up the test data
	*/
	for ( i = 0 ; i < (MAX_BLOCK_SIZE - sizeof( testStr ) - 1); 
				i += sizeof( testStr ) ) 
		strcpy( &buf[i], testStr );
	/*	
		Open the out port. 
	*/
	if( (outport = DTMmakeOutPort( outpname, DTM_SYNC)) ==DTMERROR){
		fprintf( stderr, "%%Test: Outport open error, %s\n", 
			sherr( DTMerrno ) );
		return 0 ;
	} else 
		if (!quietMode) 
			fprintf( stdout, "%%Test: Outport %s opened\n", outpname );
		
	for ( nmsg = 0 ; nmsg < num_msgs ; nmsg++ ) { 

		/*	Write on outport	*/

		sprintf( headerbuf, performHeader, num_msgs, nmsg + 1, num_sets, 
				block_size  );
		DBGMSG1( "performHeader: [%s]\n", headerbuf );
		if( DTMbeginWrite( outport, headerbuf, sizeof( headerbuf ) + 1) 
					== DTMERROR ){
			fprintf( stderr, "%%Test: ERROR - Outport %d beginWrite, %s\n",
				 outport, sherr( DTMerrno ) );
			return 0 ;
		} else 
			if (!quietMode) fprintf( stdout, "%%Test: Header written\n");

		for ( nset = 0 ; nset < num_sets ; nset++ ) {
			if( DTMwriteDataset( outport, buf, block_size, DTM_CHAR ) 
					== DTMERROR ) {
				fprintf(stderr,"%%Test: ERROR - Outport %d writeDataset: %s\n",
					 outport, sherr( DTMerrno ) );
				return 0 ;
			} else 
				if (!quietMode) fprintf( stdout, 
					"%%Test: Data %d,%d of %d bytes written\n", 
						nset, nmsg, block_size );
		}

		if( DTMendWrite( outport ) == DTMERROR )
		{
			fprintf( stderr, "%%Test: ERROR - Outport %d endWrite, %s\n",
				 outport, sherr( DTMerrno ) );
			return 0 ;
		}	
		else
			if (!quietMode) fprintf( stdout, "%%Test: Write over\n" );
	}
	if (!quietMode) 
		fprintf( stdout, "WriteRead done with (%d, %d) %d\n", num_msgs,
			num_sets, nmsg );

	/*	Close the out port.		*/

	if( DTMdestroyPort( outport ) == DTMERROR ) {
		fprintf( stderr, "%%Test: Outport %d destroy error, %s\n", 
				outport, sherr( DTMerrno ) );
		return 0 ;
	}

	return 1 ;
}
