/*
	Author		: John Plevyak
	Notes		:
	
		Test function for DTMreadReady (the callback for when
		a port is ready for input ).
*/

#include <stdio.h>
#include <dtmint.h>
#include "test.h"
#include "debug.h"

extern	void sleep();

#define	MAX_HEADER_SIZE		250
static char headerbuf[ MAX_HEADER_SIZE ];
static char * callbackHeader = "Callback on port %s\n";
static char buf[ CALLBACK_BLOCK_SIZE ];

int	DTMtestCallback( portname, iter, sleeptime )
	char *		portname;
	int			iter;
	int			sleeptime;
{
	int		outport;

    if ((outport = DTMmakeOutPort( portname, DTM_SYNC)) ==DTMERROR) {
        fprintf( stderr, "%%Test: Outport open error, %s\n",
            sherr( DTMerrno ) );
        return 0 ;
    } else
        if (!quietMode)
            fprintf( stdout, "%%Test: Outport %s opened\n", portname );

	if (!iter) iter = 1;
	if (!sleeptime) sleeptime = 2;
	while (iter--) {
		fprintf(stderr,"Callback out on %d\n", outport );
		sprintf( headerbuf, callbackHeader, portname);
		if( DTMbeginWrite( outport, headerbuf, strlen( headerbuf ) + 1)
					== DTMERROR ){
			fprintf( stderr, "%%Test: ERROR - Outport %d beginWrite, %s\n",
				 outport, sherr( DTMerrno ) );
			return 0 ;
		} else
			if (!quietMode) fprintf( stdout, "%%Test: Header written\n");
		if( DTMwriteDataset( outport, buf, CALLBACK_BLOCK_SIZE, DTM_CHAR )
				== DTMERROR ) {
			fprintf(stderr,"%%Test: ERROR - Outport %d writeDataset: %s\n",
				 outport, sherr( DTMerrno ) );
			return 0 ;
		} else
			if (!quietMode) fprintf( stdout,
				"%%Test: %d bytes written\n", CALLBACK_BLOCK_SIZE);
		sleep(sleeptime);
	}

	if ( DTMendWrite( outport ) == DTMERROR )
	{
		fprintf( stderr, "%%Test: ERROR - Outport %d endWrite, %s\n",
			 outport, sherr( DTMerrno ) );
		return 0 ;
	}
	else
		if (!quietMode) fprintf( stdout, "%%Test: Write over\n" );

    /*  Close the out port.     */

    if( DTMdestroyPort( outport ) == DTMERROR ) {
        fprintf( stderr, "%%Test: Outport %d destroy error, %s\n",
                outport, sherr( DTMerrno ) );
        return 0 ;
    }
	return 1;
}

static	int callbackReady = FALSE;
static	struct { int port, ready; } inport[MAX_PORT_NAMES];

void	DTMtestCallbackFunc ()
{
	int		i;
/* fprintf( stderr, "Callback: ready on port %d\n", port ); */

#if 0
	for (i = 0 ; i < port_count && i < MAX_PORT_NAMES; i++ ) {
		if ( inport[i].port == port )
			inport[i].ready = TRUE;
	}
#endif
	callbackReady = TRUE;
}

int	DTMtestCallbackInput( portnames )
	char **		portnames;
{
	int		iPort = 0;

	port_count = 0;

	while ( portnames[iPort] ) { 
		if ((inport[iPort].port = 
				DTMmakeInPort( portnames[iPort], DTM_SYNC))==DTMERROR) {
			fprintf( stderr, "%%Test: Inport open error, %s\n",
				sherr( DTMerrno ) );
			return 0 ;
		} else if (!quietMode)
			fprintf( stdout, "%%Test: Outport %s opened\n", portnames[iPort] );
		if ( DTMreadReady( inport[iPort].port, DTMtestCallbackFunc )) {
			fprintf( stderr, "%%Test: Callback register error, %s\n",
				sherr( DTMerrno ) );
			return 0 ;
		}
		iPort++;
		port_count++;
    } 

	while (TRUE) {
		int		i;
		sleep(1);
		if ( !callbackReady )  {
			fprintf( stderr, "Callback says not ready\n" );
			continue;
		}
		callbackReady = FALSE;
		if ( DTMavailRead( inport[0].port ) ) {
			fprintf( stderr, "DTMavailRead says ready\n" );
		} else {
			fprintf( stderr, "DTMavailRead says not ready\n" );
			continue;
		}
		fprintf( stderr, "CallbackInput: got some messge\n" );
		for (i = 0 ; i < port_count; i++ ) {
			if ( DTMreadMsg( inport[i].port, headerbuf, MAX_HEADER_SIZE,
					buf, CALLBACK_BLOCK_SIZE + 1, DTM_CHAR ) == DTMERROR ) {
				fprintf( stderr, "%%Test: readMsg error, %s\n",
					sherr( DTMerrno ) );
				return 0;
			}
			fprintf( stderr, "CallbackInput: got message on port %d\n",
				inport[i].port );
		}
	}

	if ( DTMendRead( inport[0].port ) == DTMERROR )
	{
		fprintf( stderr, "%%Test: ERROR - Outport %d endRead, %s\n",
			 inport, sherr( DTMerrno ) );
		return 0 ;
	}
	else
		if (!quietMode) fprintf( stdout, "%%Test: Read over\n" );

    if( DTMdestroyPort( inport[0].port ) == DTMERROR ) {
        fprintf( stderr, "%%Test: Inport %d destroy error, %s\n",
                inport[0].port, sherr( DTMerrno ) );
        return 0 ;
    }
	return 1;
}
