/*
 * Copyright (C) 2010 Maarten Lankhorst for CodeWeavers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef _INC_PROPKEY
#define _INC_PROPKEY

#include <propkeydef.h>

DEFINE_PROPERTYKEY(PKEY_Address_Country, 0xc07b4199,0xe1df,0x4493,0xb1,0xe1,0xde,0x59,0x46,0xfb,0x58,0xf8,100);
DEFINE_PROPERTYKEY(PKEY_Address_CountryCode, 0xc07b4199,0xe1df,0x4493,0xb1,0xe1,0xde,0x59,0x46,0xfb,0x58,0xf8,101);
DEFINE_PROPERTYKEY(PKEY_Address_Region, 0xc07b4199,0xe1df,0x4493,0xb1,0xe1,0xde,0x59,0x46,0xfb,0x58,0xf8,102);
DEFINE_PROPERTYKEY(PKEY_Address_RegionCode, 0xc07b4199,0xe1df,0x4493,0xb1,0xe1,0xde,0x59,0x46,0xfb,0x58,0xf8,103);
DEFINE_PROPERTYKEY(PKEY_Address_Town, 0xc07b4199,0xe1df,0x4493,0xb1,0xe1,0xde,0x59,0x46,0xfb,0x58,0xf8,104);

DEFINE_PROPERTYKEY(PKEY_Audio_ChannelCount, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x80, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 7);
DEFINE_PROPERTYKEY(PKEY_Audio_Compression, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x80, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 10);
DEFINE_PROPERTYKEY(PKEY_Audio_EncodingBitrate, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x70, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 4);
DEFINE_PROPERTYKEY(PKEY_Audio_Format, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x80, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 2);
DEFINE_PROPERTYKEY(PKEY_Audio_IsVariableBitRate, 0xe6822fee, 0x8c17, 0x4d62, 0x82, 0x3c, 0x8e, 0x9c, 0xfc, 0xbd, 0x1d, 0x5c, 100);
DEFINE_PROPERTYKEY(PKEY_Audio_PeakValue, 0x2579e5d0, 0x1116, 0x4084, 0xbd, 0x9a, 0x9b, 0x4f, 0x7c, 0xb4, 0xdf, 0x5e, 100);
DEFINE_PROPERTYKEY(PKEY_Audio_SampleRate, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x80, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 5);
DEFINE_PROPERTYKEY(PKEY_Audio_SampleSize, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x80, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 6);
DEFINE_PROPERTYKEY(PKEY_Audio_StreamName, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x80, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 9);
DEFINE_PROPERTYKEY(PKEY_Audio_StreamNumber, 0x64440490, 0x4c8b, 0x11d1, 0x8b, 0x80, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03, 8);

DEFINE_PROPERTYKEY(PKEY_Calendar_Duration, 0x293ca35a,0x09aa,0x4dd2,0xb1,0x80,0x1f,0xe2,0x45,0x72,0x8a,0x52,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_IsOnline, 0xbfee9149,0xe3e2,0x49a7,0xa8,0x62,0xc0,0x59,0x88,0x14,0x5c,0xec,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_IsRecurring, 0x315b9c8d,0x80a9,0x4ef9,0xae,0x16,0x8e,0x74,0x6d,0xa5,0x1d,0x70,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_Location, 0xf6272d18,0xcecc,0x40b1,0xb2,0x6a,0x39,0x11,0x71,0x7a,0xa7,0xbd,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_OptionalAttendeeAddresses, 0xd55bae5a,0x3892,0x417a,0xa6,0x49,0xc6,0xac,0x5a,0xaa,0xea,0xb3,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_OptionalAttendeeNames, 0x09429607,0x582d,0x437f,0x84,0xc3,0xde,0x93,0xa2,0xb2,0x4c,0x3c,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_OrganizerAddress, 0x744c8242,0x4df5,0x456c,0xab,0x9e,0x01,0x4e,0xfb,0x90,0x21,0xe3,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_OrganizerName, 0xaaa660f9,0x9865,0x458e,0xb4,0x84,0x01,0xbc,0x7f,0xe3,0x97,0x3e,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_ReminderTime, 0x72fc5ba4,0x24f9,0x4011,0x9f,0x3f,0xad,0xd2,0x7a,0xfa,0xd8,0x18,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_RequiredAttendeeAddresses, 0x0ba7d6c3,0x568d,0x4159,0xab,0x91,0x78,0x1a,0x91,0xfb,0x71,0xe5,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_RequiredAttendeeNames, 0xb33af30b,0xf552,0x4584,0x93,0x6c,0xcb,0x93,0xe5,0xcd,0xa2,0x9f,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_Resources, 0x00f58a38,0xc54b,0x4c40,0x86,0x96,0x97,0x23,0x59,0x80,0xea,0xe1,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_ResponseStatus, 0x188c1f91,0x3c40,0x4132,0x9e,0xc5,0xd8,0xb0,0x3b,0x72,0xa8,0xa2,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_ShowTimeAs, 0x5bf396d4,0x5eb2,0x466f,0xbd,0xe9,0x2f,0xb3,0xf2,0x36,0x1d,0x6e,100);
DEFINE_PROPERTYKEY(PKEY_Calendar_ShowTimeAsText, 0x53da57cf,0x62c0,0x45c4,0x81,0xde,0x76,0x10,0xbc,0xef,0xd7,0xf5,100);

DEFINE_PROPERTYKEY(PKEY_Communication_AccountName, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,9);
DEFINE_PROPERTYKEY(PKEY_Communication_DateItemExpires, 0x428040ac,0xa177,0x4c8a,0x97,0x60,0xf6,0xf7,0x61,0x22,0x7f,0x9a,100);
DEFINE_PROPERTYKEY(PKEY_Communication_Direction, 0x8e531030,0xb960,0x4346,0xae,0x0d,0x66,0xbc,0x9a,0x86,0xfb,0x94,100);
DEFINE_PROPERTYKEY(PKEY_Communication_FollowupIconIndex, 0x83a6347e,0x6fe4,0x4f40,0xba,0x9c,0xc4,0x86,0x52,0x40,0xd1,0xf4,100);
DEFINE_PROPERTYKEY(PKEY_Communication_HeaderItem, 0xc9c34f84,0x2241,0x4401,0xb6,0x07,0xbd,0x20,0xed,0x75,0xae,0x7f,100);
DEFINE_PROPERTYKEY(PKEY_Communication_PolicyTag, 0xec0b4191,0xab0b,0x4c66,0x90,0xb6,0xc6,0x63,0x7c,0xde,0xbb,0xab,100);
DEFINE_PROPERTYKEY(PKEY_Communication_SecurityFlags, 0x8619a4b6,0x9f4d,0x4429,0x8c,0x0f,0xb9,0x96,0xca,0x59,0xe3,0x35,100);
DEFINE_PROPERTYKEY(PKEY_Communication_Suffix, 0x807b653a,0x9e91,0x43ef,0x8f,0x97,0x11,0xce,0x04,0xee,0x20,0xc5,100);
DEFINE_PROPERTYKEY(PKEY_Communication_TaskStatus, 0xbe1a72c6,0x9a1d,0x46b7,0xaf,0xe7,0xaf,0xaf,0x8c,0xef,0x49,0x99,100);
DEFINE_PROPERTYKEY(PKEY_Communication_TaskStatusText, 0xa6744477,0xc237,0x475b,0xa0,0x75,0x54,0xf3,0x44,0x98,0x29,0x2a,100);

DEFINE_PROPERTYKEY(PKEY_Computer_DecoratedFreeSpace, 0x9b174b35,0x40ff,0x11d2,0xa2,0x7e,0x00,0xc0,0x4f,0xc3,0x08,0x71,7);

DEFINE_PROPERTYKEY(PKEY_Contact_AccountPictureDynamicVideo, 0x0b8bb018,0x2725,0x4b44,0x92,0xba,0x79,0x33,0xae,0xb2,0xdd,0xe7,2);
DEFINE_PROPERTYKEY(PKEY_Contact_AccountPictureLarge, 0x0b8bb018,0x2725,0x4b44,0x92,0xba,0x79,0x33,0xae,0xb2,0xdd,0xe7,3);
DEFINE_PROPERTYKEY(PKEY_Contact_AccountPictureSmall, 0x0b8bb018,0x2725,0x4b44,0x92,0xba,0x79,0x33,0xae,0xb2,0xdd,0xe7,4);
DEFINE_PROPERTYKEY(PKEY_Contact_Anniversary, 0x9ad5badb,0xcea7,0x4470,0xa0,0x3d,0xb8,0x4e,0x51,0xb9,0x94,0x9e,100);
DEFINE_PROPERTYKEY(PKEY_Contact_AssistantName, 0xcd102c9c,0x5540,0x4a88,0xa6,0xf6,0x64,0xe4,0x98,0x1c,0x8c,0xd1,100);
DEFINE_PROPERTYKEY(PKEY_Contact_AssistantTelephone, 0x9a93244d,0xa7ad,0x4ff8,0x9b,0x99,0x45,0xee,0x4c,0xc0,0x9a,0xf6,100);
DEFINE_PROPERTYKEY(PKEY_Contact_Birthday, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,47);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress, 0x730fb6dd,0xcf7c,0x426b,0xa0,0x3f,0xbd,0x16,0x6c,0xc9,0xee,0x24,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress1Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,119);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress1Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,117);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress1PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,120);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress1Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,118);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress1Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,116);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress2Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,124);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress2Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,122);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress2PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,125);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress2Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,123);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress2Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,121);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress3Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,129);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress3Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,127);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress3PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,130);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress3Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,128);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddress3Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,126);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddressCity, 0x402b5934,0xec5a,0x48c3,0x93,0xe6,0x85,0xe8,0x6a,0x2d,0x93,0x4e,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddressCountry, 0xb0b87314,0xfcf6,0x4feb,0x8d,0xff,0xa5,0x0d,0xa6,0xaf,0x56,0x1c,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddressPostalCode, 0xe1d4a09e,0xd758,0x4cd1,0xb6,0xec,0x34,0xa8,0xb5,0xa7,0x3f,0x80,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddressPostOfficeBox, 0xbc4e71ce,0x17f9,0x48d5,0xbe,0xe9,0x02,0x1d,0xf0,0xea,0x54,0x09,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddressState, 0x446f787f,0x10c4,0x41cb,0xa6,0xc4,0x4d,0x03,0x43,0x55,0x15,0x97,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessAddressStreet, 0xddd1460f,0xc0bf,0x4553,0x8c,0xe4,0x10,0x43,0x3c,0x90,0x8f,0xb0,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessEmailAddresses, 0xf271c659,0x7e5e,0x471f,0xba,0x25,0x7f,0x77,0xb2,0x86,0xf8,0x36,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessFaxNumber, 0x91eff6f3,0x2e27,0x42ca,0x93,0x3e,0x7c,0x99,0x9f,0xbe,0x31,0x0b,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessHomePage, 0x56310920,0x2491,0x4919,0x99,0xce,0xea,0xdb,0x06,0xfa,0xfd,0xb2,100);
DEFINE_PROPERTYKEY(PKEY_Contact_BusinessTelephone, 0x6a15e5a0,0x0a1e,0x4cd7,0xbb,0x8c,0xd2,0xf1,0xb0,0xc9,0x29,0xbc,100);
DEFINE_PROPERTYKEY(PKEY_Contact_CallbackTelephone, 0xbf53d1c3,0x49e0,0x4f7f,0x85,0x67,0x5a,0x82,0x1d,0x8a,0xc5,0x42,100);
DEFINE_PROPERTYKEY(PKEY_Contact_CarTelephone, 0x8fdc6dea,0xb929,0x412b,0xba,0x90,0x39,0x7a,0x25,0x74,0x65,0xfe,100);
DEFINE_PROPERTYKEY(PKEY_Contact_Children, 0xd4729704,0x8ef1,0x43ef,0x90,0x24,0x2b,0xd3,0x81,0x18,0x7f,0xd5,100);
DEFINE_PROPERTYKEY(PKEY_Contact_CompanyMainTelephone, 0x8589e481,0x6040,0x473d,0xb1,0x71,0x7f,0xa8,0x9c,0x27,0x08,0xed,100);
DEFINE_PROPERTYKEY(PKEY_Contact_ConnectedServiceDisplayName, 0x39b77f4f,0xa104,0x4863,0xb3,0x95,0x2d,0xb2,0xad,0x8f,0x7b,0xc1,100);
DEFINE_PROPERTYKEY(PKEY_Contact_ConnectedServiceIdentities, 0x80f41eb8,0xafc4,0x4208,0xaa,0x5f,0xcc,0xe2,0x1a,0x62,0x72,0x81,100);
DEFINE_PROPERTYKEY(PKEY_Contact_ConnectedServiceName, 0xb5c84c9e,0x5927,0x46b5,0xa3,0xcc,0x93,0x3c,0x21,0xb7,0x84,0x69,100);
DEFINE_PROPERTYKEY(PKEY_Contact_ConnectedServiceSupportedActions, 0xa19fb7a9,0x024b,0x4371,0xa8,0xbf,0x4d,0x29,0xc3,0xe4,0xe9,0xc9,100);
DEFINE_PROPERTYKEY(PKEY_Contact_DataSuppliers, 0x9660c283,0xfc3a,0x4a08,0xa0,0x96,0xee,0xd3,0xaa,0xc4,0x6d,0xa2,100);
DEFINE_PROPERTYKEY(PKEY_Contact_Department, 0xfc9f7306,0xff8f,0x4d49,0x9f,0xb6,0x3f,0xfe,0x5c,0x09,0x51,0xec,100);
DEFINE_PROPERTYKEY(PKEY_Contact_DisplayBusinessPhoneNumbers, 0x364028da,0xd895,0x41fe,0xa5,0x84,0x30,0x2b,0x1b,0xb7,0x0a,0x76,100);
DEFINE_PROPERTYKEY(PKEY_Contact_DisplayHomePhoneNumbers, 0x5068bcdf,0xd697,0x4d85,0x8c,0x53,0x1f,0x1c,0xda,0xb0,0x17,0x63,100);
DEFINE_PROPERTYKEY(PKEY_Contact_DisplayMobilePhoneNumbers, 0x9cb0c358,0x9d7a,0x46b1,0xb4,0x66,0xdc,0xc6,0xf1,0xa3,0xd9,0x3d,100);
DEFINE_PROPERTYKEY(PKEY_Contact_DisplayOtherPhoneNumbers, 0x03089873,0x8ee8,0x4191,0xbd,0x60,0xd3,0x1f,0x72,0xb7,0x90,0x0b,100);
DEFINE_PROPERTYKEY(PKEY_Contact_EmailAddress, 0xf8fa7fa3,0xd12b,0x4785,0x8a,0x4e,0x69,0x1a,0x94,0xf7,0xa3,0xe7,100);
DEFINE_PROPERTYKEY(PKEY_Contact_EmailAddress2, 0x38965063,0xedc8,0x4268,0x84,0x91,0xb7,0x72,0x31,0x72,0xcf,0x29,100);
DEFINE_PROPERTYKEY(PKEY_Contact_EmailAddress3, 0x644d37b4,0xe1b3,0x4bad,0xb0,0x99,0x7e,0x7c,0x04,0x96,0x6a,0xca,100);
DEFINE_PROPERTYKEY(PKEY_Contact_EmailAddresses, 0x84d8f337,0x981d,0x44b3,0x96,0x15,0xc7,0x59,0x6d,0xba,0x17,0xe3,100);
DEFINE_PROPERTYKEY(PKEY_Contact_EmailName, 0xcc6f4f24,0x6083,0x4bd4,0x87,0x54,0x67,0x4d,0x0d,0xe8,0x7a,0xb8,100);
DEFINE_PROPERTYKEY(PKEY_Contact_FileAsName, 0xf1a24aa7,0x9ca7,0x40f6,0x89,0xec,0x97,0xde,0xf9,0xff,0xe8,0xdb,100);
DEFINE_PROPERTYKEY(PKEY_Contact_FirstName, 0x14977844,0x6b49,0x4aad,0xa7,0x14,0xa4,0x51,0x3b,0xf6,0x04,0x60,100);
DEFINE_PROPERTYKEY(PKEY_Contact_FullName, 0x635e9051,0x50a5,0x4ba2,0xb9,0xdb,0x4e,0xd0,0x56,0xc7,0x72,0x96,100);
DEFINE_PROPERTYKEY(PKEY_Contact_Gender, 0x3c8cee58,0xd4f0,0x4cf9,0xb7,0x56,0x4e,0x5d,0x24,0x44,0x7b,0xcd,100);
DEFINE_PROPERTYKEY(PKEY_Contact_GenderValue, 0x3c8cee58,0xd4f0,0x4cf9,0xb7,0x56,0x4e,0x5d,0x24,0x44,0x7b,0xcd,101);
DEFINE_PROPERTYKEY(PKEY_Contact_Hobbies, 0x5dc2253f,0x5e11,0x4adf,0x9c,0xfe,0x91,0x0d,0xd0,0x1e,0x3e,0x70,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress, 0x98f98354,0x617a,0x46b8,0x85,0x60,0x5b,0x1b,0x64,0xbf,0x1f,0x89,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress1Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,104);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress1Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,102);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress1PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,105);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress1Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,103);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress1Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,101);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress2Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,109);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress2Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,107);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress2PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,110);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress2Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,108);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress2Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,106);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress3Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,114);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress3Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,112);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress3PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,115);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress3Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,113);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddress3Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,111);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddressCity, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,65);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddressCountry, 0x08a65aa1,0xf4c9,0x43dd,0x9d,0xdf,0xa3,0x3d,0x8e,0x7e,0xad,0x85,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddressPostalCode, 0x8afcc170,0x8a46,0x4b53,0x9e,0xee,0x90,0xba,0xe7,0x15,0x1e,0x62,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddressPostOfficeBox, 0x7b9f6399,0x0a3f,0x4b12,0x89,0xbd,0x4a,0xdc,0x51,0xc9,0x18,0xaf,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddressState, 0xc89a23d0,0x7d6d,0x4eb8,0x87,0xd4,0x77,0x6a,0x82,0xd4,0x93,0xe5,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeAddressStreet, 0x0adef160,0xdb3f,0x4308,0x9a,0x21,0x06,0x23,0x7b,0x16,0xfa,0x2a,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeEmailAddresses, 0x56c90e9d,0x9d46,0x4963,0x88,0x6f,0x2e,0x1c,0xd9,0xa6,0x94,0xef,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeFaxNumber, 0x660e04d6,0x81ab,0x4977,0xa0,0x9f,0x82,0x31,0x31,0x13,0xab,0x26,100);
DEFINE_PROPERTYKEY(PKEY_Contact_HomeTelephone, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,20);
DEFINE_PROPERTYKEY(PKEY_Contact_IMAddress, 0xd68dbd8a,0x3374,0x4b81,0x99,0x72,0x3e,0xc3,0x06,0x82,0xdb,0x3d,100);
DEFINE_PROPERTYKEY(PKEY_Contact_Initials, 0xf3d8f40d,0x50cb,0x44a2,0x97,0x18,0x40,0xcb,0x91,0x19,0x49,0x5d,100);
DEFINE_PROPERTYKEY(PKEY_Contact_JA_CompanyNamePhonetic, 0x897b3694,0xfe9e,0x43e6,0x80,0x66,0x26,0x0f,0x59,0x0c,0x01,0x00,2);
DEFINE_PROPERTYKEY(PKEY_Contact_JA_FirstNamePhonetic, 0x897b3694,0xfe9e,0x43e6,0x80,0x66,0x26,0x0f,0x59,0x0c,0x01,0x00,3);
DEFINE_PROPERTYKEY(PKEY_Contact_JA_LastNamePhonetic, 0x897b3694,0xfe9e,0x43e6,0x80,0x66,0x26,0x0f,0x59,0x0c,0x01,0x00,4);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo1CompanyAddress, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,120);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo1CompanyName, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,102);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo1Department, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,106);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo1Manager, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,105);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo1OfficeLocation, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,104);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo1Title, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,103);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo1YomiCompanyName, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,101);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo2CompanyAddress, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,121);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo2CompanyName, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,108);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo2Department, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,113);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo2Manager, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,112);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo2OfficeLocation, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,110);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo2Title, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,109);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo2YomiCompanyName, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,107);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo3CompanyAddress, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,123);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo3CompanyName, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,115);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo3Department, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,119);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo3Manager, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,118);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo3OfficeLocation, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,117);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo3Title, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,116);
DEFINE_PROPERTYKEY(PKEY_Contact_JobInfo3YomiCompanyName, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,114);
DEFINE_PROPERTYKEY(PKEY_Contact_JobTitle, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,6);
DEFINE_PROPERTYKEY(PKEY_Contact_Label, 0x97b0ad89,0xdf49,0x49cc,0x83,0x4e,0x66,0x09,0x74,0xfd,0x75,0x5b,100);
DEFINE_PROPERTYKEY(PKEY_Contact_LastName, 0x8f367200,0xc270,0x457c,0xb1,0xd4,0xe0,0x7c,0x5b,0xcd,0x90,0xc7,100);
DEFINE_PROPERTYKEY(PKEY_Contact_MailingAddress, 0xc0ac206a,0x827e,0x4650,0x95,0xae,0x77,0xe2,0xbb,0x74,0xfc,0xc9,100);
DEFINE_PROPERTYKEY(PKEY_Contact_MiddleName, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,71);
DEFINE_PROPERTYKEY(PKEY_Contact_MobileTelephone, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,35);
DEFINE_PROPERTYKEY(PKEY_Contact_NickName, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,74);
DEFINE_PROPERTYKEY(PKEY_Contact_OfficeLocation, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,7);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress, 0x508161fa,0x313b,0x43d5,0x83,0xa1,0xc1,0xac,0xcf,0x68,0x62,0x2c,100);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress1Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,134);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress1Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,132);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress1PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,135);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress1Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,133);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress1Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,131);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress2Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,139);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress2Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,137);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress2PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,140);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress2Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,138);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress2Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,136);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress3Country, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,144);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress3Locality, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,142);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress3PostalCode, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,145);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress3Region, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,143);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddress3Street, 0xa7b6f596,0xd678,0x4bc1,0xb0,0x5f,0x02,0x03,0xd2,0x7e,0x8a,0xa1,141);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddressCity, 0x6e682923,0x7f7b,0x4f0c,0xa3,0x37,0xcf,0xca,0x29,0x66,0x87,0xbf,100);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddressCountry, 0x8f167568,0x0aae,0x4322,0x8e,0xd9,0x60,0x55,0xb7,0xb0,0xe3,0x98,100);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddressPostalCode, 0x95c656c1,0x2abf,0x4148,0x9e,0xd3,0x9e,0xc6,0x02,0xe3,0xb7,0xcd,100);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddressPostOfficeBox, 0x8b26ea41,0x058f,0x43f6,0xae,0xcc,0x40,0x35,0x68,0x1c,0xe9,0x77,100);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddressState, 0x71b377d6,0xe570,0x425f,0xa1,0x70,0x80,0x9f,0xae,0x73,0xe5,0x4e,100);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherAddressStreet, 0xff962609,0xb7d6,0x4999,0x86,0x2d,0x95,0x18,0x0d,0x52,0x9a,0xea,100);
DEFINE_PROPERTYKEY(PKEY_Contact_OtherEmailAddresses, 0x11d6336b,0x38c4,0x4ec9,0x84,0xd6,0xeb,0x38,0xd0,0xb1,0x50,0xaf,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PagerTelephone, 0xd6304e01,0xf8f5,0x4f45,0x8b,0x15,0xd0,0x24,0xa6,0x29,0x67,0x89,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PersonalTitle, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,69);
DEFINE_PROPERTYKEY(PKEY_Contact_PhoneNumbersCanonical, 0xd042d2a1,0x927e,0x40b5,0xa5,0x03,0x6e,0xdb,0xd4,0x2a,0x51,0x7e,100);
DEFINE_PROPERTYKEY(PKEY_Contact_Prefix, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,75);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryAddressCity, 0xc8ea94f0,0xa9e3,0x4969,0xa9,0x4b,0x9c,0x62,0xa9,0x53,0x24,0xe0,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryAddressCountry, 0xe53d799d,0x0f3f,0x466e,0xb2,0xff,0x74,0x63,0x4a,0x3c,0xb7,0xa4,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryAddressPostalCode, 0x18bbd425,0xecfd,0x46ef,0xb6,0x12,0x7b,0x4a,0x60,0x34,0xed,0xa0,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryAddressPostOfficeBox, 0xde5ef3c7,0x46e1,0x484e,0x99,0x99,0x62,0xc5,0x30,0x83,0x94,0xc1,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryAddressState, 0xf1176dfe,0x7138,0x4640,0x8b,0x4c,0xae,0x37,0x5d,0xc7,0x0a,0x6d,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryAddressStreet, 0x63c25b20,0x96be,0x488f,0x87,0x88,0xc0,0x9c,0x40,0x7a,0xd8,0x12,100);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryEmailAddress, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,48);
DEFINE_PROPERTYKEY(PKEY_Contact_PrimaryTelephone, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,25);
DEFINE_PROPERTYKEY(PKEY_Contact_Profession, 0x7268af55,0x1ce4,0x4f6e,0xa4,0x1f,0xb6,0xe4,0xef,0x10,0xe4,0xa9,100);
DEFINE_PROPERTYKEY(PKEY_Contact_SpouseName, 0x9d2408b6,0x3167,0x422b,0x82,0xb0,0xf5,0x83,0xb7,0xa7,0xcf,0xe3,100);
DEFINE_PROPERTYKEY(PKEY_Contact_Suffix, 0x176dc63c,0x2688,0x4e89,0x81,0x43,0xa3,0x47,0x80,0x0f,0x25,0xe9,73);
DEFINE_PROPERTYKEY(PKEY_Contact_TelexNumber, 0xc554493c,0xc1f7,0x40c1,0xa7,0x6c,0xef,0x8c,0x06,0x14,0x00,0x3e,100);
DEFINE_PROPERTYKEY(PKEY_Contact_TTYTDDTelephone, 0xaaf16bac,0x2b55,0x45e6,0x9f,0x6d,0x41,0x5e,0xb9,0x49,0x10,0xdf,100);
DEFINE_PROPERTYKEY(PKEY_Contact_WebPage, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,18);
DEFINE_PROPERTYKEY(PKEY_Contact_Webpage2, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,124);
DEFINE_PROPERTYKEY(PKEY_Contact_Webpage3, 0x00f63dd8,0x22bd,0x4a5d,0xba,0x34,0x5c,0xb0,0xb9,0xbd,0xcb,0x03,125);

DEFINE_PROPERTYKEY(PKEY_Title, 0xf29f85e0,0x4ff9,0x1068,0xab,0x91,0x08,0x00,0x2b,0x27,0xb3,0xd9,2);

DEFINE_PROPERTYKEY(PKEY_ItemName, 0x6b8da074,0x3b5c,0x43bc,0x88,0x6f,0x0a,0x2c,0xdc,0xe0,0x0b,0x6f,100);

DEFINE_PROPERTYKEY(PKEY_AppUserModel_ExcludeFromShowInNewInstall, 0x9f4c2855,0x9f79,0x4b39,0xa8,0xd0,0xe1,0xd4,0x2d,0xe1,0xd5,0xf3,8);
DEFINE_PROPERTYKEY(PKEY_AppUserModel_ID, 0x9f4c2855,0x9f79,0x4B39,0xa8,0xd0,0xe1,0xd4,0x2d,0xe1,0xd5,0xf3,5);
DEFINE_PROPERTYKEY(PKEY_AppUserModel_IsDestListSeparator, 0x9f4c2855,0x9f79,0x4b39,0xa8,0xd0,0xe1,0xd4,0x2d,0xe1,0xd5,0xf3,6);
DEFINE_PROPERTYKEY(PKEY_AppUserModel_PreventPinning, 0x9f4c2855,0x9F79,0x4b39,0xa8,0xd0,0xe1,0xd4,0x2d,0xe1,0xd5,0xf3,9);
DEFINE_PROPERTYKEY(PKEY_AppUserModel_RelaunchCommand, 0x9f4c2855,0x9f79,0x4b39,0xa8,0xd0,0xe1,0xd4,0x2d,0xe1,0xd5,0xf3,2);
DEFINE_PROPERTYKEY(PKEY_AppUserModel_RelaunchDisplayNameResource, 0x9f4c2855,0x9f79,0x4b39,0xa8,0xd0,0xe1,0xd4,0x2d,0xe1,0xd5,0xf3,4);
DEFINE_PROPERTYKEY(PKEY_AppUserModel_RelaunchIconResource, 0x9f4c2855,0x9f79,0x4b39,0xa8,0xd0,0xe1,0xd4,0x2d,0xe1,0xd5,0xf3,3);

DEFINE_PROPERTYKEY(PKEY_Media_AuthorUrl, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,32);
DEFINE_PROPERTYKEY(PKEY_Media_AverageLevel, 0x09edd5b6,0xb301,0x43c5,0x99,0x90,0xd0,0x03,0x02,0xef,0xfd,0x46,100);
DEFINE_PROPERTYKEY(PKEY_Media_ClassPrimaryID, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,13);
DEFINE_PROPERTYKEY(PKEY_Media_ClassSecondaryID, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,14);
DEFINE_PROPERTYKEY(PKEY_Media_CollectionGroupID, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,24);
DEFINE_PROPERTYKEY(PKEY_Media_CollectionID, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,25);
DEFINE_PROPERTYKEY(PKEY_Media_ContentDistributor, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,18);
DEFINE_PROPERTYKEY(PKEY_Media_ContentID, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,26);
DEFINE_PROPERTYKEY(PKEY_Media_CreatorApplication, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,27);
DEFINE_PROPERTYKEY(PKEY_Media_CreatorApplicationVersion, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,28);
DEFINE_PROPERTYKEY(PKEY_Media_DateEncoded, 0x2e4b640d,0x5019,0x46d8,0x88,0x81,0x55,0x41,0x4c,0xc5,0xca,0xa0,100);
DEFINE_PROPERTYKEY(PKEY_Media_DateReleased, 0xde41cc29,0x6971,0x4290,0xb4,0x72,0xf5,0x9f,0x2e,0x2f,0x31,0xe2,100);
DEFINE_PROPERTYKEY(PKEY_Media_DlnaProfileID, 0xcfa31b45,0x525d,0x4998,0xbb,0x44,0x3f,0x7d,0x81,0x54,0x2f,0xa4,100);
DEFINE_PROPERTYKEY(PKEY_Media_Duration, 0x64440490,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,3);
DEFINE_PROPERTYKEY(PKEY_Media_DVDID, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,15);
DEFINE_PROPERTYKEY(PKEY_Media_EncodedBy, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,36);
DEFINE_PROPERTYKEY(PKEY_Media_EncodingSettings, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,37);
DEFINE_PROPERTYKEY(PKEY_Media_EpisodeNumber, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,100);
DEFINE_PROPERTYKEY(PKEY_Media_FrameCount, 0x6444048f,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,12);
DEFINE_PROPERTYKEY(PKEY_Media_MCDI, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,16);
DEFINE_PROPERTYKEY(PKEY_Media_MetadataContentProvider, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,17);
DEFINE_PROPERTYKEY(PKEY_Media_Producer, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,22);
DEFINE_PROPERTYKEY(PKEY_Media_PromotionUrl, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,33);
DEFINE_PROPERTYKEY(PKEY_Media_ProtectionType, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,38);
DEFINE_PROPERTYKEY(PKEY_Media_ProviderRating, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,39);
DEFINE_PROPERTYKEY(PKEY_Media_ProviderStyle, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,40);
DEFINE_PROPERTYKEY(PKEY_Media_Publisher, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,30);
DEFINE_PROPERTYKEY(PKEY_Media_SeasonNumber, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,101);
DEFINE_PROPERTYKEY(PKEY_Media_SeriesName, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,42);
DEFINE_PROPERTYKEY(PKEY_Media_SubscriptionContentId, 0x9aebae7a,0x9644,0x487d,0xa9,0x2c,0x65,0x75,0x85,0xed,0x75,0x1a,100);
DEFINE_PROPERTYKEY(PKEY_Media_SubTitle, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,38);
DEFINE_PROPERTYKEY(PKEY_Media_ThumbnailLargePath, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,47);
DEFINE_PROPERTYKEY(PKEY_Media_ThumbnailLargeUri, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,48);
DEFINE_PROPERTYKEY(PKEY_Media_ThumbnailSmallPath, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,49);
DEFINE_PROPERTYKEY(PKEY_Media_ThumbnailSmallUri, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,50);
DEFINE_PROPERTYKEY(PKEY_Media_UniqueFileIdentifier, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,35);
DEFINE_PROPERTYKEY(PKEY_Media_UserNoAutoInfo, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,41);
DEFINE_PROPERTYKEY(PKEY_Media_UserWebUrl, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,34);
DEFINE_PROPERTYKEY(PKEY_Media_Writer, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,23);
DEFINE_PROPERTYKEY(PKEY_Media_Year, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,5);

DEFINE_PROPERTYKEY(PKEY_Message_AttachmentContents, 0x3143bf7c,0x80a8,0x4854,0x88,0x80,0xe2,0xe4,0x01,0x89,0xbd,0xd0,100);
DEFINE_PROPERTYKEY(PKEY_Message_AttachmentNames, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,21);
DEFINE_PROPERTYKEY(PKEY_Message_BccAddress, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,2);
DEFINE_PROPERTYKEY(PKEY_Message_BccName, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,3);
DEFINE_PROPERTYKEY(PKEY_Message_CcAddress, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,4);
DEFINE_PROPERTYKEY(PKEY_Message_CcName, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,5);
DEFINE_PROPERTYKEY(PKEY_Message_ConversationID, 0xdc8f80bd,0xaf1e,0x4289,0x85,0xb6,0x3d,0xfc,0x1b,0x49,0x39,0x92,100);
DEFINE_PROPERTYKEY(PKEY_Message_ConversationIndex, 0xdc8f80bd,0xaf1e,0x4289,0x85,0xb6,0x3d,0xfc,0x1b,0x49,0x39,0x92,101);
DEFINE_PROPERTYKEY(PKEY_Message_DateReceived, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,20);
DEFINE_PROPERTYKEY(PKEY_Message_DateSent, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,19);
DEFINE_PROPERTYKEY(PKEY_Message_Flags, 0xa82d9ee7,0xca67,0x4312,0x96,0x5e,0x22,0x6b,0xce,0xa8,0x50,0x23,100);
DEFINE_PROPERTYKEY(PKEY_Message_FromAddress, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,13);
DEFINE_PROPERTYKEY(PKEY_Message_FromName, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,14);
DEFINE_PROPERTYKEY(PKEY_Message_HasAttachments, 0x9c1fcf74,0x2d97,0x41ba,0xb4,0xae,0xcb,0x2e,0x36,0x61,0xa6,0xe4,8);
DEFINE_PROPERTYKEY(PKEY_Message_IsFwdOrReply, 0x9a9bc088,0x4f6d,0x469e,0x99,0x19,0xe7,0x05,0x41,0x20,0x40,0xf9,100);
DEFINE_PROPERTYKEY(PKEY_Message_MessageClass, 0xcd9ed458,0x08ce,0x418f,0xa7,0x0e,0xf9,0x12,0xc7,0xbb,0x9c,0x5c,103);
DEFINE_PROPERTYKEY(PKEY_Message_Participants, 0x1a9ba605,0x8e7c,0x4d11,0xad,0x7d,0xa5,0x0a,0xda,0x18,0xba,0x1b,2);
DEFINE_PROPERTYKEY(PKEY_Message_ProofInProgress, 0x9098f33c,0x9a7d,0x48a8,0x8d,0xe5,0x2e,0x12,0x27,0xa6,0x4e,0x91,100);
DEFINE_PROPERTYKEY(PKEY_Message_SenderAddress, 0x0be1c8e7,0x1981,0x4676,0xae,0x14,0xfd,0xd7,0x8f,0x05,0xa6,0xe7,100);
DEFINE_PROPERTYKEY(PKEY_Message_SenderName, 0x0da41cfa,0xd224,0x4a18,0xae,0x2f,0x59,0x61,0x58,0xdb,0x4b,0x3a,100);
DEFINE_PROPERTYKEY(PKEY_Message_Store, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,15);
DEFINE_PROPERTYKEY(PKEY_Message_ToAddress, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,16);
DEFINE_PROPERTYKEY(PKEY_Message_ToDoFlags, 0x1f856a9f,0x6900,0x4aba,0x95,0x05,0x2d,0x5f,0x1b,0x4d,0x66,0xcb,100);
DEFINE_PROPERTYKEY(PKEY_Message_ToDoTitle, 0xbccc8a3c,0x8cef,0x42e5,0x9b,0x1c,0xc6,0x90,0x79,0x39,0x8b,0xc7,100);
DEFINE_PROPERTYKEY(PKEY_Message_ToName, 0xe3e0584c,0xb788,0x4a5a,0xbb,0x20,0x7f,0x5a,0x44,0xc9,0xac,0xdd,17);

DEFINE_PROPERTYKEY(PKEY_Music_AlbumArtist, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,13);
DEFINE_PROPERTYKEY(PKEY_Music_AlbumArtistSortOverride, 0xf1fdb4af,0xf78c,0x466c,0xbb,0x05,0x56,0xe9,0x2d,0xb0,0xb8,0xec,103);
DEFINE_PROPERTYKEY(PKEY_Music_AlbumID, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,100);
DEFINE_PROPERTYKEY(PKEY_Music_AlbumTitle, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,4);
DEFINE_PROPERTYKEY(PKEY_Music_AlbumTitleSortOverride, 0x13eb7ffc,0xec89,0x4346,0xb1,0x9d,0xcc,0xc6,0xf1,0x78,0x42,0x23,101);
DEFINE_PROPERTYKEY(PKEY_Music_Artist, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,2);
DEFINE_PROPERTYKEY(PKEY_Music_ArtistSortOverride, 0xdeeb2db5,0x0696,0x4ce0,0x94,0xfe,0xa0,0x1f,0x77,0xa4,0x5f,0xb5,102);
DEFINE_PROPERTYKEY(PKEY_Music_BeatsPerMinute, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,35);
DEFINE_PROPERTYKEY(PKEY_Music_Composer, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,19);
DEFINE_PROPERTYKEY(PKEY_Music_ComposerSortOverride, 0x00bc20a3,0xbd48,0x4085,0x87,0x2c,0xa8,0x8d,0x77,0xf5,0x09,0x7e,105);
DEFINE_PROPERTYKEY(PKEY_Music_Conductor, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,36);
DEFINE_PROPERTYKEY(PKEY_Music_ContentGroupDescription, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,33);
DEFINE_PROPERTYKEY(PKEY_Music_DiscNumber, 0x6afe7437,0x9bcd,0x49c7,0x80,0xfe,0x4a,0x5c,0x65,0xfa,0x58,0x74,104);
DEFINE_PROPERTYKEY(PKEY_Music_DisplayArtist, 0xfd122953,0xfa93,0x4ef7,0x92,0xc3,0x04,0xc9,0x46,0xb2,0xf7,0xc8,100);
DEFINE_PROPERTYKEY(PKEY_Music_Genre, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,11);
DEFINE_PROPERTYKEY(PKEY_Music_InitialKey, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,34);
DEFINE_PROPERTYKEY(PKEY_Music_IsCompilation, 0xc449d5cb,0x9ea4,0x4809,0x82,0xe8,0xaf,0x9d,0x59,0xde,0xd6,0xd1,100);
DEFINE_PROPERTYKEY(PKEY_Music_Lyrics, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,12);
DEFINE_PROPERTYKEY(PKEY_Music_Mood, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,39);
DEFINE_PROPERTYKEY(PKEY_Music_PartOfSet, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,37);
DEFINE_PROPERTYKEY(PKEY_Music_Period, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,31);
DEFINE_PROPERTYKEY(PKEY_Music_SynchronizedLyrics, 0x6b223b6a,0x162e,0x4aa9,0xb3,0x9f,0x05,0xd6,0x78,0xfc,0x6d,0x77,100);
DEFINE_PROPERTYKEY(PKEY_Music_TrackNumber, 0x56a3372e,0xce9c,0x11d2,0x9f,0x0e,0x00,0x60,0x97,0xc6,0x86,0xf6,7);

DEFINE_PROPERTYKEY(PKEY_Video_Compression, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,10);
DEFINE_PROPERTYKEY(PKEY_Video_Director, 0x64440492,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,20);
DEFINE_PROPERTYKEY(PKEY_Video_EncodingBitrate, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,8);
DEFINE_PROPERTYKEY(PKEY_Video_FourCC, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,44);
DEFINE_PROPERTYKEY(PKEY_Video_FrameHeight, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,4);
DEFINE_PROPERTYKEY(PKEY_Video_FrameRate, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,6);
DEFINE_PROPERTYKEY(PKEY_Video_FrameWidth, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,3);
DEFINE_PROPERTYKEY(PKEY_Video_HorizontalAspectRatio, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,42);
DEFINE_PROPERTYKEY(PKEY_Video_IsSpherical, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,100);
DEFINE_PROPERTYKEY(PKEY_Video_IsStereo, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,98);
DEFINE_PROPERTYKEY(PKEY_Video_Orientation, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,99);
DEFINE_PROPERTYKEY(PKEY_Video_SampleSize, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,9);
DEFINE_PROPERTYKEY(PKEY_Video_StreamName, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,2);
DEFINE_PROPERTYKEY(PKEY_Video_StreamNumber, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,11);
DEFINE_PROPERTYKEY(PKEY_Video_TotalBitrate, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,43);
DEFINE_PROPERTYKEY(PKEY_Video_TranscodedForSync, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,46);
DEFINE_PROPERTYKEY(PKEY_Video_VerticalAspectRatio, 0x64440491,0x4c8b,0x11d1,0x8b,0x70,0x08,0x00,0x36,0xb1,0x1a,0x03,45);

DEFINE_PROPERTYKEY(PKEY_Volume_FileSystem, 0x9b174b35,0x40ff,0x11d2,0xa2,0x7e,0x00,0xc0,0x4f,0xc3,0x08,0x71,4);
DEFINE_PROPERTYKEY(PKEY_Volume_IsMappedDrive, 0x149c0b69,0x2c2d,0x48fc,0x80,0x8f,0xd3,0x18,0xd7,0x8c,0x46,0x36,2);
DEFINE_PROPERTYKEY(PKEY_Volume_IsRoot, 0x9b174b35,0x40ff,0x11d2,0xa2,0x7e,0x00,0xc0,0x4f,0xc3,0x08,0x71,10);

#endif /*_INC_PROPKEY*/
